/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.ImageView;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.ReflectionUtils;

public class JosmImageView
extends ImageView {
    private static final int LOADING_FLAG = 1;
    private static final int WIDTH_FLAG = 4;
    private static final int HEIGHT_FLAG = 8;
    private static final int RELOAD_FLAG = 16;
    private static final int RELOAD_IMAGE_FLAG = 32;
    private final Field imageField = JosmImageView.getDeclaredField("image");
    private final Field stateField = JosmImageView.getDeclaredField("state");
    private final Field widthField = JosmImageView.getDeclaredField("width");
    private final Field heightField = JosmImageView.getDeclaredField("height");

    public JosmImageView(Element elem) throws NoSuchFieldException {
        super(elem);
        ReflectionUtils.setObjectsAccessible(this.imageField, this.stateField, this.widthField, this.heightField);
    }

    private static Field getDeclaredField(String name) throws NoSuchFieldException {
        try {
            return ImageView.class.getDeclaredField(name);
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to access field by reflection", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSync() {
        block6: {
            try {
                int s = (Integer)this.stateField.get(this);
                if ((s & 0x20) != 0) {
                    this.doRefreshImage();
                }
                if (((s = ((Integer)this.stateField.get(this)).intValue()) & 0x10) == 0) break block6;
                JosmImageView josmImageView = this;
                synchronized (josmImageView) {
                    this.stateField.set(this, ((Integer)this.stateField.get(this) | 0x10) ^ 0x10);
                }
                this.setPropertiesFromAttributes();
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                Logging.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshImage() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        JosmImageView josmImageView = this;
        synchronized (josmImageView) {
            this.stateField.set(this, ((Integer)this.stateField.get(this) | 1 | 0x20 | 4 | 8) ^ 0x2C);
            this.imageField.set(this, null);
            this.widthField.set(this, 0);
            this.heightField.set(this, 0);
        }
        try {
            this.doLoadImage();
            Method updateImageSize = ImageView.class.getDeclaredMethod("updateImageSize", new Class[0]);
            ReflectionUtils.setObjectsAccessible(updateImageSize);
            updateImageSize.invoke((Object)this, new Object[0]);
        }
        finally {
            josmImageView = this;
            synchronized (josmImageView) {
                this.stateField.set(this, ((Integer)this.stateField.get(this) | 1) ^ 1);
            }
        }
    }

    private void doLoadImage() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        URL src = this.getImageURL();
        if (src != null) {
            String urlStr = src.toExternalForm();
            if (urlStr.endsWith(".svg") || urlStr.endsWith(".svg?format=raw")) {
                ImageIcon imgIcon = new ImageProvider(urlStr).setOptional(true).get();
                this.imageField.set(this, imgIcon != null ? imgIcon.getImage() : null);
            } else {
                Method loadImage = ImageView.class.getDeclaredMethod("loadImage", new Class[0]);
                ReflectionUtils.setObjectsAccessible(loadImage);
                loadImage.invoke((Object)this, new Object[0]);
            }
        } else {
            this.imageField.set(this, null);
        }
    }

    @Override
    public Image getImage() {
        this.doSync();
        return super.getImage();
    }

    @Override
    public AttributeSet getAttributes() {
        this.doSync();
        return super.getAttributes();
    }

    @Override
    public void paint(Graphics g, Shape a) {
        this.doSync();
        super.paint(g, a);
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.doSync();
        return super.getPreferredSpan(axis);
    }

    @Override
    public void setSize(float width, float height) {
        this.doSync();
        super.setSize(width, height);
    }
}

