/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.codegen.RealClassGenerator;
import org.jruby.java.codegen.Reified;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.ivars.VariableAccessorField;
import org.jruby.runtime.ivars.VariableTableManager;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.util.ArraySupport;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.collections.ConcurrentWeakHashMap;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Class"}, parent="Module")
public class RubyClass
extends RubyModule {
    private static final Logger LOG = LoggerFactory.getLogger(RubyClass.class);
    public static final ObjectAllocator CLASS_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyClass clazz = new RubyClass(runtime2);
            clazz.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
            return clazz;
        }
    };
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            IRubyObject object = (IRubyObject)obj;
            marshalStream.registerLinkTarget(object);
            marshalStream.dumpVariables(object.getVariableList());
        }

        @Override
        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject result2 = type2.allocate();
            unmarshalStream.registerLinkTarget(result2);
            unmarshalStream.defaultVariablesUnmarshal(result2);
            return result2;
        }
    };
    private static final boolean DEBUG_REIFY = false;
    protected final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private volatile Map<RubyClass, Object> subclasses;
    public static final int CS_IDX_INITIALIZE = 0;
    private final CallSite[] baseCallSites = new CallSite[CS_NAMES.length];
    private CallSite[] extraCallSites;
    private Class reifiedClass;
    private Map<String, List<Map<Class, Map<String, Object>>>> parameterAnnotations;
    private Map<String, Map<Class, Map<String, Object>>> methodAnnotations;
    private Map<String, Map<Class, Map<String, Object>>> fieldAnnotations;
    private Map<String, Class[]> methodSignatures;
    private Map<String, Class> fieldSignatures;
    private Map<Class, Map<String, Object>> classAnnotations;
    private MarshalTuple cachedDumpMarshal;
    private CacheEntry cachedLoad;
    private final RubyClass realClass;
    private final VariableTableManager variableTableManager;

    public static void createClassClass(Ruby runtime2, RubyClass classClass) {
        classClass.setClassIndex(ClassIndex.CLASS);
        classClass.setReifiedClass(RubyClass.class);
        classClass.kindOf = new RubyModule.JavaClassKindOf(RubyClass.class);
        classClass.undefineMethod("module_function");
        classClass.undefineMethod("append_features");
        classClass.undefineMethod("prepend_features");
        classClass.undefineMethod("extend_object");
        classClass.undefineMethod("refine");
        classClass.defineAnnotatedMethods(RubyClass.class);
        runtime2.setBaseNewMethod(classClass.searchMethod("new"));
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator allocator) {
        this.allocator = allocator;
    }

    public void setClassAllocator(final Class cls) {
        this.allocator = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                try {
                    RubyBasicObject object = (RubyBasicObject)cls.newInstance();
                    object.setMetaClass(klazz);
                    return object;
                }
                catch (InstantiationException ie) {
                    throw runtime2.newTypeError("could not allocate " + cls + " with default constructor:\n" + ie);
                }
                catch (IllegalAccessException iae) {
                    throw runtime2.newSecurityError("could not allocate " + cls + " due to inaccessible default constructor:\n" + iae);
                }
            }
        };
        this.reifiedClass = cls;
    }

    public void setRubyClassAllocator(final Class<? extends IRubyObject> clazz) {
        try {
            final Constructor<? extends IRubyObject> constructor2 = clazz.getConstructor(Ruby.class, RubyClass.class);
            this.allocator = new ObjectAllocator(){

                @Override
                public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                    try {
                        return (IRubyObject)constructor2.newInstance(runtime2, klazz);
                    }
                    catch (InvocationTargetException ite) {
                        throw runtime2.newTypeError("could not allocate " + clazz + " with (Ruby, RubyClass) constructor:\n" + ite);
                    }
                    catch (InstantiationException ie) {
                        throw runtime2.newTypeError("could not allocate " + clazz + " with (Ruby, RubyClass) constructor:\n" + ie);
                    }
                    catch (IllegalAccessException iae) {
                        throw runtime2.newSecurityError("could not allocate " + clazz + " due to inaccessible (Ruby, RubyClass) constructor:\n" + iae);
                    }
                }
            };
            this.reifiedClass = clazz;
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public void setRubyStaticAllocator(final Class<?> clazz) {
        try {
            final Method method2 = clazz.getDeclaredMethod("__allocate__", Ruby.class, RubyClass.class);
            this.allocator = new ObjectAllocator(){

                @Override
                public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                    try {
                        return (IRubyObject)method2.invoke(null, runtime2, klazz);
                    }
                    catch (InvocationTargetException ite) {
                        throw runtime2.newTypeError("could not allocate " + clazz + " with (Ruby, RubyClass) constructor:\n" + ite);
                    }
                    catch (IllegalAccessException iae) {
                        throw runtime2.newSecurityError("could not allocate " + clazz + " due to inaccessible (Ruby, RubyClass) constructor:\n" + iae);
                    }
                }
            };
            this.reifiedClass = clazz;
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (this.superClass == null && this != this.runtime.getBasicObject()) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject obj = this.allocator.allocate(this.runtime, this);
        if (RubyClass.getMetaClass(obj).getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return obj;
    }

    public CallSite getBaseCallSite(int idx) {
        return this.baseCallSites[idx];
    }

    public CallSite[] getBaseCallSites() {
        return this.baseCallSites;
    }

    public CallSite[] getExtraCallSites() {
        return this.extraCallSites;
    }

    public VariableTableManager getVariableTableManager() {
        return this.variableTableManager;
    }

    public boolean hasObjectID() {
        return this.variableTableManager.hasObjectID();
    }

    public Map<String, VariableAccessor> getVariableAccessorsForRead() {
        return this.variableTableManager.getVariableAccessorsForRead();
    }

    public VariableAccessor getVariableAccessorForWrite(String name2) {
        return this.variableTableManager.getVariableAccessorForWrite(name2);
    }

    public VariableAccessor getVariableAccessorForRead(String name2) {
        VariableAccessor accessor = this.getVariableAccessorsForRead().get(name2);
        if (accessor == null) {
            accessor = VariableAccessor.DUMMY_ACCESSOR;
        }
        return accessor;
    }

    public VariableAccessor getFFIHandleAccessorForRead() {
        return this.variableTableManager.getFFIHandleAccessorForRead();
    }

    public VariableAccessor getFFIHandleAccessorForWrite() {
        return this.variableTableManager.getFFIHandleAccessorForWrite();
    }

    public VariableAccessor getObjectGroupAccessorForRead() {
        return this.variableTableManager.getObjectGroupAccessorForRead();
    }

    public VariableAccessor getObjectGroupAccessorForWrite() {
        return this.variableTableManager.getObjectGroupAccessorForWrite();
    }

    public int getVariableTableSize() {
        return this.variableTableManager.getVariableTableSize();
    }

    public int getVariableTableSizeWithExtras() {
        return this.variableTableManager.getVariableTableSizeWithExtras();
    }

    public String[] getVariableNames() {
        return this.variableTableManager.getVariableNames();
    }

    public Map<String, VariableAccessor> getVariableTableCopy() {
        return new HashMap<String, VariableAccessor>(this.getVariableAccessorsForRead());
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.CLASS;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby runtime2, String name2, RubyClass superClass, ObjectAllocator allocator) {
        RubyClass obj;
        if (superClass == null) {
            obj = new RubyClass(runtime2);
            obj.marshal = DEFAULT_OBJECT_MARSHAL;
        } else {
            obj = new RubyClass(runtime2, superClass);
        }
        obj.setAllocator(allocator);
        obj.setBaseName(name2);
        return obj;
    }

    protected RubyClass(Ruby runtime2, RubyClass superClass, boolean objectSpace) {
        super(runtime2, runtime2.getClassClass(), objectSpace);
        for (int i2 = 0; i2 < this.baseCallSites.length; ++i2) {
            this.baseCallSites[i2] = MethodIndex.getFunctionalCallSite(CS_NAMES.fromOrdinal((int)i2).id);
        }
        this.cachedDumpMarshal = MarshalTuple.NULL_TUPLE;
        this.cachedLoad = CacheEntry.NULL_CACHE;
        this.runtime = runtime2;
        if (superClass == null) {
            this.realClass = null;
            this.variableTableManager = new VariableTableManager(this);
        } else {
            this.realClass = superClass.realClass;
            this.variableTableManager = this.realClass != null ? this.realClass.variableTableManager : new VariableTableManager(this);
        }
        this.setSuperClass(superClass);
    }

    protected RubyClass(Ruby runtime2) {
        super(runtime2, runtime2.getClassClass());
        for (int i2 = 0; i2 < this.baseCallSites.length; ++i2) {
            this.baseCallSites[i2] = MethodIndex.getFunctionalCallSite(CS_NAMES.fromOrdinal((int)i2).id);
        }
        this.cachedDumpMarshal = MarshalTuple.NULL_TUPLE;
        this.cachedLoad = CacheEntry.NULL_CACHE;
        this.runtime = runtime2;
        this.realClass = this;
        this.variableTableManager = new VariableTableManager(this);
        this.setClassIndex(ClassIndex.CLASS);
    }

    protected RubyClass(Ruby runtime2, RubyClass superClazz) {
        this(runtime2);
        this.setSuperClass(superClazz);
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.allocator = superClazz.allocator;
        this.infectBy(this.superClass);
    }

    protected RubyClass(Ruby runtime2, RubyClass superClazz, CallSite[] extraCallSites) {
        this(runtime2);
        this.setSuperClass(superClazz);
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.extraCallSites = extraCallSites;
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass) {
        if (superClass == runtime2.getClassClass()) {
            throw runtime2.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime2.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime2, superClass);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, CallSite[] extraCallSites) {
        if (superClass == runtime2.getClassClass()) {
            throw runtime2.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime2.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime2, superClass, extraCallSites);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent) {
        RubyClass clazz = RubyClass.newClass(runtime2, superClass);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent, CallSite[] extraCallSites) {
        RubyClass clazz = RubyClass.newClass(runtime2, superClass, extraCallSites);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    RubyClass toSingletonClass(RubyBasicObject target) {
        return target.makeMetaClass(this);
    }

    public boolean notVisibleAndNotMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return !method2.isCallableFrom(caller2, callType) && !name2.equals("method_missing");
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2);
    }

    public IRubyObject invokePublic(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2) || method2.getVisibility() != Visibility.PUBLIC) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    public final IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, String name2) {
        return this.checkFuncallDefault(context, self2, name2, IRubyObject.NULL_ARRAY);
    }

    public final IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites) {
        return this.checkFuncallDefault(context, self2, sites);
    }

    public final IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return this.checkFuncallDefault(context, self2, name2, args2);
    }

    public final IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites, IRubyObject ... args2) {
        return this.checkFuncallDefault(context, self2, sites, args2);
    }

    private IRubyObject checkFuncallDefault(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2) {
        RubyClass klass = this;
        if (!RubyClass.checkFuncallRespondTo(context, klass, self2, name2)) {
            return null;
        }
        DynamicMethod method2 = this.searchMethod(name2);
        if (!RubyClass.checkFuncallCallable(context, method2, CallType.FUNCTIONAL, self2)) {
            return RubyClass.checkFuncallMissing(context, klass, self2, name2, args2);
        }
        return method2.call(context, self2, (RubyModule)klass, name2, args2);
    }

    private IRubyObject checkFuncallDefault(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites, IRubyObject[] args2) {
        RubyClass klass = this;
        if (!RubyClass.checkFuncallRespondTo(context, klass, self2, sites.respond_to_X)) {
            return null;
        }
        CacheEntry entry = sites.site.retrieveCache(klass);
        DynamicMethod method2 = entry.method;
        if (!RubyClass.checkFuncallCallable(context, method2, CallType.FUNCTIONAL, self2)) {
            return RubyClass.checkFuncallMissing(context, klass, self2, sites.methodName, sites.respond_to_missing, sites.method_missing, args2);
        }
        return method2.call(context, self2, entry.sourceModule, sites.methodName, args2);
    }

    private IRubyObject checkFuncallDefault(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites) {
        RubyClass klass = this;
        if (!RubyClass.checkFuncallRespondTo(context, klass, self2, sites.respond_to_X)) {
            return null;
        }
        CacheEntry entry = sites.site.retrieveCache(klass);
        DynamicMethod method2 = entry.method;
        if (!RubyClass.checkFuncallCallable(context, method2, CallType.FUNCTIONAL, self2)) {
            return RubyClass.checkFuncallMissing(context, klass, self2, sites.methodName, sites.respond_to_missing, sites.method_missing, new IRubyObject[0]);
        }
        return method2.call(context, self2, entry.sourceModule, sites.methodName);
    }

    private static IRubyObject checkFuncallExec(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return self2.callMethod(context, "method_missing", ArraySupport.newCopy(context.runtime.newSymbol(name2), args2));
    }

    private static IRubyObject checkFuncallExec(ThreadContext context, IRubyObject self2, String name2, CallSite methodMissingSite, IRubyObject ... args2) {
        return methodMissingSite.call(context, self2, self2, ArraySupport.newCopy(context.runtime.newSymbol(name2), args2));
    }

    private static IRubyObject checkFuncallFailed(ThreadContext context, IRubyObject self2, String name2, RubyClass expClass, IRubyObject ... args2) {
        if (self2.respondsTo(name2)) {
            throw context.runtime.newRaiseException(expClass, name2);
        }
        return null;
    }

    private static boolean checkFuncallRespondTo(ThreadContext context, RubyClass klass, IRubyObject recv2, String mid) {
        Ruby runtime2 = context.runtime;
        CacheEntry entry = klass.searchWithCache("respond_to?");
        DynamicMethod me = entry.method;
        if (me != null && !me.isUndefined() && !me.isBuiltin()) {
            int arityValue = me.getArity().getValue();
            if (arityValue > 2) {
                throw runtime2.newArgumentError("respond_to? must accept 1 or 2 arguments (requires " + arityValue + ")");
            }
            IRubyObject result2 = arityValue == 1 ? me.call(context, recv2, entry.sourceModule, "respond_to?", runtime2.newSymbol(mid)) : me.call(context, recv2, entry.sourceModule, "respond_to?", (IRubyObject)runtime2.newSymbol(mid), runtime2.getTrue());
            return result2.isTrue();
        }
        return true;
    }

    private static boolean checkFuncallRespondTo(ThreadContext context, RubyClass klass, IRubyObject recv2, RespondToCallSite respondToSite) {
        Ruby runtime2 = context.runtime;
        DynamicMethod me = respondToSite.retrieveCache((RubyClass)klass).method;
        if (me != null && !me.isUndefined() && !me.isBuiltin()) {
            int arityValue = me.getArity().getValue();
            if (arityValue > 2) {
                throw runtime2.newArgumentError("respond_to? must accept 1 or 2 arguments (requires " + arityValue + ")");
            }
            boolean result2 = arityValue == 1 ? respondToSite.respondsTo(context, recv2, recv2) : respondToSite.respondsTo(context, recv2, recv2, true);
            return result2;
        }
        return true;
    }

    public static boolean checkFuncallCallable(ThreadContext context, DynamicMethod method2, CallType callType, IRubyObject self2) {
        return RubyClass.rbMethodCallStatus(context, method2, callType, self2);
    }

    public static boolean rbMethodCallStatus(ThreadContext context, DynamicMethod method2, CallType callType, IRubyObject self2) {
        return method2 != null && !method2.isUndefined() && method2.isCallableFrom(self2, callType);
    }

    private static IRubyObject checkFuncallMissing(ThreadContext context, RubyClass klass, IRubyObject self2, String method2, IRubyObject ... args2) {
        IRubyObject ret;
        Ruby runtime2 = context.runtime;
        CacheEntry entry = klass.searchWithCache("respond_to_missing?");
        DynamicMethod me = entry.method;
        if (!(me == null || me.isUndefined() || me.isBuiltin() || (ret = me.getArity().getValue() == 1 ? me.call(context, self2, entry.sourceModule, "respond_to_missing?", runtime2.newSymbol(method2)) : me.call(context, self2, entry.sourceModule, "respond_to_missing?", (IRubyObject)runtime2.newSymbol(method2), runtime2.getTrue())).isTrue())) {
            return null;
        }
        if (klass.isMethodBuiltin("method_missing")) {
            return null;
        }
        IRubyObject $ex = context.getErrorInfo();
        try {
            return RubyClass.checkFuncallExec(context, self2, method2, args2);
        }
        catch (RaiseException e) {
            context.setErrorInfo($ex);
            return RubyClass.checkFuncallFailed(context, self2, method2, runtime2.getNoMethodError(), args2);
        }
    }

    private static IRubyObject checkFuncallMissing(ThreadContext context, RubyClass klass, IRubyObject self2, String method2, CachingCallSite respondToMissingSite, CachingCallSite methodMissingSite, IRubyObject ... args2) {
        IRubyObject ret;
        Ruby runtime2 = context.runtime;
        CacheEntry entry = respondToMissingSite.retrieveCache(klass);
        DynamicMethod me = entry.method;
        if (!(me == null || me.isUndefined() || me.isBuiltin() || (ret = me.getArity().getValue() == 1 ? me.call(context, self2, entry.sourceModule, "respond_to_missing?", runtime2.newSymbol(method2)) : me.call(context, self2, entry.sourceModule, "respond_to_missing?", (IRubyObject)runtime2.newSymbol(method2), runtime2.getTrue())).isTrue())) {
            return null;
        }
        if (methodMissingSite.retrieveCache((RubyClass)klass).method.isBuiltin()) {
            return null;
        }
        IRubyObject $ex = context.getErrorInfo();
        try {
            return RubyClass.checkFuncallExec(context, self2, method2, methodMissingSite, args2);
        }
        catch (RaiseException e) {
            context.setErrorInfo($ex);
            return RubyClass.checkFuncallFailed(context, self2, method2, runtime2.getNoMethodError(), args2);
        }
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpReifiedClass(String dumpDir, String javaPath, byte[] classBytes) {
        if (dumpDir != null) {
            if (dumpDir.length() == 0) {
                dumpDir = ".";
            }
            FileOutputStream classStream = null;
            try {
                File classFile = new File(dumpDir, javaPath + ".class");
                classFile.getParentFile().mkdirs();
                classStream = new FileOutputStream(classFile);
                classStream.write(classBytes);
            }
            catch (IOException io2) {
                this.getRuntime().getWarnings().warn("unable to dump class file: " + io2.getMessage());
            }
            finally {
                if (classStream != null) {
                    try {
                        classStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void generateMethodAnnotations(Map<Class, Map<String, Object>> methodAnnos, SkinnyMethodAdapter m, List<Map<Class, Map<String, Object>>> parameterAnnos) {
        if (methodAnnos != null && methodAnnos.size() != 0) {
            for (Map.Entry<Class, Map<String, Object>> entry : methodAnnos.entrySet()) {
                m.visitAnnotationWithFields(CodegenUtils.ci(entry.getKey()), true, entry.getValue());
            }
        }
        if (parameterAnnos != null && parameterAnnos.size() != 0) {
            for (int i2 = 0; i2 < parameterAnnos.size(); ++i2) {
                Map<Class, Map<String, Object>> annos = parameterAnnos.get(i2);
                if (annos == null || annos.size() == 0) continue;
                for (Map.Entry<Class, Map<String, Object>> entry : annos.entrySet()) {
                    m.visitParameterAnnotationWithFields(i2, CodegenUtils.ci(entry.getKey()), true, entry.getValue());
                }
            }
        }
    }

    private boolean shouldCallMethodMissing(DynamicMethod method2) {
        return method2.isUndefined();
    }

    private boolean shouldCallMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return method2.isUndefined() || this.notVisibleAndNotMethodMissing(method2, name2, caller2, callType);
    }

    public IRubyObject invokeInherited(ThreadContext context, IRubyObject self2, IRubyObject subclass) {
        CacheEntry entry = this.getMetaClass().searchWithCache("inherited");
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), "inherited", CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, "inherited", subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"new"}, omit=true)
    public IRubyObject newInstance(ThreadContext context, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, omit=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, omit=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, arg1, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, omit=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, arg1, arg2, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, rest=true, omit=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, args2, block);
        return obj;
    }

    @Override
    public IRubyObject initialize(ThreadContext context, Block block) {
        return this.initialize19(context, block);
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject superObject, Block block) {
        return this.initialize19(context, superObject, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, Block block) {
        this.checkNotInitialized();
        return this.initializeCommon(context, this.runtime.getObject(), block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, IRubyObject superObject, Block block) {
        this.checkNotInitialized();
        RubyClass.checkInheritable(superObject);
        return this.initializeCommon(context, (RubyClass)superObject, block);
    }

    private RubyClass initializeCommon(ThreadContext context, RubyClass superClazz, Block block) {
        this.setSuperClass(superClazz);
        this.allocator = superClazz.allocator;
        this.makeMetaClass(superClazz.getMetaClass());
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.inherit(superClazz);
        super.initialize(context, block);
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        this.checkNotInitialized();
        if (original instanceof MetaClass) {
            throw this.runtime.newTypeError("can't copy singleton class");
        }
        super.initialize_copy(original);
        this.allocator = ((RubyClass)original).allocator;
        return this;
    }

    protected void setModuleSuperClass(RubyClass superClass) {
        if (this.superClass != null) {
            this.superClass.removeSubclass(this);
        }
        superClass.addSubclass(this);
        this.setSuperClass(superClass);
    }

    public final Collection<RubyClass> subclasses() {
        return this.subclasses(false);
    }

    public Collection<RubyClass> subclasses(boolean includeDescendants) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 != null) {
            ArrayList<RubyClass> mine = new ArrayList<RubyClass>();
            this.subclassesInner(mine, includeDescendants);
            return mine;
        }
        return Collections.EMPTY_LIST;
    }

    private void subclassesInner(Collection<RubyClass> mine, boolean includeDescendants) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 != null) {
            Set<RubyClass> keys2 = subclasses2.keySet();
            mine.addAll(keys2);
            if (includeDescendants) {
                for (RubyClass klass : keys2) {
                    klass.subclassesInner(mine, includeDescendants);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubclass(RubyClass subclass) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 == null) {
            RubyClass rubyClass = this;
            synchronized (rubyClass) {
                subclasses2 = this.subclasses;
                if (subclasses2 == null) {
                    this.subclasses = subclasses2 = new ConcurrentWeakHashMap<RubyClass, Object>(4, 0.75f, 1);
                }
            }
        }
        subclasses2.put(subclass, NEVER);
    }

    public void removeSubclass(RubyClass subclass) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 == null) {
            return;
        }
        subclasses2.remove(subclass);
    }

    public void replaceSubclass(RubyClass subclass, RubyClass newSubclass) {
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 == null) {
            return;
        }
        subclasses2.remove(subclass);
        subclasses2.put(newSubclass, NEVER);
    }

    @Override
    public void becomeSynchronized() {
        super.becomeSynchronized();
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 != null) {
            for (RubyClass subclass : subclasses2.keySet()) {
                subclass.becomeSynchronized();
            }
        }
    }

    @Override
    public void invalidateCacheDescendants() {
        super.invalidateCacheDescendants();
        Map<RubyClass, Object> subclasses2 = this.subclasses;
        if (subclasses2 != null) {
            for (RubyClass subclass : subclasses2.keySet()) {
                subclass.invalidateCacheDescendants();
            }
        }
    }

    public void addInvalidatorsAndFlush(List<Invalidator> invalidators) {
        Map<RubyClass, Object> subclasses2;
        invalidators.add(this.methodInvalidator);
        if (!this.runtime.isBootingCore()) {
            this.cachedMethods.clear();
        }
        if ((subclasses2 = this.subclasses) == null || subclasses2.isEmpty()) {
            return;
        }
        for (RubyClass subclass : subclasses2.keySet()) {
            subclass.addInvalidatorsAndFlush(invalidators);
        }
    }

    public final Ruby getClassRuntime() {
        return this.runtime;
    }

    public final RubyClass getRealClass() {
        return this.realClass;
    }

    @JRubyMethod(name={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject inherited(ThreadContext context, IRubyObject arg2) {
        return context.nil;
    }

    public void inherit(RubyClass superClazz) {
        if (superClazz == null) {
            superClazz = this.runtime.getObject();
        }
        if (this.getRuntime().getNil() != null) {
            superClazz.invokeInherited(this.runtime.getCurrentContext(), superClazz, this);
        }
    }

    @JRubyMethod(name={"superclass"})
    public IRubyObject superclass(ThreadContext context) {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            if (this.metaClass == this.runtime.getBasicObject().getMetaClass()) {
                return context.nil;
            }
            throw this.runtime.newTypeError("uninitialized class");
        }
        while (superClazz != null && (superClazz.isIncluded() || superClazz.isPrepended())) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : context.nil;
    }

    private void checkNotInitialized() {
        if (this.superClass != null || this == this.runtime.getBasicObject()) {
            throw this.runtime.newTypeError("already initialized class");
        }
    }

    public static void checkInheritable(IRubyObject superClass) {
        if (!(superClass instanceof RubyClass)) {
            throw superClass.getRuntime().newTypeError("superclass must be a Class (" + superClass.getMetaClass() + " given)");
        }
        if (((RubyClass)superClass).isSingleton()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of virtual class");
        }
        if (superClass == superClass.getRuntime().getClassClass()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of Class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal marshal) {
        this.marshal = marshal;
    }

    public final void marshal(Object obj, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.runtime, obj, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.runtime, this, unmarshalStream);
    }

    public static void marshalTo(RubyClass clazz, MarshalStream output) throws IOException {
        output.registerLinkTarget(clazz);
        output.writeString(MarshalStream.getPathFromClass(clazz));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyClass result2 = UnmarshalStream.getClassFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result2);
        return result2;
    }

    public boolean isReifiable() {
        RubyClass realSuper;
        if (this.reifiedClass != null) {
            return false;
        }
        if (this.superClass == null || (realSuper = this.superClass.getRealClass()) == null) {
            return false;
        }
        Class reifiedSuper = realSuper.reifiedClass;
        if (reifiedSuper != null) {
            return reifiedSuper == RubyObject.class || reifiedSuper == RubyBasicObject.class || Reified.class.isAssignableFrom(reifiedSuper);
        }
        return realSuper.isReifiable();
    }

    public void reifyWithAncestors() {
        this.reifyWithAncestors(null, true);
    }

    public void reifyWithAncestors(String classDumpDir) {
        this.reifyWithAncestors(classDumpDir, true);
    }

    public void reifyWithAncestors(boolean useChildLoader) {
        this.reifyWithAncestors(null, useChildLoader);
    }

    public void reifyWithAncestors(String classDumpDir, boolean useChildLoader) {
        if (this.isReifiable()) {
            RubyClass realSuper = this.getSuperClass().getRealClass();
            if (realSuper.reifiedClass == null) {
                realSuper.reifyWithAncestors(classDumpDir, useChildLoader);
            }
            this.reify(classDumpDir, useChildLoader);
        }
    }

    public final void reify() {
        this.reify(null, true);
    }

    public final void reify(String classDumpDir) {
        this.reify(classDumpDir, true);
    }

    public final void reify(boolean useChildLoader) {
        this.reify(null, useChildLoader);
    }

    public synchronized void reify(String classDumpDir, boolean useChildLoader) {
        if (!this.isReifiable()) {
            return;
        }
        String name2 = this.getBaseName() != null ? this.getName() : "Class_0x" + Integer.toHexString(System.identityHashCode(this));
        String javaName = "rubyobj." + StringSupport.replaceAll(name2, "::", ".");
        String javaPath = "rubyobj/" + StringSupport.replaceAll(name2, "::", "/");
        Class<? extends IRubyObject> parentReified = this.superClass.getRealClass().getReifiedClass();
        if (parentReified == null) {
            throw this.getClassRuntime().newTypeError(this.getName() + "'s parent class is not yet reified");
        }
        Class reifiedParent = RubyObject.class;
        if (this.superClass.reifiedClass != null) {
            reifiedParent = this.superClass.reifiedClass;
        }
        byte[] classBytes = new MethodReificator(reifiedParent, javaName, javaPath).reify();
        ClassLoader parentCL = parentReified.getClassLoader() instanceof OneShotClassLoader ? (OneShotClassLoader)parentReified.getClassLoader() : (useChildLoader ? new OneShotClassLoader(this.runtime.getJRubyClassLoader()) : this.runtime.getJRubyClassLoader());
        try {
            Class<?> result2 = parentCL.defineClass(javaName, classBytes);
            this.dumpReifiedClass(classDumpDir, javaPath, classBytes);
            Method clinit = result2.getDeclaredMethod("clinit", Ruby.class, RubyClass.class);
            clinit.invoke(null, this.runtime, this);
            this.setClassAllocator(result2);
            this.reifiedClass = result2;
            return;
        }
        catch (LinkageError error2) {
            String msg = error2.getMessage();
            if (msg != null && msg.contains("duplicate class definition for name")) {
                this.logReifyException(error2, false);
            } else {
                this.logReifyException(error2, true);
            }
        }
        catch (Exception ex) {
            this.logReifyException(ex, true);
        }
        if (this.superClass.reifiedClass != null) {
            this.reifiedClass = this.superClass.reifiedClass;
            this.allocator = this.superClass.allocator;
        }
    }

    private boolean isVarArgsSignature(String method2, Class[] methodSignature) {
        return methodSignature.length > 1 && methodSignature[methodSignature.length - 1].isArray();
    }

    private void logReifyException(Throwable failure, boolean error2) {
        if (RubyInstanceConfig.REIFY_LOG_ERRORS) {
            if (error2) {
                LOG.error("failed to reify class " + this.getName() + " due to: ", failure);
            } else {
                LOG.info("failed to reify class " + this.getName() + " due to: ", failure);
            }
        }
    }

    public void setReifiedClass(Class<? extends IRubyObject> reifiedClass) {
        this.reifiedClass = reifiedClass;
    }

    public Class<? extends IRubyObject> getReifiedClass() {
        return this.reifiedClass;
    }

    public static Class<? extends IRubyObject> nearestReifiedClass(RubyClass klass) {
        RubyClass current2 = klass;
        do {
            Class<? extends IRubyObject> reified;
            if ((reified = current2.getReifiedClass()) == null) continue;
            return reified;
        } while ((current2 = current2.getSuperClass()) != null);
        return null;
    }

    public Map<String, List<Map<Class, Map<String, Object>>>> getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.parameterAnnotations;
    }

    public synchronized void addParameterAnnotation(String method2, int i2, Class annoClass, Map<String, Object> value2) {
        List<Map<Class, Map<String, Object>>> paramList;
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = new HashMap<String, List<Map<Class, Map<String, Object>>>>(8);
        }
        if ((paramList = this.parameterAnnotations.get(method2)) == null) {
            paramList = new ArrayList<Map<Class, Map<String, Object>>>(i2 + 1);
            this.parameterAnnotations.put(method2, paramList);
        }
        if (paramList.size() < i2 + 1) {
            for (int j = paramList.size(); j < i2 + 1; ++j) {
                paramList.add(null);
            }
        }
        if (annoClass != null && value2 != null) {
            Map<Class, Map<String, Object>> annos = paramList.get(i2);
            if (annos == null) {
                annos = new LinkedHashMap<Class, Map<String, Object>>(4);
                paramList.set(i2, annos);
            }
            annos.put(annoClass, value2);
        } else {
            paramList.set(i2, null);
        }
    }

    public Map<String, Map<Class, Map<String, Object>>> getMethodAnnotations() {
        if (this.methodAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.methodAnnotations;
    }

    public Map<String, Map<Class, Map<String, Object>>> getFieldAnnotations() {
        if (this.fieldAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.fieldAnnotations;
    }

    public synchronized void addMethodAnnotation(String methodName, Class annotation2, Map fields2) {
        Map<Class, Map<String, Object>> annos;
        if (this.methodAnnotations == null) {
            this.methodAnnotations = new HashMap<String, Map<Class, Map<String, Object>>>(8);
        }
        if ((annos = this.methodAnnotations.get(methodName)) == null) {
            annos = new LinkedHashMap<Class, Map<String, Object>>(4);
            this.methodAnnotations.put(methodName, annos);
        }
        annos.put(annotation2, fields2);
    }

    public synchronized void addFieldAnnotation(String fieldName, Class annotation2, Map fields2) {
        Map<Class, Map<String, Object>> annos;
        if (this.fieldAnnotations == null) {
            this.fieldAnnotations = new HashMap<String, Map<Class, Map<String, Object>>>(8);
        }
        if ((annos = this.fieldAnnotations.get(fieldName)) == null) {
            annos = new LinkedHashMap<Class, Map<String, Object>>(4);
            this.fieldAnnotations.put(fieldName, annos);
        }
        annos.put(annotation2, fields2);
    }

    public Map<String, Class[]> getMethodSignatures() {
        if (this.methodSignatures == null) {
            return Collections.EMPTY_MAP;
        }
        return this.methodSignatures;
    }

    public Map<String, Class> getFieldSignatures() {
        if (this.fieldSignatures == null) {
            return Collections.EMPTY_MAP;
        }
        return this.fieldSignatures;
    }

    public synchronized void addMethodSignature(String methodName, Class[] types) {
        if (this.methodSignatures == null) {
            this.methodSignatures = new HashMap<String, Class[]>(16);
        }
        this.methodSignatures.put(methodName, types);
    }

    public synchronized void addFieldSignature(String fieldName, Class type2) {
        if (this.fieldSignatures == null) {
            this.fieldSignatures = new LinkedHashMap<String, Class>(8);
        }
        this.fieldSignatures.put(fieldName, type2);
    }

    public Map<Class, Map<String, Object>> getClassAnnotations() {
        if (this.classAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.classAnnotations;
    }

    public synchronized void addClassAnnotation(Class annotation2, Map fields2) {
        if (this.classAnnotations == null) {
            this.classAnnotations = new LinkedHashMap<Class, Map<String, Object>>(4);
        }
        this.classAnnotations.put(annotation2, fields2);
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target == Class.class) {
            ThreadContext context;
            IRubyObject javaClass;
            if (this.reifiedClass == null) {
                this.reifyWithAncestors();
            }
            if (!(javaClass = JavaClass.java_class(context = this.getRuntime().getCurrentContext(), this)).isNil()) {
                return javaClass.toJava(target);
            }
            Class<? extends IRubyObject> reifiedClass = RubyClass.nearestReifiedClass(this);
            if (reifiedClass != null) {
                return target.cast(reifiedClass);
            }
        }
        if (target.isAssignableFrom(RubyClass.class)) {
            return target.cast(this);
        }
        return this.defaultToJava(target);
    }

    public void smartDump(MarshalStream stream, IRubyObject target) throws IOException {
        MarshalTuple tuple = this.cachedDumpMarshal;
        if (tuple.generation != this.generation) {
            CacheEntry entry = this.searchWithCache("respond_to?");
            DynamicMethod method2 = entry.method;
            if (!method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined()) {
                tuple = this.cachedDumpMarshal = new MarshalTuple(null, MarshalType.DEFAULT_SLOW, this.generation);
            } else {
                entry = this.searchWithCache("marshal_dump");
                if (!entry.method.isUndefined()) {
                    tuple = this.cachedDumpMarshal = new MarshalTuple(entry, MarshalType.NEW_USER, this.generation);
                } else {
                    entry = this.searchWithCache("_dump");
                    tuple = !entry.method.isUndefined() ? (this.cachedDumpMarshal = new MarshalTuple(entry, MarshalType.OLD_USER, this.generation)) : (this.cachedDumpMarshal = new MarshalTuple(null, MarshalType.DEFAULT, this.generation));
                }
            }
        }
        tuple.dump(stream, target);
    }

    public IRubyObject smartLoadNewUser(IRubyObject target, IRubyObject data2) {
        ThreadContext context = this.runtime.getCurrentContext();
        CacheEntry cache = this.cachedLoad;
        if (cache.token == this.generation) {
            cache.method.call(context, target, cache.sourceModule, "marshal_load", data2);
            return target;
        }
        cache = this.searchWithCache("respond_to?");
        DynamicMethod method2 = cache.method;
        if (!method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined()) {
            if (method2.call(context, target, cache.sourceModule, "respond_to?", this.runtime.newSymbol("marshal_load")).isTrue()) {
                target.callMethod(context, "marshal_load", data2);
                return target;
            }
            throw this.runtime.newTypeError(RubyStringBuilder.str(this.runtime, "class ", RubyStringBuilder.types(this.runtime, this), " needs to have method `marshal_load'"));
        }
        cache = this.searchWithCache("marshal_load");
        if (!cache.method.isUndefined()) {
            this.cachedLoad = cache;
            cache.method.call(context, target, cache.sourceModule, "marshal_load", data2);
            return target;
        }
        target.callMethod(context, "marshal_load", data2);
        return target;
    }

    public IRubyObject smartLoadOldUser(IRubyObject data2) {
        ThreadContext context = this.runtime.getCurrentContext();
        CacheEntry cache = this.getSingletonClass().cachedLoad;
        if (cache.token == this.getSingletonClass().generation) {
            return cache.method.call(context, (IRubyObject)this, cache.sourceModule, "_load", data2);
        }
        cache = this.getSingletonClass().searchWithCache("respond_to?");
        DynamicMethod method2 = cache.method;
        if (!method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined()) {
            if (method2.call(context, (IRubyObject)this, cache.sourceModule, "respond_to?", this.runtime.newSymbol("_load")).isTrue()) {
                return this.callMethod(context, "_load", data2);
            }
            throw this.runtime.newTypeError(RubyStringBuilder.str(this.runtime, "class ", RubyStringBuilder.types(this.runtime, this), " needs to have method `_load'"));
        }
        cache = this.getSingletonClass().searchWithCache("_load");
        if (!cache.method.isUndefined()) {
            this.getSingletonClass().cachedLoad = cache;
            return cache.method.call(context, (IRubyObject)this, cache.sourceModule, "_load", data2);
        }
        throw this.runtime.newTypeError(RubyStringBuilder.str(this.runtime, "class ", RubyStringBuilder.types(this.runtime, this), " needs to have method `_load'"));
    }

    @Deprecated
    public IRubyObject invoke(ThreadContext context, IRubyObject self2, int methodIndex, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return this.invoke(context, self2, name2, args2, callType, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType, Block block) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        IRubyObject caller2 = context.getFrameSelf();
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2);
    }

    @Deprecated
    public VariableAccessorField getObjectIdAccessorField() {
        return this.variableTableManager.getObjectIdAccessorField();
    }

    @Deprecated
    public VariableAccessorField getFFIHandleAccessorField() {
        return this.variableTableManager.getFFIHandleAccessorField();
    }

    @Deprecated
    public VariableAccessorField getObjectGroupAccessorField() {
        return this.variableTableManager.getObjectGroupAccessorField();
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject[] args2) {
        assert (args2 != null);
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg2);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1);
    }

    @Deprecated
    public IRubyObject invokeFrom(ThreadContext context, CallType callType, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = this.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (this.shouldCallMethodMissing(method2, name2, caller2, callType)) {
            return Helpers.callMethodMissing(context, self2, this, method2.getVisibility(), name2, callType, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2);
    }

    public static enum CS_NAMES {
        INITIALIZE("initialize");

        private static final CS_NAMES[] VALUES;
        public static final int length;
        public final String id;

        private CS_NAMES(String id2) {
            this.id = id2;
        }

        public static CS_NAMES fromOrdinal(int ordinal2) {
            if (ordinal2 < 0 || ordinal2 >= VALUES.length) {
                throw new RuntimeException("invalid rest: " + ordinal2);
            }
            return VALUES[ordinal2];
        }

        static {
            VALUES = CS_NAMES.values();
            length = VALUES.length;
        }
    }

    private static class MarshalTuple {
        public static final MarshalTuple NULL_TUPLE = new MarshalTuple(null, null, 0);
        public final CacheEntry entry;
        public final MarshalType type;
        public final int generation;

        public MarshalTuple(CacheEntry entry, MarshalType type2, int generation) {
            this.entry = entry;
            this.type = type2;
            this.generation = generation;
        }

        public void dump(MarshalStream stream, IRubyObject object) throws IOException {
            switch (this.type) {
                case DEFAULT: {
                    stream.writeDirectly(object);
                    return;
                }
                case NEW_USER: {
                    stream.userNewMarshal(object, this.entry);
                    return;
                }
                case OLD_USER: {
                    stream.userMarshal(object, this.entry);
                    return;
                }
                case DEFAULT_SLOW: {
                    if (object.respondsTo("marshal_dump")) {
                        stream.userNewMarshal(object);
                    } else if (object.respondsTo("_dump")) {
                        stream.userMarshal(object);
                    } else {
                        stream.writeDirectly(object);
                    }
                    return;
                }
            }
        }
    }

    private static enum MarshalType {
        DEFAULT,
        NEW_USER,
        OLD_USER,
        DEFAULT_SLOW,
        NEW_USER_SLOW,
        USER_SLOW;

    }

    private class MethodReificator
    extends BaseReificator {
        MethodReificator(Class<?> reifiedParent, String javaName, String javaPath) {
            super(reifiedParent, javaName, javaPath);
        }

        @Override
        public void customReify() {
            this.addClassAnnotations();
            this.defineFields();
            HashSet<String> instanceMethods = new HashSet<String>(RubyClass.this.getMethods().size());
            this.defineInstanceMethods(instanceMethods);
            this.defineClassMethods(instanceMethods);
        }

        private void addClassAnnotations() {
            if (RubyClass.this.classAnnotations != null && !RubyClass.this.classAnnotations.isEmpty()) {
                for (Map.Entry entry : RubyClass.this.classAnnotations.entrySet()) {
                    Class annoType = (Class)entry.getKey();
                    Map fields2 = (Map)entry.getValue();
                    AnnotationVisitor av = this.cw.visitAnnotation(CodegenUtils.ci(annoType), true);
                    CodegenUtils.visitAnnotationFields(av, fields2);
                    av.visitEnd();
                }
            }
        }

        private void defineFields() {
            for (Map.Entry<String, Class> fieldSignature : RubyClass.this.getFieldSignatures().entrySet()) {
                String fieldName = fieldSignature.getKey();
                Class type2 = fieldSignature.getValue();
                Map<Class, Map<String, Object>> fieldAnnos = RubyClass.this.getFieldAnnotations().get(fieldName);
                FieldVisitor fieldVisitor = this.cw.visitField(1, fieldName, CodegenUtils.ci(type2), null, null);
                if (fieldAnnos == null) continue;
                for (Map.Entry<Class, Map<String, Object>> fieldAnno : fieldAnnos.entrySet()) {
                    Class annoType = fieldAnno.getKey();
                    AnnotationVisitor av = fieldVisitor.visitAnnotation(CodegenUtils.ci(annoType), true);
                    CodegenUtils.visitAnnotationFields(av, fieldAnno.getValue());
                }
                fieldVisitor.visitEnd();
            }
        }

        private void defineClassMethods(Set<String> instanceMethods) {
            block3: for (Map.Entry<String, DynamicMethod> methodEntry : RubyClass.this.getMetaClass().getMethods().entrySet()) {
                SkinnyMethodAdapter m;
                String signature;
                String id2 = methodEntry.getKey();
                String javaMethodName = JavaNameMangler.mangleMethodName(id2);
                Map<Class, Map<String, Object>> methodAnnos = RubyClass.this.getMetaClass().getMethodAnnotations().get(id2);
                List<Map<Class, Map<String, Object>>> parameterAnnos = RubyClass.this.getMetaClass().getParameterAnnotations().get(id2);
                Class[] methodSignature = RubyClass.this.getMetaClass().getMethodSignatures().get(id2);
                if (methodSignature == null) {
                    Arity arity2 = methodEntry.getValue().getArity();
                    switch (arity2.getValue()) {
                        case 0: {
                            signature = CodegenUtils.sig(IRubyObject.class, new Class[0]);
                            if (instanceMethods.contains(javaMethodName + signature)) continue block3;
                            m = new SkinnyMethodAdapter(this.cw, 9, javaMethodName, signature, null, null);
                            RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                            m.getstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                            m.ldc(id2);
                            m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class));
                            break;
                        }
                        default: {
                            signature = CodegenUtils.sig(IRubyObject.class, IRubyObject[].class);
                            if (instanceMethods.contains(javaMethodName + signature)) continue block3;
                            m = new SkinnyMethodAdapter(this.cw, 137, javaMethodName, signature, null, null);
                            RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                            m.getstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                            m.ldc(id2);
                            m.aload(0);
                            m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                        }
                    }
                    m.areturn();
                } else {
                    int baseIndex;
                    Class[] params2 = new Class[methodSignature.length - 1];
                    System.arraycopy(methodSignature, 1, params2, 0, params2.length);
                    int rubyIndex = baseIndex = RealClassGenerator.calcBaseIndex(params2, 0);
                    signature = CodegenUtils.sig(methodSignature[0], params2);
                    if (instanceMethods.contains(javaMethodName + signature)) continue;
                    m = new SkinnyMethodAdapter(this.cw, 137, javaMethodName, signature, null, null);
                    RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                    m.getstatic(this.javaPath, "ruby", CodegenUtils.ci(Ruby.class));
                    m.astore(rubyIndex);
                    m.getstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                    m.ldc(id2);
                    RealClassGenerator.coerceArgumentsToRuby(m, params2, rubyIndex);
                    m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                    RealClassGenerator.coerceResultAndReturn(m, methodSignature[0]);
                }
                m.end();
            }
        }

        private void defineInstanceMethods(Set<String> instanceMethods) {
            for (Map.Entry<String, DynamicMethod> methodEntry : RubyClass.this.getMethods().entrySet()) {
                SkinnyMethodAdapter m;
                String signature;
                String id2 = methodEntry.getKey();
                String javaMethodName = JavaNameMangler.mangleMethodName(id2);
                Map<Class, Map<String, Object>> methodAnnos = RubyClass.this.getMethodAnnotations().get(id2);
                List<Map<Class, Map<String, Object>>> parameterAnnos = RubyClass.this.getParameterAnnotations().get(id2);
                Object[] methodSignature = RubyClass.this.getMethodSignatures().get(id2);
                if (methodSignature == null) {
                    Arity arity2 = methodEntry.getValue().getArity();
                    switch (arity2.getValue()) {
                        case 0: {
                            signature = CodegenUtils.sig(IRubyObject.class, new Class[0]);
                            m = new SkinnyMethodAdapter(this.cw, 1, javaMethodName, signature, null, null);
                            RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                            m.aload(0);
                            m.ldc(id2);
                            m.invokevirtual(this.javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class));
                            break;
                        }
                        case 1: {
                            signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class);
                            m = new SkinnyMethodAdapter(this.cw, 1, javaMethodName, signature, null, null);
                            RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                            m.aload(0);
                            m.ldc(id2);
                            m.aload(1);
                            m.invokevirtual(this.javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class));
                            break;
                        }
                        default: {
                            if (arity2.isFixed()) {
                                int paramCount = arity2.getValue();
                                Object[] params2 = new Class[paramCount];
                                Arrays.fill(params2, IRubyObject.class);
                                signature = CodegenUtils.sig(IRubyObject.class, (Class[])params2);
                                m = new SkinnyMethodAdapter(this.cw, 1, javaMethodName, signature, null, null);
                                RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                                m.aload(0);
                                m.ldc(id2);
                                m.pushInt(paramCount);
                                m.anewarray(CodegenUtils.p(IRubyObject.class));
                                for (int i2 = 1; i2 <= paramCount; ++i2) {
                                    m.dup();
                                    m.pushInt(i2 - 1);
                                    m.aload(i2);
                                    m.aastore();
                                }
                            } else {
                                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject[].class);
                                m = new SkinnyMethodAdapter(this.cw, 129, javaMethodName, signature, null, null);
                                RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                                m.aload(0);
                                m.ldc(id2);
                                m.aload(1);
                            }
                            m.invokevirtual(this.javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                        }
                    }
                    m.areturn();
                } else {
                    int baseIndex;
                    Object[] params3 = new Class[methodSignature.length - 1];
                    ArraySupport.copy(methodSignature, 1, params3, 0, params3.length);
                    int rubyIndex = baseIndex = RealClassGenerator.calcBaseIndex((Class[])params3, 1);
                    signature = CodegenUtils.sig((Class)methodSignature[0], (Class[])params3);
                    int mod = 1;
                    if (RubyClass.this.isVarArgsSignature(id2, (Class[])methodSignature)) {
                        mod |= 0x80;
                    }
                    m = new SkinnyMethodAdapter(this.cw, mod, javaMethodName, signature, null, null);
                    RubyClass.this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                    m.getstatic(this.javaPath, "ruby", CodegenUtils.ci(Ruby.class));
                    m.astore(rubyIndex);
                    m.aload(0);
                    m.ldc(id2);
                    RealClassGenerator.coerceArgumentsToRuby(m, (Class[])params3, rubyIndex);
                    m.invokevirtual(this.javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                    RealClassGenerator.coerceResultAndReturn(m, (Class)methodSignature[0]);
                }
                instanceMethods.add(javaMethodName + signature);
                m.end();
            }
        }
    }

    private abstract class BaseReificator
    implements Reificator {
        protected final Class reifiedParent;
        protected final String javaName;
        protected final String javaPath;
        protected final ClassWriter cw;

        BaseReificator(Class<?> reifiedParent, String javaName, String javaPath) {
            this.reifiedParent = reifiedParent;
            this.javaName = javaName;
            this.javaPath = javaPath;
            this.cw = new ClassWriter(3);
            this.cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, javaPath, null, CodegenUtils.p(reifiedParent), this.interfaces());
        }

        @Override
        public byte[] reify() {
            this.cw.visitField(10, "ruby", CodegenUtils.ci(Ruby.class), null, null);
            this.cw.visitField(10, "rubyClass", CodegenUtils.ci(RubyClass.class), null, null);
            SkinnyMethodAdapter m = new SkinnyMethodAdapter(this.cw, 9, "clinit", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), null, null);
            m.start();
            m.aload(0);
            m.putstatic(this.javaPath, "ruby", CodegenUtils.ci(Ruby.class));
            m.aload(1);
            m.putstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
            m.voidreturn();
            m.end();
            m = new SkinnyMethodAdapter(this.cw, 1, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), null, null);
            m.aload(0);
            m.aload(1);
            m.aload(2);
            m.invokespecial(CodegenUtils.p(this.reifiedParent), "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
            m.voidreturn();
            m.end();
            m = new SkinnyMethodAdapter(this.cw, 1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
            m.aload(0);
            m.getstatic(this.javaPath, "ruby", CodegenUtils.ci(Ruby.class));
            m.getstatic(this.javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
            m.invokespecial(CodegenUtils.p(this.reifiedParent), "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
            m.voidreturn();
            m.end();
            this.customReify();
            this.cw.visitEnd();
            return this.cw.toByteArray();
        }

        public abstract void customReify();

        private String[] interfaces() {
            Class[] interfaces2 = Java.getInterfacesFromRubyClass(RubyClass.this);
            String[] interfaceNames = new String[interfaces2.length + 1];
            interfaceNames[0] = CodegenUtils.p(Reified.class);
            for (int i2 = 0; i2 < interfaces2.length; ++i2) {
                interfaceNames[i2 + 1] = CodegenUtils.p(interfaces2[i2]);
            }
            return interfaceNames;
        }
    }

    static interface Reificator {
        public byte[] reify();
    }
}

