/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.OpenTHashSet;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class HashSetQueue<T>
extends AbstractCollection<T>
implements Queue<T> {
    private final OpenTHashSet<QueueEntry<T>> set;
    private final QueueEntry<T> TOMB;

    @Override
    public boolean offer(@NotNull T t) {
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(0);
        }
        return this.add(t);
    }

    @Override
    public boolean add(@NotNull T t) {
        QueueEntry<T> newLast;
        boolean added;
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(1);
        }
        if (!(added = this.set.add(newLast = new QueueEntry<T>(t)))) {
            return false;
        }
        QueueEntry oldLast = ((QueueEntry)this.TOMB).prev;
        oldLast.next = (QueueEntry)newLast;
        ((QueueEntry)newLast).prev = oldLast;
        ((QueueEntry)newLast).next = (QueueEntry)this.TOMB;
        ((QueueEntry)this.TOMB).prev = (QueueEntry)newLast;
        return true;
    }

    @Override
    @NotNull
    public T remove() {
        T poll = this.poll();
        if (poll == null) {
            throw new NoSuchElementException();
        }
        T t = poll;
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(2);
        }
        return t;
    }

    @Override
    public T poll() {
        T peek = this.peek();
        if (peek != null) {
            this.remove(peek);
        }
        return peek;
    }

    @Override
    @NotNull
    public T element() {
        T peek = this.peek();
        if (peek == null) {
            throw new NoSuchElementException();
        }
        T t = peek;
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(3);
        }
        return t;
    }

    @Override
    public T peek() {
        return (T)(((QueueEntry)this.TOMB).next == this.TOMB ? null : ((QueueEntry)this.TOMB).next.t);
    }

    public T find(@NotNull T t) {
        QueueEntry<T> existing;
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(4);
        }
        return (T)((existing = this.findEntry(t)) == null ? null : ((QueueEntry)existing).t);
    }

    private QueueEntry<T> findEntry(@NotNull T t) {
        if (t == null) {
            HashSetQueue.$$$reportNull$$$0(5);
        }
        return this.set.get(new QueueEntry<T>(t));
    }

    @Override
    public boolean remove(Object o) {
        T t = this.cast(o);
        QueueEntry<T> entry = this.findEntry(t);
        if (entry == null) {
            return false;
        }
        QueueEntry prev = ((QueueEntry)entry).prev;
        QueueEntry next = ((QueueEntry)entry).next;
        prev.next = next;
        next.prev = prev;
        this.set.remove(entry);
        return true;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.find(this.cast(o)) != null;
    }

    private T cast(Object o) {
        return (T)o;
    }

    @Override
    @NotNull
    public PositionalIterator<T> iterator() {
        PositionalIterator positionalIterator = new PositionalIterator<T>(){
            private QueueEntry<T> cursor;
            private long count;
            {
                this.cursor = HashSetQueue.this.TOMB;
            }

            @Override
            public boolean hasNext() {
                return this.cursor.next != HashSetQueue.this.TOMB;
            }

            @Override
            public T next() {
                this.cursor = this.cursor.next;
                ++this.count;
                return this.cursor.t;
            }

            @Override
            public void remove() {
                if (this.cursor == HashSetQueue.this.TOMB) {
                    throw new NoSuchElementException();
                }
                HashSetQueue.this.remove(this.cursor.t);
            }
        };
        if (positionalIterator == null) {
            HashSetQueue.$$$reportNull$$$0(6);
        }
        return positionalIterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/HashSetQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/HashSetQueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "element";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "offer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PositionalIterator<T>
    extends Iterator<T> {
    }

    private static class QueueEntry<T> {
        @NotNull
        private final T t;
        private QueueEntry<T> next;
        private QueueEntry<T> prev;

        QueueEntry(@NotNull T t) {
            if (t == null) {
                QueueEntry.$$$reportNull$$$0(0);
            }
            this.t = t;
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof QueueEntry && this.t.equals(((QueueEntry)obj).t);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/HashSetQueue$QueueEntry", "<init>"));
        }
    }
}

