/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.IceBoxDescriptor;
import com.zeroc.IceGrid.NodeDescriptor;
import com.zeroc.IceGrid.NodeUpdateDescriptor;
import com.zeroc.IceGrid.ServerInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.ListTreeNode;
import com.zeroc.IceGridGUI.Application.Node;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.ServerInstance;
import com.zeroc.IceGridGUI.Application.ServiceInstance;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.TreeNodeBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

class Nodes
extends ListTreeNode {
    private Map<String, NodeDescriptor> _descriptors;
    private static JPopupMenu _popup;

    public static Map<String, NodeDescriptor> copyDescriptors(Map<String, NodeDescriptor> descriptors) {
        HashMap<String, NodeDescriptor> copy = new HashMap<String, NodeDescriptor>();
        for (Map.Entry<String, NodeDescriptor> p : descriptors.entrySet()) {
            copy.put(p.getKey(), Node.copyDescriptor(p.getValue()));
        }
        return copy;
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor != null) {
            actions[14] = descriptor instanceof NodeDescriptor;
        }
        actions[2] = true;
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(2));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        NodeDescriptor nd = Node.copyDescriptor((NodeDescriptor)descriptor);
        for (ServerInstanceDescriptor p : nd.serverInstances) {
            TemplateDescriptor td = this.getRoot().findServerTemplateDescriptor(p.template);
            if (td == null) {
                JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "Descriptor refers to undefined server template '" + p.template + "'", "Cannot paste", 0);
                return;
            }
            p.parameterValues.keySet().retainAll(td.parameters);
        }
        for (ServerInstanceDescriptor p : nd.servers) {
            if (!(p instanceof IceBoxDescriptor) || this.getRoot().pasteIceBox((IceBoxDescriptor)p)) continue;
            return;
        }
        this.newNode(nd);
    }

    @Override
    public void newNode() {
        this.newNode(new NodeDescriptor(new TreeMap(), new LinkedList(), new LinkedList(), "", "", new HashMap()));
    }

    Nodes(TreeNode parent, Map<String, NodeDescriptor> descriptors) throws UpdateFailedException {
        super(false, parent, "Nodes");
        this._descriptors = descriptors;
        for (Map.Entry<String, NodeDescriptor> p : this._descriptors.entrySet()) {
            String nodeName = p.getKey();
            NodeDescriptor nodeDescriptor = p.getValue();
            this.insertChild(new Node(false, this, nodeName, nodeDescriptor), false);
        }
    }

    void rebuild() throws UpdateFailedException {
        ArrayList<Node.Backup> backupList = new ArrayList<Node.Backup>();
        LinkedList<Editable> editables = new LinkedList<Editable>();
        for (TreeNodeBase treeNodeBase : this._children) {
            Node node = (Node)treeNodeBase;
            try {
                backupList.add(node.rebuild(editables));
            }
            catch (UpdateFailedException e) {
                for (int i = backupList.size() - 1; i >= 0; --i) {
                    ((Node)this._children.get(i)).restore((Node.Backup)backupList.get(i));
                }
                throw e;
            }
        }
        for (Editable editable : editables) {
            editable.markModified();
        }
    }

    void commit() {
        this._editable.commit();
        for (TreeNodeBase p : this._children) {
            Node node = (Node)p;
            node.commit();
        }
    }

    LinkedList<NodeUpdateDescriptor> getUpdates() {
        LinkedList<NodeUpdateDescriptor> updates = new LinkedList<NodeUpdateDescriptor>();
        for (TreeNodeBase p : this._children) {
            Node node = (Node)p;
            NodeUpdateDescriptor d = node.getUpdate();
            if (d == null) continue;
            updates.add(d);
        }
        return updates;
    }

    void removeServerInstances(String templateId) {
        for (TreeNodeBase p : this._children) {
            Node node = (Node)p;
            node.removeServerInstances(templateId);
        }
    }

    List<ServiceInstance> findServiceInstances(String template) {
        LinkedList<ServiceInstance> result = new LinkedList<ServiceInstance>();
        for (TreeNodeBase p : this._children) {
            Node node = (Node)p;
            result.addAll(node.findServiceInstances(template));
        }
        return result;
    }

    void removeServiceInstances(String templateId) {
        for (TreeNodeBase p : this._children) {
            Node node = (Node)p;
            node.removeServiceInstances(templateId);
        }
    }

    void update(List<NodeUpdateDescriptor> updates, String[] removeNodes, Set<String> serverTemplates, Set<String> serviceTemplates) throws UpdateFailedException {
        Node node;
        Root root = this.getRoot();
        this.removeChildren(removeNodes);
        ArrayList<Node> newChildren = new ArrayList<Node>();
        HashSet<Node> updatedNodes = new HashSet<Node>();
        for (NodeUpdateDescriptor update : updates) {
            node = this.findNode(update.name);
            if (node == null) {
                NodeDescriptor nodeDescriptor = new NodeDescriptor(update.variables, update.serverInstances, update.servers, update.loadFactor == null ? "" : update.loadFactor.value, update.description == null ? "" : update.description.value, new HashMap());
                this._descriptors.put(update.name, nodeDescriptor);
                node = new Node(false, this, update.name, nodeDescriptor);
                newChildren.add(node);
                continue;
            }
            node.update(update, serverTemplates, serviceTemplates);
            updatedNodes.add(node);
        }
        for (TreeNodeBase p : this._children) {
            node = (Node)p;
            if (updatedNodes.contains(node)) continue;
            node.update(null, serverTemplates, serviceTemplates);
        }
        this.insertChildren(newChildren, true);
    }

    Node findNode(String nodeName) {
        return (Node)this.findChild(nodeName);
    }

    List<ServerInstance> findServerInstances(String template) {
        LinkedList<ServerInstance> result = new LinkedList<ServerInstance>();
        for (TreeNodeBase p : this._children) {
            Node node = (Node)p;
            result.addAll(node.findServerInstances(template));
        }
        return result;
    }

    void addDescriptor(String nodeName, NodeDescriptor descriptor) {
        this._descriptors.put(nodeName, descriptor);
    }

    void removeDescriptor(String nodeName) {
        this._descriptors.remove(nodeName);
    }

    @Override
    Object getDescriptor() {
        return this._descriptors;
    }

    void tryAdd(String nodeName, NodeDescriptor descriptor) throws UpdateFailedException {
        Node node = new Node(true, this, nodeName, descriptor);
        this.insertChild(node, true);
        this._descriptors.put(nodeName, descriptor);
    }

    private void newNode(NodeDescriptor descriptor) {
        Node node;
        block2: {
            String name = this.makeNewChildId("NewNode");
            node = new Node(this, name, descriptor);
            try {
                this.insertChild(node, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(node);
    }
}

