/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.Validate;
import org.apache.maven.toolchain.io.ToolchainsParseException;
import org.apache.maven.toolchain.io.ToolchainsReader;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultToolchainsReader
implements ToolchainsReader {
    @Override
    public PersistedToolchains read(File input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        return this.read(ReaderFactory.newXmlReader(input), options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PersistedToolchains read(Reader input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try (Reader in = input;){
            PersistedToolchains persistedToolchains = new MavenToolchainsXpp3Reader().read(in, this.isStrict(options));
            return persistedToolchains;
        }
        catch (XmlPullParserException e2) {
            throw new ToolchainsParseException(e2.getMessage(), e2.getLineNumber(), e2.getColumnNumber(), e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PersistedToolchains read(InputStream input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try (InputStream in = input;){
            PersistedToolchains persistedToolchains = new MavenToolchainsXpp3Reader().read(in, this.isStrict(options));
            return persistedToolchains;
        }
        catch (XmlPullParserException e2) {
            throw new ToolchainsParseException(e2.getMessage(), e2.getLineNumber(), e2.getColumnNumber(), e2);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.apache.maven.toolchains.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

