/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.FilterWorker;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.OSDLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class FilterModel {
    private int disabledCount;
    private int disabledAndHiddenCount;
    private boolean changed;
    private final List<Filter> filters = new LinkedList<Filter>();
    private final FilterMatcher filterMatcher = new FilterMatcher();

    private void updateFilterMatcher() {
        this.filterMatcher.reset();
        for (Filter filter : this.filters) {
            try {
                this.filterMatcher.add(filter);
            }
            catch (SearchParseError e) {
                Logging.error(e);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Error in filter <code>{0}</code>:<br>{1}", Utils.escapeReservedCharactersHTML(Utils.shortenString(filter.text, 80)), Utils.escapeReservedCharactersHTML(e.getMessage())), I18n.tr("Error in filter", new Object[0]), 0);
                filter.enable = false;
            }
        }
    }

    public void loadPrefs(String prefEntry) {
        List<Filter.FilterPreferenceEntry> entries = StructUtils.getListOfStructs(Config.getPref(), prefEntry, null, Filter.FilterPreferenceEntry.class);
        if (entries != null) {
            for (Filter.FilterPreferenceEntry e : entries) {
                this.filters.add(new Filter(e));
            }
            this.updateFilterMatcher();
        }
    }

    public void savePrefs(String prefEntry) {
        ArrayList<Filter.FilterPreferenceEntry> entries = new ArrayList<Filter.FilterPreferenceEntry>();
        for (Filter flt : this.filters) {
            entries.add(flt.getPreferenceEntry());
        }
        StructUtils.putListOfStructs(Config.getPref(), prefEntry, entries, Filter.FilterPreferenceEntry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters() {
        DataSet ds = OsmDataManager.getInstance().getActiveDataSet();
        this.changed = false;
        if (ds == null) {
            this.disabledAndHiddenCount = 0;
            this.disabledCount = 0;
            this.changed = true;
        } else {
            HashSet<OsmPrimitive> deselect = new HashSet<OsmPrimitive>();
            ds.beginUpdate();
            try {
                Collection<OsmPrimitive> all = ds.allNonDeletedCompletePrimitives();
                this.changed = FilterWorker.executeFilters(all, this.filterMatcher);
                this.disabledCount = 0;
                this.disabledAndHiddenCount = 0;
                for (OsmPrimitive osm : all) {
                    if (!osm.isDisabled()) continue;
                    ++this.disabledCount;
                    if (osm.isSelected()) {
                        deselect.add(osm);
                    }
                    if (!osm.isDisabledAndHidden()) continue;
                    ++this.disabledAndHiddenCount;
                }
                this.disabledCount -= this.disabledAndHiddenCount;
            }
            finally {
                if (this.changed) {
                    ds.fireFilterChanged();
                }
                ds.endUpdate();
            }
            if (!deselect.isEmpty()) {
                ds.clearSelection(deselect);
            }
        }
        if (this.changed) {
            FilterModel.updateMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters(Collection<? extends OsmPrimitive> primitives) {
        DataSet ds = OsmDataManager.getInstance().getActiveDataSet();
        if (ds == null) {
            return;
        }
        this.changed = false;
        ArrayList<OsmPrimitive> deselect = new ArrayList<OsmPrimitive>();
        ds.beginUpdate();
        try {
            for (int i = 0; i < 2; ++i) {
                for (OsmPrimitive osmPrimitive : primitives) {
                    if (i == 0 && osmPrimitive instanceof Node || i == 1 && !(osmPrimitive instanceof Node)) continue;
                    if (osmPrimitive.isDisabled()) {
                        --this.disabledCount;
                    }
                    if (osmPrimitive.isDisabledAndHidden()) {
                        --this.disabledAndHiddenCount;
                    }
                    this.changed |= FilterWorker.executeFilters(osmPrimitive, this.filterMatcher);
                    if (osmPrimitive.isDisabled()) {
                        ++this.disabledCount;
                    }
                    if (osmPrimitive.isDisabledAndHidden()) {
                        ++this.disabledAndHiddenCount;
                    }
                    if (!osmPrimitive.isSelected() || !osmPrimitive.isDisabled()) continue;
                    deselect.add(osmPrimitive);
                }
            }
        }
        finally {
            ds.endUpdate();
        }
        if (!deselect.isEmpty()) {
            ds.clearSelection(deselect);
        }
        if (this.changed) {
            FilterModel.updateMap();
        }
    }

    private static void updateMap() {
        MainApplication.getLayerManager().invalidateEditLayer();
    }

    public void clearFilterFlags() {
        DataSet ds = OsmDataManager.getInstance().getActiveDataSet();
        if (ds != null) {
            FilterWorker.clearFilterFlags(ds.allPrimitives());
        }
        this.disabledCount = 0;
        this.disabledAndHiddenCount = 0;
    }

    public void clearFilters() {
        this.filters.clear();
        this.updateFilterMatcher();
    }

    public boolean addFilter(Filter filter) {
        this.filters.add(filter);
        this.updateFilterMatcher();
        return true;
    }

    public boolean moveDownFilter(int rowIndex) {
        if (rowIndex >= this.filters.size() - 1) {
            return false;
        }
        this.filters.add(rowIndex + 1, this.filters.remove(rowIndex));
        this.updateFilterMatcher();
        return true;
    }

    public boolean moveUpFilter(int rowIndex) {
        if (rowIndex <= 0 || rowIndex >= this.filters.size()) {
            return false;
        }
        this.filters.add(rowIndex - 1, this.filters.remove(rowIndex));
        this.updateFilterMatcher();
        return true;
    }

    public Filter removeFilter(int rowIndex) {
        Filter result = this.filters.remove(rowIndex);
        this.updateFilterMatcher();
        return result;
    }

    public Filter setFilter(int rowIndex, Filter filter) {
        Filter result = this.filters.set(rowIndex, filter);
        this.updateFilterMatcher();
        return result;
    }

    public Filter getFilter(int rowIndex) {
        return this.filters.get(rowIndex);
    }

    public void drawOSDText(Graphics2D g, OSDLabel lblOSD, String header, String footer) {
        if (this.disabledCount == 0 && this.disabledAndHiddenCount == 0) {
            return;
        }
        String message = "<html>" + header;
        if (this.disabledAndHiddenCount != 0) {
            message = message + I18n.trn("<p><b>{0}</b> object hidden", "<p><b>{0}</b> objects hidden", this.disabledAndHiddenCount, this.disabledAndHiddenCount);
        }
        if (this.disabledAndHiddenCount != 0 && this.disabledCount != 0) {
            message = message + "<br>";
        }
        if (this.disabledCount != 0) {
            message = message + I18n.trn("<b>{0}</b> object disabled", "<b>{0}</b> objects disabled", this.disabledCount, this.disabledCount);
        }
        message = message + footer;
        lblOSD.setText(message);
        lblOSD.setSize(lblOSD.getPreferredSize());
        int dx = MainApplication.getMap().mapView.getWidth() - lblOSD.getPreferredSize().width - 15;
        int dy = 15;
        g.translate(dx, dy);
        lblOSD.paintComponent(g);
        g.translate(-dx, -dy);
    }

    public List<Filter> getFilters() {
        return new ArrayList<Filter>(this.filters);
    }

    public int getFiltersCount() {
        return this.filters.size();
    }

    public int getDisabledCount() {
        return this.disabledCount;
    }

    public int getDisabledAndHiddenCount() {
        return this.disabledAndHiddenCount;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean hasFilters() {
        return this.filterMatcher.hasFilters();
    }

    public static Collection<OsmPrimitive> getAffectedPrimitives(Collection<? extends OsmPrimitive> primitives) {
        HashSet<OsmPrimitive> result = new HashSet<OsmPrimitive>();
        Stack<? extends OsmPrimitive> stack = new Stack<OsmPrimitive>();
        stack.addAll(primitives);
        while (!stack.isEmpty()) {
            OsmPrimitive p = (OsmPrimitive)stack.pop();
            if (result.contains(p)) continue;
            result.add(p);
            if (p instanceof Way) {
                for (OsmPrimitive osmPrimitive : ((Way)p).getNodes()) {
                    stack.push(osmPrimitive);
                }
            } else if (p instanceof Relation) {
                for (RelationMember relationMember : ((Relation)p).getMembers()) {
                    stack.push(relationMember.getMember());
                }
            }
            for (OsmPrimitive osmPrimitive : p.getReferrers()) {
                stack.push(osmPrimitive);
            }
        }
        return result;
    }
}

