/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DuplicateRelationAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;

    public DuplicateRelationAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, new IRelationEditorUpdateOn[0]);
        this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window", new Object[0]));
        new ImageProvider("duplicate").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation copy = new Relation();
        this.getTagModel().applyToPrimitive(copy);
        this.editorAccess.getMemberTableModel().applyToRelation(copy);
        if (!GraphicsEnvironment.isHeadless()) {
            RelationEditor.getEditor(this.getLayer(), copy, this.editorAccess.getMemberTableModel().getSelectedMembers()).setVisible(true);
        }
    }

    @Override
    protected void updateEnabledState() {
    }
}

