/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.invokers.ConstructorInvoker;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.binding.MethodInstaller;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ConstructorInvokerInstaller
extends MethodInstaller {
    protected final List<Constructor> constructors = new ArrayList<Constructor>(4);
    private boolean localConstructor;

    public ConstructorInvokerInstaller(String name2) {
        super(name2, 2);
    }

    void addConstructor(Constructor ctor, Class<?> clazz) {
        if (JavaUtil.CAN_SET_ACCESSIBLE) {
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.constructors.add(ctor);
        this.localConstructor |= clazz == ctor.getDeclaringClass();
    }

    @Override
    void install(RubyModule proxy2) {
        if (this.localConstructor) {
            proxy2.addMethod(this.name, new ConstructorInvoker(proxy2, this.constructors, this.name));
        } else {
            proxy2.addMethod(this.name, new JavaMethod(proxy2, Visibility.PUBLIC, this.name){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    throw context.runtime.newTypeError("no public constructors for " + clazz);
                }
            });
        }
    }
}

