/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader;

import java.io.IOError;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jline.reader.Completer;
import org.jline.reader.Expander;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.Parser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public final class LineReaderBuilder {
    Terminal terminal;
    String appName;
    Map<String, Object> variables;
    History history;
    Completer completer;
    History memoryHistory;
    Highlighter highlighter;
    Parser parser;
    Expander expander;

    public static LineReaderBuilder builder() {
        return new LineReaderBuilder();
    }

    private LineReaderBuilder() {
    }

    public LineReaderBuilder terminal(Terminal terminal) {
        this.terminal = terminal;
        return this;
    }

    public LineReaderBuilder appName(String appName) {
        this.appName = appName;
        return this;
    }

    public LineReaderBuilder variable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(name, value);
        return this;
    }

    public LineReader build() {
        Terminal terminal = this.terminal;
        if (terminal == null) {
            try {
                terminal = TerminalBuilder.terminal();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        LineReaderImpl reader = new LineReaderImpl(terminal, this.appName, this.variables);
        if (this.history != null) {
            reader.setHistory(this.history);
        } else {
            if (this.memoryHistory == null) {
                this.memoryHistory = new DefaultHistory();
            }
            reader.setHistory(this.memoryHistory);
        }
        if (this.completer != null) {
            reader.setCompleter(this.completer);
        }
        if (this.highlighter != null) {
            reader.setHighlighter(this.highlighter);
        }
        if (this.parser != null) {
            reader.setParser(this.parser);
        }
        if (this.expander != null) {
            reader.setExpander(this.expander);
        }
        return reader;
    }
}

