/*
 * Decompiled with CFR 0.152.
 */
package scalacache;

import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalacache.Cache;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;

@ScalaSignature(bytes="\u0006\u0001\tmgaB\u0001\u0003!\u0003\r\t!\u0002\u0002\u000e\u0003\n\u001cHO]1di\u000e\u000b7\r[3\u000b\u0003\r\t!b]2bY\u0006\u001c\u0017m\u00195f\u0007\u0001)\"AB\n\u0014\t\u00019Q\u0002\b\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00079y\u0011#D\u0001\u0003\u0013\t\u0001\"AA\u0003DC\u000eDW\r\u0005\u0002\u0013'1\u0001A!\u0002\u000b\u0001\u0005\u0004)\"!\u0001,\u0012\u0005YI\u0002C\u0001\u0005\u0018\u0013\tA\u0012BA\u0004O_RD\u0017N\\4\u0011\u0005!Q\u0012BA\u000e\n\u0005\r\te.\u001f\t\u0003\u001duI!A\b\u0002\u0003\u001d1{wmZ5oON+\b\u000f]8si\")\u0001\u0005\u0001C\u0001C\u00051A%\u001b8ji\u0012\"\u0012A\t\t\u0003\u0011\rJ!\u0001J\u0005\u0003\tUs\u0017\u000e\u001e\u0005\u0006M\u00011\tbJ\u0001\u0006I><U\r^\u000b\u0003Q-\"\"!K\u001d\u0015\u0005)\u001a\u0004c\u0001\n,a\u0011)A&\nb\u0001[\t\ta)\u0006\u0002\u0016]\u0011)qf\u000bb\u0001+\t\tq\fE\u0002\tcEI!AM\u0005\u0003\r=\u0003H/[8o\u0011\u0015!T\u0005q\u00016\u0003\u0011iw\u000eZ3\u0011\u000791\u0004(\u0003\u00028\u0005\t!Qj\u001c3f!\t\u00112\u0006C\u0003;K\u0001\u00071(A\u0002lKf\u0004\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 \n\u001b\u0005y$B\u0001!\u0005\u0003\u0019a$o\\8u}%\u0011!)C\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C\u0013!)q\t\u0001C\u0005\u0011\u0006\u00012\r[3dW\u001ac\u0017mZ:B]\u0012<U\r^\u000b\u0003\u00132#\"AS,\u0015\u0007-{%\u000bE\u0002\u0013\u0019B\"Q\u0001\f$C\u00025+\"!\u0006(\u0005\u000b=b%\u0019A\u000b\t\u000bQ2\u00059\u0001)\u0011\u000791\u0014\u000b\u0005\u0002\u0013\u0019\")1K\u0012a\u0002)\u0006)a\r\\1hgB\u0011a\"V\u0005\u0003-\n\u0011QA\u00127bONDQA\u000f$A\u0002mBQ!\u0017\u0001\u0005Fi\u000b1aZ3u+\tYf\f\u0006\u0002]KR\u0019Q,\u00193\u0011\u0007Iq\u0006\u0007B\u0003-1\n\u0007q,\u0006\u0002\u0016A\u0012)qF\u0018b\u0001+!)A\u0007\u0017a\u0002EB\u0019aBN2\u0011\u0005Iq\u0006\"B*Y\u0001\b!\u0006\"\u00024Y\u0001\u00049\u0017\u0001C6fsB\u000b'\u000f^:\u0011\u0007!A\u0017$\u0003\u0002j\u0013\tQAH]3qK\u0006$X\r\u001a \t\u000b-\u0004a\u0011\u00037\u0002\u000b\u0011|\u0007+\u001e;\u0016\u00055\u0004H\u0003\u00028wof$\"a\\:\u0011\u0007I\u0001\u0018\u0004B\u0003-U\n\u0007\u0011/\u0006\u0002\u0016e\u0012)q\u0006\u001db\u0001+!)AG\u001ba\u0002iB\u0019aBN;\u0011\u0005I\u0001\b\"\u0002\u001ek\u0001\u0004Y\u0004\"\u0002=k\u0001\u0004\t\u0012!\u0002<bYV,\u0007\"\u0002>k\u0001\u0004Y\u0018a\u0001;uYB\u0019\u0001\"\r?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\tIV\u0014\u0018\r^5p]*\u0019\u00111A\u0005\u0002\u0015\r|gnY;se\u0016tG/C\u0002\u0002\by\u0014\u0001\u0002R;sCRLwN\u001c\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0003A\u0019\u0007.Z2l\r2\fwm]!oIB+H/\u0006\u0003\u0002\u0010\u0005UA\u0003CA\t\u0003G\t)#a\n\u0015\r\u0005M\u00111DA\u0011!\u0011\u0011\u0012QC\r\u0005\u000f1\nIA1\u0001\u0002\u0018U\u0019Q#!\u0007\u0005\r=\n)B1\u0001\u0016\u0011\u001d!\u0014\u0011\u0002a\u0002\u0003;\u0001BA\u0004\u001c\u0002 A\u0019!#!\u0006\t\rM\u000bI\u0001q\u0001U\u0011\u0019Q\u0014\u0011\u0002a\u0001w!1\u00010!\u0003A\u0002EAaA_A\u0005\u0001\u0004Y\bbBA\u0016\u0001\u0011\u0015\u0013QF\u0001\u0004aV$X\u0003BA\u0018\u0003o!B!!\r\u0002JQ1\u00111GA#\u0003\u000f\"b!!\u000e\u0002>\u0005\r\u0003\u0003\u0002\n\u00028e!q\u0001LA\u0015\u0005\u0004\tI$F\u0002\u0016\u0003w!aaLA\u001c\u0005\u0004)\u0002b\u0002\u001b\u0002*\u0001\u000f\u0011q\b\t\u0005\u001dY\n\t\u0005E\u0002\u0013\u0003oAaaUA\u0015\u0001\b!\u0006B\u0002=\u0002*\u0001\u0007\u0011\u0003\u0003\u0005{\u0003S\u0001\n\u00111\u0001|\u0011\u00191\u0017\u0011\u0006a\u0001O\"9\u0011Q\n\u0001\u0007\u0012\u0005=\u0013\u0001\u00033p%\u0016lwN^3\u0016\t\u0005E\u0013q\u000b\u000b\u0005\u0003'\n\u0019\u0007\u0006\u0003\u0002V\u0005u\u0003\u0003\u0002\n\u0002Xe!q\u0001LA&\u0005\u0004\tI&F\u0002\u0016\u00037\"aaLA,\u0005\u0004)\u0002b\u0002\u001b\u0002L\u0001\u000f\u0011q\f\t\u0005\u001dY\n\t\u0007E\u0002\u0013\u0003/BaAOA&\u0001\u0004Y\u0004bBA4\u0001\u0011\u0015\u0013\u0011N\u0001\u0007e\u0016lwN^3\u0016\t\u0005-\u0014\u0011\u000f\u000b\u0005\u0003[\ni\b\u0006\u0003\u0002p\u0005]\u0004\u0003\u0002\n\u0002re!q\u0001LA3\u0005\u0004\t\u0019(F\u0002\u0016\u0003k\"aaLA9\u0005\u0004)\u0002b\u0002\u001b\u0002f\u0001\u000f\u0011\u0011\u0010\t\u0005\u001dY\nY\bE\u0002\u0013\u0003cBaAZA3\u0001\u00049\u0007bBAA\u0001\u0019E\u00111Q\u0001\fI>\u0014V-\\8wK\u0006cG.\u0006\u0003\u0002\u0006\u0006-ECAAD)\u0011\tI)!%\u0011\tI\tY)\u0007\u0003\bY\u0005}$\u0019AAG+\r)\u0012q\u0012\u0003\u0007_\u0005-%\u0019A\u000b\t\u000fQ\ny\bq\u0001\u0002\u0014B!aBNAK!\r\u0011\u00121\u0012\u0005\b\u00033\u0003AQIAN\u0003%\u0011X-\\8wK\u0006cG.\u0006\u0003\u0002\u001e\u0006\rFCAAP)\u0011\t\t+!+\u0011\tI\t\u0019+\u0007\u0003\bY\u0005]%\u0019AAS+\r)\u0012q\u0015\u0003\u0007_\u0005\r&\u0019A\u000b\t\u000fQ\n9\nq\u0001\u0002,B!aBNAW!\r\u0011\u00121\u0015\u0005\b\u0003c\u0003AQIAZ\u0003\u001d\u0019\u0017m\u00195j]\u001e,B!!.\u0002@R!\u0011qWAm)\u0011\tI,a6\u0015\t\u0005m\u0016Q\u001a\u000b\u0007\u0003{\u000b)-a3\u0011\tI\ty,\u0005\u0003\bY\u0005=&\u0019AAa+\r)\u00121\u0019\u0003\u0007_\u0005}&\u0019A\u000b\t\u000fQ\ny\u000bq\u0001\u0002HB!aBNAe!\r\u0011\u0012q\u0018\u0005\u0007'\u0006=\u00069\u0001+\t\u0013\u0005=\u0017q\u0016CA\u0002\u0005E\u0017!\u00014\u0011\t!\t\u0019.E\u0005\u0004\u0003+L!\u0001\u0003\u001fcs:\fW.\u001a \t\u0011i\fy\u000b%AA\u0002mDaAZAX\u0001\u00049\u0007bBAo\u0001\u0011\u0005\u0013q\\\u0001\tG\u0006\u001c\u0007.\u001b8h\rV!\u0011\u0011]Av)\u0011\t\u0019/a@\u0015\t\u0005\u0015\u0018Q \u000b\u0005\u0003O\fI\u0010\u0006\u0004\u0002j\u0006E\u0018q\u001f\t\u0005%\u0005-\u0018\u0003B\u0004-\u00037\u0014\r!!<\u0016\u0007U\ty\u000f\u0002\u00040\u0003W\u0014\r!\u0006\u0005\bi\u0005m\u00079AAz!\u0011qa'!>\u0011\u0007I\tY\u000f\u0003\u0004T\u00037\u0004\u001d\u0001\u0016\u0005\n\u0003\u001f\fY\u000e\"a\u0001\u0003w\u0004R\u0001CAj\u0003SD\u0001B_An!\u0003\u0005\ra\u001f\u0005\u0007M\u0006m\u0007\u0019A4\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006\u0005\t2-Y2iS:<gi\u001c:NK6|\u0017N_3\u0016\t\t\u001d!\u0011\u0003\u000b\u0005\u0005\u0013\u0011\u0019\u0003\u0006\u0003\u0003\f\t\u0005B\u0003\u0002B\u0007\u0005?!bAa\u0004\u0003\u0018\tu\u0001\u0003\u0002\n\u0003\u0012E!q\u0001\fB\u0001\u0005\u0004\u0011\u0019\"F\u0002\u0016\u0005+!aa\fB\t\u0005\u0004)\u0002b\u0002\u001b\u0003\u0002\u0001\u000f!\u0011\u0004\t\u0005\u001dY\u0012Y\u0002E\u0002\u0013\u0005#Aaa\u0015B\u0001\u0001\b!\u0006\"CAh\u0005\u0003!\t\u0019AAi\u0011!Q(\u0011\u0001I\u0001\u0002\u0004Y\bb\u0002B\u0013\u0005\u0003\u0001\raO\u0001\bE\u0006\u001cXmS3z\u0011\u001d\u0011I\u0003\u0001C!\u0005W\t!cY1dQ&twMR8s\u001b\u0016lw.\u001b>f\rV!!Q\u0006B\u001c)\u0011\u0011yCa\u0013\u0015\t\tE\"\u0011\n\u000b\u0005\u0005g\u0011)\u0005\u0006\u0004\u00036\tu\"1\t\t\u0005%\t]\u0012\u0003B\u0004-\u0005O\u0011\rA!\u000f\u0016\u0007U\u0011Y\u0004\u0002\u00040\u0005o\u0011\r!\u0006\u0005\bi\t\u001d\u00029\u0001B !\u0011qaG!\u0011\u0011\u0007I\u00119\u0004\u0003\u0004T\u0005O\u0001\u001d\u0001\u0016\u0005\n\u0003\u001f\u00149\u0003\"a\u0001\u0005\u000f\u0002R\u0001CAj\u0005kAaA\u001fB\u0014\u0001\u0004Y\bb\u0002B\u0013\u0005O\u0001\ra\u000f\u0005\b\u0005\u001f\u0002A\u0011\u0002B)\u0003!y6-Y2iS:<W\u0003\u0002B*\u00053\"\u0002B!\u0016\u0003h\t%$1\u000e\u000b\u0007\u0005/\u0012yF!\u001a\u0011\tI\u0011I&\u0005\u0003\bY\t5#\u0019\u0001B.+\r)\"Q\f\u0003\u0007_\te#\u0019A\u000b\t\u000fQ\u0012i\u0005q\u0001\u0003bA!aB\u000eB2!\r\u0011\"\u0011\f\u0005\u0007'\n5\u00039\u0001+\t\ri\u0012i\u00051\u0001<\u0011\u0019Q(Q\na\u0001w\"I\u0011q\u001aB'\t\u0003\u0007\u0011\u0011\u001b\u0005\b\u0005_\u0002A\u0011\u0002B9\u0003%y6-Y2iS:<g)\u0006\u0003\u0003t\teD\u0003\u0003B;\u0005\u000f\u0013IIa#\u0015\r\t]$q\u0010BC!\u0011\u0011\"\u0011P\t\u0005\u000f1\u0012iG1\u0001\u0003|U\u0019QC! \u0005\r=\u0012IH1\u0001\u0016\u0011\u001d!$Q\u000ea\u0002\u0005\u0003\u0003BA\u0004\u001c\u0003\u0004B\u0019!C!\u001f\t\rM\u0013i\u0007q\u0001U\u0011\u0019Q$Q\u000ea\u0001w!1!P!\u001cA\u0002mD\u0011\"a4\u0003n\u0011\u0005\rA!$\u0011\u000b!\t\u0019Na\u001e\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\u0006)Ao\\&fsR\u00191H!&\t\r\u0019\u0014y\t1\u0001h\u0011%\u0011I\nAI\u0001\n\u000b\u0011Y*A\tdC\u000eD\u0017N\\4%I\u00164\u0017-\u001e7uII*BA!(\u00036R!!q\u0014BZU\rY(\u0011U\u0016\u0003\u0005G\u0003BA!*\u000306\u0011!q\u0015\u0006\u0005\u0005S\u0013Y+A\u0005v]\u000eDWmY6fI*\u0019!QV\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00032\n\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"1aMa&A\u0002\u001d$q\u0001\fBL\u0005\u0004\u00119,F\u0002\u0016\u0005s#aa\fB[\u0005\u0004)\u0002\"\u0003B_\u0001E\u0005I\u0011\u0001B`\u0003I\u0019\u0017m\u00195j]\u001e4E\u0005Z3gCVdG\u000f\n\u001a\u0016\t\t\u0005'Q\u0019\u000b\u0005\u0005?\u0013\u0019\r\u0003\u0004g\u0005w\u0003\ra\u001a\u0003\bY\tm&\u0019\u0001Bd+\r)\"\u0011\u001a\u0003\u0007_\t\u0015'\u0019A\u000b\t\u0013\t5\u0007!%A\u0005\u0002\t=\u0017aG2bG\"Lgn\u001a$pe6+Wn\\5{K\u0012\"WMZ1vYR$#'\u0006\u0003\u0003R\nUG\u0003\u0002BP\u0005'DqA!\n\u0003L\u0002\u00071\bB\u0004-\u0005\u0017\u0014\rAa6\u0016\u0007U\u0011I\u000e\u0002\u00040\u0005+\u0014\r!\u0006")
public interface AbstractCache<V>
extends Cache<V>,
LoggingSupport {
    public <F> F doGet(String var1, Mode<F> var2);

    private <F> F checkFlagsAndGet(String key, Mode<F> mode, Flags flags) {
        F f;
        if (flags.readsEnabled()) {
            f = this.doGet(key, mode);
        } else {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping cache GET because cache reads are disabled. Key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
            }
            f = mode.M().pure(None$.MODULE$);
        }
        return f;
    }

    public static /* synthetic */ Object get$(AbstractCache $this, Seq keyParts, Mode mode, Flags flags) {
        return $this.get((Seq<Object>)keyParts, mode, flags);
    }

    @Override
    default public <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        String key = this.toKey(keyParts);
        return this.checkFlagsAndGet(key, mode, flags);
    }

    public <F> F doPut(String var1, V var2, Option<Duration> var3, Mode<F> var4);

    private <F> F checkFlagsAndPut(String key, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        F f;
        if (flags.writesEnabled()) {
            f = this.doPut(key, value, ttl, mode);
        } else {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping cache PUT because cache writes are disabled. Key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
            }
            f = mode.M().pure(BoxedUnit.UNIT);
        }
        return f;
    }

    public static /* synthetic */ Object put$(AbstractCache $this, Seq keyParts, Object value, Option ttl, Mode mode, Flags flags) {
        return $this.put((Seq<Object>)keyParts, value, (Option<Duration>)ttl, mode, flags);
    }

    @Override
    default public <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        String key = this.toKey(keyParts);
        Option finiteTtl = ttl.filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFinite()));
        return this.checkFlagsAndPut(key, value, (Option<Duration>)finiteTtl, mode, flags);
    }

    public <F> F doRemove(String var1, Mode<F> var2);

    public static /* synthetic */ Object remove$(AbstractCache $this, Seq keyParts, Mode mode) {
        return $this.remove((Seq<Object>)keyParts, mode);
    }

    @Override
    default public <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return this.doRemove(this.toKey(keyParts), mode);
    }

    public <F> F doRemoveAll(Mode<F> var1);

    public static /* synthetic */ Object removeAll$(AbstractCache $this, Mode mode) {
        return $this.removeAll(mode);
    }

    @Override
    default public <F> F removeAll(Mode<F> mode) {
        return this.doRemoveAll(mode);
    }

    public static /* synthetic */ Object caching$(AbstractCache $this, Seq keyParts, Option ttl, Function0 f, Mode mode, Flags flags) {
        return $this.caching((Seq<Object>)keyParts, (Option<Duration>)ttl, f, mode, flags);
    }

    @Override
    default public <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        String key = this.toKey(keyParts);
        return this._caching(key, ttl, f, mode, flags);
    }

    public static /* synthetic */ Option caching$default$2$(AbstractCache $this, Seq keyParts) {
        return $this.caching$default$2((Seq<Object>)keyParts);
    }

    default public <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return None$.MODULE$;
    }

    public static /* synthetic */ Object cachingF$(AbstractCache $this, Seq keyParts, Option ttl, Function0 f, Mode mode, Flags flags) {
        return $this.cachingF((Seq<Object>)keyParts, (Option<Duration>)ttl, f, mode, flags);
    }

    @Override
    default public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        String key = this.toKey(keyParts);
        return this._cachingF(key, ttl, f, mode, flags);
    }

    public static /* synthetic */ Option cachingF$default$2$(AbstractCache $this, Seq keyParts) {
        return $this.cachingF$default$2((Seq<Object>)keyParts);
    }

    default public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return None$.MODULE$;
    }

    public static /* synthetic */ Object cachingForMemoize$(AbstractCache $this, String baseKey, Option ttl, Function0 f, Mode mode, Flags flags) {
        return $this.cachingForMemoize(baseKey, (Option<Duration>)ttl, f, mode, flags);
    }

    @Override
    default public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        String key = this.config().cacheKeyBuilder().stringToCacheKey(baseKey);
        return this._caching(key, ttl, f, mode, flags);
    }

    public static /* synthetic */ Option cachingForMemoize$default$2$(AbstractCache $this, String baseKey) {
        return $this.cachingForMemoize$default$2(baseKey);
    }

    default public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return None$.MODULE$;
    }

    public static /* synthetic */ Object cachingForMemoizeF$(AbstractCache $this, String baseKey, Option ttl, Function0 f, Mode mode, Flags flags) {
        return $this.cachingForMemoizeF(baseKey, (Option<Duration>)ttl, f, mode, flags);
    }

    @Override
    default public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        String key = this.config().cacheKeyBuilder().stringToCacheKey(baseKey);
        return this._cachingF(key, ttl, f, mode, flags);
    }

    private <F> F _caching(String key, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return mode.M().flatMap(mode.M().handleNonFatal((Function0 & java.io.Serializable & Serializable)() -> this.checkFlagsAndGet(key, mode, flags), (Function1 & java.io.Serializable & Serializable)e -> {
            block0: {
                if (!this.logger().isWarnEnabled()) break block0;
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read from cache. Key = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), e);
            }
            return None$.MODULE$;
        }), (Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Object f;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object valueFromCache = some.value();
                f = mode.M().pure(valueFromCache);
            } else if (None$.MODULE$.equals(option)) {
                Object calculatedValue = f.apply();
                f = mode.M().map(mode.M().handleNonFatal((Function0 & java.io.Serializable & Serializable)() -> this.checkFlagsAndPut(key, calculatedValue, ttl, mode, flags), (Function1 & java.io.Serializable & Serializable)e -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().isWarnEnabled()) {
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write to cache. Key = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }), (Function1 & java.io.Serializable & Serializable)x$2 -> calculatedValue);
            } else {
                throw new MatchError((Object)option);
            }
            return f;
        });
    }

    private <F> F _cachingF(String key, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return mode.M().flatMap(mode.M().handleNonFatal((Function0 & java.io.Serializable & Serializable)() -> this.checkFlagsAndGet(key, mode, flags), (Function1 & java.io.Serializable & Serializable)e -> {
            block0: {
                if (!this.logger().isWarnEnabled()) break block0;
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read from cache. Key = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), e);
            }
            return None$.MODULE$;
        }), (Function1 & java.io.Serializable & Serializable)x0$2 -> {
            Object object;
            Option option = x0$2;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object valueFromCache = some.value();
                object = mode.M().pure(valueFromCache);
            } else if (None$.MODULE$.equals(option)) {
                object = mode.M().flatMap(f.apply(), (Function1 & java.io.Serializable & Serializable)calculatedValue -> mode.M().map(mode.M().handleNonFatal((Function0 & java.io.Serializable & Serializable)() -> this.checkFlagsAndPut(key, calculatedValue, ttl, mode, flags), (Function1 & java.io.Serializable & Serializable)e -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().isWarnEnabled()) {
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write to cache. Key = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }), (Function1 & java.io.Serializable & Serializable)x$3 -> calculatedValue));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private String toKey(Seq<Object> keyParts) {
        return this.config().cacheKeyBuilder().toCacheKey(keyParts);
    }

    public static void $init$(AbstractCache $this) {
    }
}

