/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor.plugin;

import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.plugin.FileHandler;
import net.sf.sdedit.ui.Tab;
import net.sf.sdedit.ui.UserInterface;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.BeanConverter;
import net.sf.sdedit.ui.impl.DiagramTextTab;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.DocUtil;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.Utilities;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractFileHandler
implements FileHandler {
    public static JFileChooser FILE_CHOOSER = new JFileChooser();
    private static boolean sync;
    private File currentFile;

    protected AbstractFileHandler() {
    }

    protected UserInterfaceImpl getUI() {
        return (UserInterfaceImpl)Editor.getEditor().getUI();
    }

    protected abstract DiagramTextTab createTab(Font var1, Bean<? extends Configuration> var2);

    protected Tab _loadFile(URL file) throws IOException {
        InputStream stream = file.openStream();
        try {
            String encoding = ConfigurationManager.getGlobalConfiguration().getFileEncoding();
            Font editorFont = ConfigurationManager.getGlobalConfiguration().getEditorFont();
            Pair<String, Bean<? extends Configuration>> result = this.load(stream, encoding);
            DiagramTextTab tab = this.createTab(editorFont, result.getSecond());
            tab.setCode(result.getFirst());
            DiagramTextTab diagramTextTab = tab;
            return diagramTextTab;
        }
        catch (DocUtil.XMLException e) {
            throw new IOException("The file could not be loaded because of an XMLException: " + e.getMessage());
        }
        finally {
            stream.close();
        }
    }

    protected abstract boolean isXML(File var1);

    protected boolean _saveFile(Tab tab, File file) throws IOException {
        DiagramTextTab dtab = (DiagramTextTab)tab;
        Bean<? extends Configuration> configuration = this.isXML(file) ? dtab.getConfiguration() : null;
        FileOutputStream stream = new FileOutputStream(file);
        String code = dtab.getCode();
        String encoding = ConfigurationManager.getGlobalConfiguration().getFileEncoding();
        try {
            AbstractFileHandler.saveDiagram(code, configuration, stream, encoding);
            boolean bl = true;
            return bl;
        }
        catch (DocUtil.XMLException e) {
            throw new IOException("The diagram could not be saved because of an XMLException: " + e.getMessage());
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    protected String[] getFileTypesWithDescriptions() {
        String[] descriptions;
        String[] types = this.getFileTypes();
        if (types.length != (descriptions = this.getFileDescriptions()).length) {
            throw new IllegalArgumentException("The file handler defines " + types.length + " file types, but " + descriptions.length + " descriptions");
        }
        String[] result = new String[types.length * 2];
        for (int i = 0; i < types.length; ++i) {
            result[i * 2] = descriptions[i];
            result[i * 2 + 1] = types[i];
        }
        return result;
    }

    private static void updateFileChooserDirectory(File file) {
        if (!sync) {
            File parent;
            if (file != null && (parent = file.getParentFile()) != null) {
                FILE_CHOOSER.setCurrentDirectory(parent);
            }
            sync = true;
        }
    }

    protected Component getComponent() {
        Tab tab = Editor.getEditor().getUI().currentTab();
        return tab;
    }

    protected abstract Bean<? extends Configuration> createNewConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<String, Bean<? extends Configuration>> load(InputStream stream, String encoding) throws IOException, DocUtil.XMLException {
        String source;
        InputStreamReader reader = new InputStreamReader(stream, encoding);
        BufferedReader buffered = new BufferedReader(reader);
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        boolean xml = false;
        String line = buffered.readLine();
        while (line != null) {
            xml |= line.trim().startsWith("<?xml");
            writer.println(line);
            line = buffered.readLine();
        }
        writer.close();
        Bean<? extends Configuration> configuration = this.createNewConfiguration();
        if (xml) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(stringWriter.toString().getBytes(encoding));
            try {
                Document document = DocUtil.readDocument(inputStream, encoding);
                source = DocUtil.evaluateCDATA(document, "/diagram/source");
                Element confElement = (Element)DocUtil.evalXPathAsNode(document, "/diagram/configuration");
                BeanConverter converter = new BeanConverter(configuration, document);
                converter.setValues(confElement);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        } else {
            source = stringWriter.toString();
        }
        return new Pair<String, Bean<? extends Configuration>>(source, configuration);
    }

    private static void saveDiagram(String source, Bean<? extends Configuration> configuration, OutputStream stream, String encoding) throws IOException, DocUtil.XMLException {
        if (configuration != null) {
            Document document = DocUtil.newDocument();
            Element root = document.createElement("diagram");
            document.appendChild(root);
            BeanConverter converter = new BeanConverter(configuration, document);
            Element sourceElem = document.createElement("source");
            CDATASection sourceNode = document.createCDATASection(source);
            sourceElem.appendChild(sourceNode);
            root.appendChild(sourceElem);
            Element configurationNode = converter.createElement("configuration");
            root.appendChild(configurationNode);
            DocUtil.writeDocument(document, encoding, stream);
        } else {
            OutputStreamWriter osw = new OutputStreamWriter(stream, encoding);
            PrintWriter pw = new PrintWriter(osw);
            pw.print(source);
            pw.flush();
        }
    }

    @Override
    public final Tab loadFile(URL url, final UserInterface ui) throws IOException {
        if (!"file".equals(url.getProtocol()) || !ui.selectTabWith(Utilities.toFile(url))) {
            ui.getTabContainer().disableTabHistory();
            final Tab tab = this._loadFile(url);
            if (tab == null) {
                return null;
            }
            if (url.getProtocol().equals("file")) {
                tab.setFile(Utilities.toFile(url));
            }
            tab.setClean(true);
            this.addTabToUI(tab, ui);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (tab.getFile() != null) {
                        AbstractFileHandler.updateFileChooserDirectory(tab.getFile());
                        if (tab.getFile().exists()) {
                            Editor.getEditor().addToRecentFiles(tab.getFile().getAbsolutePath());
                        }
                    }
                    ui.getTabContainer().enableTabHistory();
                }
            });
            return tab;
        }
        return null;
    }

    protected void addTabToUI(Tab tab, UserInterface ui) {
        ui.addTab(tab, true);
    }

    @Override
    public File save(Tab tab, boolean as) throws IOException {
        File file = null;
        if (!as) {
            file = tab.getFile();
        }
        if (file == null) {
            file = this.selectFileToSave();
        }
        if (file != null) {
            int confirmation = 1;
            if (file.exists() && !file.equals(tab.getFile())) {
                confirmation = tab.get_UI().confirmOrCancel("<html>" + file.getName() + " already exists.<br>Do you want to overwrite it?");
            }
            if (confirmation == 1) {
                AbstractFileHandler.updateFileChooserDirectory(file);
                this.currentFile = file;
                if (this._saveFile(tab, file)) {
                    tab.setFile(file);
                    tab.setClean(true);
                    Editor.getEditor().addToRecentFiles(file.getAbsolutePath());
                    return file;
                }
            }
        }
        return null;
    }

    private String getFileName() {
        if (this.currentFile != null) {
            return this.currentFile.getName();
        }
        return "";
    }

    @Override
    public File selectFileToOpen() {
        File[] files = this.getFiles(true, false, this.getOpenDescription());
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    @Override
    public File[] selectFilesToOpen() {
        return this.getFiles(true, true, this.getOpenDescription());
    }

    @Override
    public File selectFileToSave() {
        File[] files = this.getFiles(false, false, this.getSaveAsDescription());
        if (files == null) {
            return null;
        }
        return files[0];
    }

    protected File[] getFiles(boolean open, boolean multiple, String message) {
        return this.getFiles(open, multiple, message, null, null);
    }

    @Override
    public File[] getFiles(boolean open, boolean multiple, String message, String file, String ... filter) {
        if (file == null) {
            file = this.getFileName();
        }
        if (filter == null) {
            filter = this.getFileTypesWithDescriptions();
        }
        return Utilities.chooseFiles(FILE_CHOOSER, this.getComponent(), open, multiple, message, file, filter);
    }

    static {
        FILE_CHOOSER.setCurrentDirectory(new File("."));
        sync = false;
    }
}

