/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Color;
import org.freehep.graphicsio.ps.ColorMap;

public class MappedColor
extends Color {
    protected int colorIndex;
    protected int brightness;

    public MappedColor(int r, int g, int b, int colorIndex) {
        super(r, g, b);
        this.colorIndex = colorIndex;
        this.brightness = 0;
    }

    public MappedColor(int r, int g, int b, int colorIndex, int brightness) {
        super(r, g, b);
        this.colorIndex = colorIndex;
        this.brightness = brightness;
    }

    @Override
    public Color brighter() {
        int r = this.getRed() * 10 / 7;
        int g = this.getGreen() * 10 / 7;
        int b = this.getBlue() * 10 / 7;
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        return new MappedColor(r, g, b, this.colorIndex, this.brightness - 1);
    }

    @Override
    public Color darker() {
        int r = this.getRed() * 7 / 10;
        int g = this.getGreen() * 7 / 10;
        int b = this.getBlue() * 7 / 10;
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        return new MappedColor(r, g, b, this.colorIndex, this.brightness - 1);
    }

    public int getBrightness() {
        return this.brightness;
    }

    public String getColorTag() {
        return ColorMap.getTag(this.colorIndex);
    }
}

