#ifndef _EFL_TASK_EO_H_
#define _EFL_TASK_EO_H_

#ifndef _EFL_TASK_EO_CLASS_TYPE
#define _EFL_TASK_EO_CLASS_TYPE

typedef Eo Efl_Task;

#endif

#ifndef _EFL_TASK_EO_TYPES
#define _EFL_TASK_EO_TYPES

/** No description supplied.
 *
 * @since 1.22
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_TASK_PRIORITY_NORMAL = 0,
  EFL_TASK_PRIORITY_BACKGROUND,
  EFL_TASK_PRIORITY_LOW,
  EFL_TASK_PRIORITY_HIGH,
  EFL_TASK_PRIORITY_ULTRA
} Efl_Task_Priority;

/** No description supplied.
 *
 * @since 1.22
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_TASK_FLAGS_NONE = 0,
  EFL_TASK_FLAGS_USE_STDIN = 1,
  EFL_TASK_FLAGS_USE_STDOUT = 2,
  EFL_TASK_FLAGS_NO_EXIT_CODE_ERROR = 4
} Efl_Task_Flags;


#endif
/** No description supplied.
 *
 * @since 1.22
 *
 * @ingroup Efl_Task
 */
#define EFL_TASK_CLASS efl_task_class_get()

EWAPI const Efl_Class *efl_task_class_get(void);

/**
 * @brief The priority of this task.
 *
 * @param[in] obj The object.
 * @param[in] priority No description supplied.
 *
 * @since 1.22
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_priority_set(Eo *obj, Efl_Task_Priority priority);

/**
 * @brief The priority of this task.
 *
 * @param[in] obj The object.
 *
 * @return No description supplied.
 *
 * @since 1.22
 *
 * @ingroup Efl_Task
 */
EOAPI Efl_Task_Priority efl_task_priority_get(const Eo *obj);

/**
 * @brief The final exit code of this task.
 *
 * @param[in] obj The object.
 *
 * @return No description supplied.
 *
 * @since 1.22
 *
 * @ingroup Efl_Task
 */
EOAPI int efl_task_exit_code_get(const Eo *obj);

EOAPI void efl_task_flags_set(Eo *obj, Efl_Task_Flags flags);

EOAPI Efl_Task_Flags efl_task_flags_get(const Eo *obj);

/**
 * @brief Actually run the task
 *
 * @param[in] obj The object.
 *
 * @return A future triggered when task exits and is passed int exit code
 *
 * @since 1.22
 *
 * @ingroup Efl_Task
 */
EOAPI Eina_Future *efl_task_run(Eo *obj);

/** Request the task end (may send a signal or interrupt signal resulting in a
 * terminate event being tiggered in the target task loop)
 *
 * @since 1.22
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_end(Eo *obj);

#endif
