#ifndef _EFL_UI_ALERT_POPUP_EO_H_
#define _EFL_UI_ALERT_POPUP_EO_H_

#ifndef _EFL_UI_ALERT_POPUP_EO_CLASS_TYPE
#define _EFL_UI_ALERT_POPUP_EO_CLASS_TYPE

typedef Eo Efl_Ui_Alert_Popup;

#endif

#ifndef _EFL_UI_ALERT_POPUP_EO_TYPES
#define _EFL_UI_ALERT_POPUP_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** Defines the type of the alert button.
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_ALERT_POPUP_BUTTON_POSITIVE = 0, /**< Button having positive meaning.
                                           * e.g. "Yes" */
  EFL_UI_ALERT_POPUP_BUTTON_NEGATIVE, /**< Button having negative meaning. e.g.
                                       * "No" */
  EFL_UI_ALERT_POPUP_BUTTON_USER /**< Button having user-defined meaning. e.g.
                                  * "Cancel" */
} Efl_Ui_Alert_Popup_Button;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Information of clicked event
 *
 * @ingroup Efl_Ui
 */
typedef struct _Efl_Ui_Alert_Popup_Button_Clicked_Event
{
  Efl_Ui_Alert_Popup_Button button_type; /**< Clicked button type */
} Efl_Ui_Alert_Popup_Button_Clicked_Event;
#endif /* EFL_BETA_API_SUPPORT */


#endif
#ifdef EFL_BETA_API_SUPPORT
/** EFL UI Alert Popup class
 *
 * @ingroup Efl_Ui_Alert_Popup
 */
#define EFL_UI_ALERT_POPUP_CLASS efl_ui_alert_popup_class_get()

EWAPI const Efl_Class *efl_ui_alert_popup_class_get(void);

/**
 * @brief Set popup buttons.
 *
 * @param[in] obj The object.
 * @param[in] type Alert popup button type
 * @param[in] text Alert string on button
 * @param[in] icon Alert icon on button
 *
 * @ingroup Efl_Ui_Alert_Popup
 */
EOAPI void efl_ui_alert_popup_button_set(Eo *obj, Efl_Ui_Alert_Popup_Button type, const char *text, Efl_Object *icon);

EWAPI extern const Efl_Event_Description _EFL_UI_ALERT_POPUP_EVENT_BUTTON_CLICKED;

/** Called when alert popup was clicked
 * @return Efl_Ui_Alert_Popup_Button_Clicked_Event
 *
 * @ingroup Efl_Ui_Alert_Popup
 */
#define EFL_UI_ALERT_POPUP_EVENT_BUTTON_CLICKED (&(_EFL_UI_ALERT_POPUP_EVENT_BUTTON_CLICKED))
#endif /* EFL_BETA_API_SUPPORT */

#endif
