/*
 * Decompiled with CFR 0.152.
 */
package gnu.activation.viewers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class ImageViewer
extends Component
implements CommandObject {
    private Image image;

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.image != null) {
            dimension.width = this.image.getWidth(this);
            dimension.height = this.image.getHeight(this);
        }
        return dimension;
    }

    @Override
    public void setCommandContext(String string, DataHandler dataHandler) throws IOException {
        InputStream inputStream = dataHandler.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        Toolkit toolkit = this.getToolkit();
        Image image = toolkit.createImage(byteArrayOutputStream.toByteArray());
        try {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        toolkit.prepareImage(image, -1, -1, this);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.image = image;
            this.invalidate();
            this.repaint();
            return false;
        }
        return (n & 0x40) == 0;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.image != null) {
            Dimension dimension = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            if (dimension.width > -1 && dimension.height > -1) {
                Dimension dimension2 = this.getSize();
                graphics.drawImage(this.image, 0, 0, dimension2.width, dimension2.height, 0, 0, dimension.width, dimension.height, this);
            }
        }
    }
}

