/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.Serializable;
import javajs.api.JSONEncodable;
import javajs.util.M3;
import javajs.util.T3;
import javajs.util.V3;

public class A4
implements JSONEncodable,
Serializable {
    public float x;
    public float y;
    public float z = 1.0f;
    public float angle;

    public static A4 new4(float x, float y, float z, float angle) {
        A4 a = new A4();
        a.set4(x, y, z, angle);
        return a;
    }

    public static A4 newAA(A4 a1) {
        A4 a = new A4();
        a.set4(a1.x, a1.y, a1.z, a1.angle);
        return a;
    }

    public static A4 newVA(V3 axis, float angle) {
        A4 a = new A4();
        a.setVA(axis, angle);
        return a;
    }

    public final void setVA(V3 axis, float angle) {
        this.x = axis.x;
        this.y = axis.y;
        this.z = axis.z;
        this.angle = angle;
    }

    public final void set4(float x, float y, float z, float angle) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.angle = angle;
    }

    public final void setAA(A4 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.angle = a.angle;
    }

    public final void setM(M3 m1) {
        this.setFromMat(m1.m00, m1.m01, m1.m02, m1.m10, m1.m11, m1.m12, m1.m20, m1.m21, m1.m22);
    }

    private void setFromMat(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double cos = (m00 + m11 + m22 - 1.0) * 0.5;
        this.x = (float)(m21 - m12);
        this.y = (float)(m02 - m20);
        this.z = (float)(m10 - m01);
        double sin = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (sin == 0.0 && cos == 1.0) {
            this.y = 0.0f;
            this.x = 0.0f;
            this.z = 1.0f;
            this.angle = 0.0f;
        } else {
            this.angle = (float)Math.atan2(sin, cos);
        }
    }

    public int hashCode() {
        return T3.floatToIntBits(this.x) ^ T3.floatToIntBits(this.y) ^ T3.floatToIntBits(this.z) ^ T3.floatToIntBits(this.angle);
    }

    public boolean equals(Object o) {
        if (!(o instanceof A4)) {
            return false;
        }
        A4 a1 = (A4)o;
        return this.x == a1.x && this.y == a1.y && this.z == a1.z && this.angle == a1.angle;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.angle + ")";
    }

    @Override
    public String toJSON() {
        return "[" + this.x + "," + this.y + "," + this.z + "," + (float)((double)this.angle * 180.0 / Math.PI) + "]";
    }
}

