/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.spi.preferences.Config;

public abstract class SourcePrefHelper {
    private final String pref;
    protected final SourceType type;

    public SourcePrefHelper(String pref, SourceType type) {
        this.pref = pref;
        this.type = type;
    }

    public abstract Collection<ExtendedSourceEntry> getDefault();

    public abstract Map<String, String> serialize(SourceEntry var1);

    public abstract SourceEntry deserialize(Map<String, String> var1);

    public List<SourceEntry> get() {
        List<Map<String, String>> src = Config.getPref().getListOfMaps(this.pref, null);
        if (src == null) {
            return new ArrayList<SourceEntry>(this.getDefault());
        }
        ArrayList<SourceEntry> entries = new ArrayList<SourceEntry>();
        for (Map<String, String> sourcePref : src) {
            SourceEntry e = this.deserialize(new HashMap<String, String>(sourcePref));
            if (e == null) continue;
            entries.add(e);
        }
        return entries;
    }

    public boolean put(Collection<? extends SourceEntry> entries) {
        List<Map<String, String>> def;
        boolean unset;
        List<Map<String, String>> setting = this.serializeList(entries);
        boolean bl = unset = Config.getPref().getListOfMaps(this.pref, null) == null;
        if (unset && setting.equals(def = this.serializeList(this.getDefault()))) {
            return false;
        }
        return Config.getPref().putListOfMaps(this.pref, setting);
    }

    private List<Map<String, String>> serializeList(Collection<? extends SourceEntry> entries) {
        return new ArrayList<SourceEntry>(entries).stream().map(this::serialize).collect(Collectors.toList());
    }

    public final Set<String> getActiveUrls() {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        for (SourceEntry e : this.get()) {
            if (!e.active) continue;
            urls.add(e.url);
        }
        return urls;
    }
}

