/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.MutableComboBoxModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxImageCorrelation;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.data.gpx.GpxTimeOffset;
import org.openstreetmap.josm.data.gpx.GpxTimezone;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.io.importexport.JpgImporter;
import org.openstreetmap.josm.gui.io.importexport.NMEAImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.IGpxReader;
import org.openstreetmap.josm.io.nmea.NmeaReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.SAXException;

public class CorrelateGpxWithImages
extends AbstractAction {
    private static final List<GpxData> loadedGpxData = new ArrayList<GpxData>();
    private final transient GeoImageLayer yLayer;
    private transient GpxTimezone timezone;
    private transient GpxTimeOffset delta;
    private static boolean forceTags;
    private ExtendedDialog syncDialog;
    private final transient List<GpxDataWrapper> gpxLst = new ArrayList<GpxDataWrapper>();
    private JPanel outerPanel;
    private JosmComboBox<GpxDataWrapper> cbGpx;
    private JosmTextField tfTimezone;
    private JosmTextField tfOffset;
    private JCheckBox cbExifImg;
    private JCheckBox cbTaggedImg;
    private JCheckBox cbShowThumbs;
    private JLabel statusBarText;
    private int lastNumMatched;
    private final transient StatusBarUpdater statusBarUpdater = new StatusBarUpdater(false);
    private final transient StatusBarUpdater statusBarUpdaterWithRepaint = new StatusBarUpdater(true);
    private final transient RepaintTheMapListener repaintTheMap = new RepaintTheMapListener();

    public CorrelateGpxWithImages(GeoImageLayer layer) {
        super(I18n.tr("Correlate to GPX", new Object[0]));
        new ImageProvider("dialogs/geoimage/gpx2img").getResource().attachImageIcon(this, true);
        this.yLayer = layer;
        MainApplication.getLayerManager().addLayerChangeListener(new GpxLayerAddedListener());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.gpxLst.clear();
        GpxDataWrapper defaultItem = null;
        for (GpxLayer cur : MainApplication.getLayerManager().getLayersOfType(GpxLayer.class)) {
            GpxDataWrapper gdw = new GpxDataWrapper(cur.getName(), cur.data, cur.data.storageFile);
            this.gpxLst.add(gdw);
            if (cur != this.yLayer.gpxLayer) continue;
            defaultItem = gdw;
        }
        for (GpxData data : loadedGpxData) {
            this.gpxLst.add(new GpxDataWrapper(data.storageFile.getName(), data, data.storageFile));
        }
        if (this.gpxLst.isEmpty()) {
            this.gpxLst.add(new GpxDataWrapper(I18n.tr("<No GPX track loaded yet>", new Object[0]), null, null));
        }
        JPanel panelCb = new JPanel();
        panelCb.add(new JLabel(I18n.tr("GPX track: ", new Object[0])));
        this.cbGpx = new JosmComboBox<GpxDataWrapper>(this.gpxLst.toArray(new GpxDataWrapper[0]));
        if (defaultItem != null) {
            this.cbGpx.setSelectedItem(defaultItem);
        } else {
            this.gpxLst.stream().filter(i -> ((GpxDataWrapper)i).file != null).findFirst().ifPresent(this.cbGpx::setSelectedItem);
        }
        this.cbGpx.addActionListener(this.statusBarUpdaterWithRepaint);
        panelCb.add(this.cbGpx);
        JButton buttonOpen = new JButton(I18n.tr("Open another GPX trace", new Object[0]));
        buttonOpen.addActionListener(new LoadGpxDataActionListener());
        panelCb.add(buttonOpen);
        JPanel panelTf = new JPanel(new GridBagLayout());
        try {
            String tz = Config.getPref().get("geoimage.timezone");
            this.timezone = !tz.isEmpty() ? GpxTimezone.parseTimezone(tz) : new GpxTimezone((double)TimeUnit.MILLISECONDS.toMinutes(TimeZone.getDefault().getRawOffset()) / 60.0);
        }
        catch (ParseException e) {
            this.timezone = GpxTimezone.ZERO;
            Logging.trace(e);
        }
        this.tfTimezone = new JosmTextField(10);
        this.tfTimezone.setText(this.timezone.formatTimezone());
        try {
            this.delta = GpxTimeOffset.parseOffset(Config.getPref().get("geoimage.delta", "0"));
        }
        catch (ParseException e) {
            this.delta = GpxTimeOffset.ZERO;
            Logging.trace(e);
        }
        this.tfOffset = new JosmTextField(10);
        this.tfOffset.setText(this.delta.formatOffset());
        JButton buttonViewGpsPhoto = new JButton(I18n.tr("<html>Use photo of an accurate clock,<br>e.g. GPS receiver display</html>", new Object[0]));
        buttonViewGpsPhoto.setIcon(ImageProvider.get("clock"));
        buttonViewGpsPhoto.addActionListener(new SetOffsetActionListener());
        JButton buttonAutoGuess = new JButton(I18n.tr("Auto-Guess", new Object[0]));
        buttonAutoGuess.setToolTipText(I18n.tr("Matches first photo with first gpx point", new Object[0]));
        buttonAutoGuess.addActionListener(new AutoGuessActionListener());
        JButton buttonAdjust = new JButton(I18n.tr("Manual adjust", new Object[0]));
        buttonAdjust.addActionListener(new AdjustActionListener());
        JButton buttonAdvanced = new JButton(I18n.tr("Advanced settings...", new Object[0]));
        buttonAdvanced.addActionListener(new AdvancedSettingsActionListener());
        JLabel labelPosition = new JLabel(I18n.tr("Override position for: ", new Object[0]));
        int numAll = this.getSortedImgList(true, true).size();
        int numExif = numAll - this.getSortedImgList(false, true).size();
        int numTagged = numAll - this.getSortedImgList(true, false).size();
        this.cbExifImg = new JCheckBox(I18n.tr("Images with geo location in exif data ({0}/{1})", numExif, numAll));
        this.cbExifImg.setEnabled(numExif != 0);
        this.cbTaggedImg = new JCheckBox(I18n.tr("Images that are already tagged ({0}/{1})", numTagged, numAll), true);
        this.cbTaggedImg.setEnabled(numTagged != 0);
        labelPosition.setEnabled(this.cbExifImg.isEnabled() || this.cbTaggedImg.isEnabled());
        boolean ticked = this.yLayer.thumbsLoaded || Config.getPref().getBoolean("geoimage.showThumbs", false);
        this.cbShowThumbs = new JCheckBox(I18n.tr("Show Thumbnail images on the map", new Object[0]), ticked);
        this.cbShowThumbs.setEnabled(!this.yLayer.thumbsLoaded);
        int y = 0;
        GBC gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)panelCb, gbc);
        gbc = GBC.eol().fill(2).insets(0, 0, 0, 12);
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)new JSeparator(0), gbc);
        gbc = GBC.std();
        gbc.gridx = 0;
        gbc.gridy = y;
        panelTf.add((Component)new JLabel(I18n.tr("Timezone: ", new Object[0])), gbc);
        gbc = GBC.std().fill(2);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.weightx = 1.0;
        panelTf.add((Component)this.tfTimezone, gbc);
        gbc = GBC.std();
        gbc.gridx = 0;
        gbc.gridy = y;
        panelTf.add((Component)new JLabel(I18n.tr("Offset:", new Object[0])), gbc);
        gbc = GBC.std().fill(2);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.weightx = 1.0;
        panelTf.add((Component)this.tfOffset, gbc);
        gbc = GBC.std().insets(5, 5, 5, 5);
        gbc.gridx = 2;
        gbc.gridy = y - 2;
        gbc.gridheight = 2;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 0.5;
        panelTf.add((Component)buttonViewGpsPhoto, gbc);
        gbc = GBC.std().fill(1).insets(5, 5, 5, 5);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.weightx = 0.5;
        panelTf.add((Component)buttonAdvanced, gbc);
        gbc.gridx = 2;
        panelTf.add((Component)buttonAutoGuess, gbc);
        gbc.gridx = 3;
        panelTf.add((Component)buttonAdjust, gbc);
        gbc = GBC.eol().fill(2).insets(0, 12, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)new JSeparator(0), gbc);
        gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)labelPosition, gbc);
        gbc = GBC.eol();
        gbc.gridx = 1;
        gbc.gridy = y++;
        panelTf.add((Component)this.cbExifImg, gbc);
        gbc = GBC.eol();
        gbc.gridx = 1;
        gbc.gridy = y++;
        panelTf.add((Component)this.cbTaggedImg, gbc);
        gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y;
        panelTf.add((Component)this.cbShowThumbs, gbc);
        JPanel statusBar = new JPanel(new FlowLayout(0, 0, 0));
        statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBarText = new JLabel(" ");
        this.statusBarText.setFont(this.statusBarText.getFont().deriveFont(8));
        statusBar.add(this.statusBarText);
        this.tfTimezone.addFocusListener(this.repaintTheMap);
        this.tfOffset.addFocusListener(this.repaintTheMap);
        this.tfTimezone.getDocument().addDocumentListener(this.statusBarUpdater);
        this.tfOffset.getDocument().addDocumentListener(this.statusBarUpdater);
        this.cbExifImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.cbTaggedImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.statusBarUpdater.updateStatusBar();
        this.yLayer.updateBufferAndRepaint();
        this.outerPanel = new JPanel(new BorderLayout());
        this.outerPanel.add((Component)statusBar, "Last");
        if (!GraphicsEnvironment.isHeadless()) {
            this.syncDialog = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Correlate images with GPX track", new Object[0]), new String[]{I18n.tr("Correlate", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
            this.syncDialog.setContent(panelTf, false);
            this.syncDialog.setButtonIcons("ok", "cancel");
            this.syncDialog.setupDialog();
            this.outerPanel.add((Component)this.syncDialog.getContentPane(), "First");
            this.syncDialog.setContentPane(this.outerPanel);
            this.syncDialog.pack();
            this.syncDialog.addWindowListener(new SyncDialogWindowListener());
            this.syncDialog.showDialog();
        }
    }

    static Pair<GpxTimezone, GpxTimeOffset> autoGuess(List<ImageEntry> imgs, GpxData gpx) throws NoGpxTimestamps {
        long firstExifDate = imgs.get(0).getExifTime().getTime();
        long firstGPXDate = -1L;
        block0: for (GpxTrack trk : gpx.tracks) {
            for (GpxTrackSegment segment : trk.getSegments()) {
                for (WayPoint curWp : segment.getWayPoints()) {
                    if (!curWp.hasDate()) continue;
                    firstGPXDate = curWp.getTimeInMillis();
                    break block0;
                }
            }
        }
        if (firstGPXDate < 0L) {
            throw new NoGpxTimestamps();
        }
        return GpxTimeOffset.milliseconds(firstExifDate - firstGPXDate).splitOutTimezone();
    }

    private List<ImageEntry> getSortedImgList() {
        return this.getSortedImgList(this.cbExifImg.isSelected(), this.cbTaggedImg.isSelected());
    }

    private List<ImageEntry> getSortedImgList(boolean exif, boolean tagged) {
        ArrayList<ImageEntry> dateImgLst = new ArrayList<ImageEntry>(this.yLayer.getImageData().getImages().size());
        for (ImageEntry e : this.yLayer.getImageData().getImages()) {
            if (!e.hasExifTime() || e.getExifCoor() != null && !exif || !tagged && e.isTagged() && e.getExifCoor() == null) continue;
            dateImgLst.add(e);
        }
        dateImgLst.sort(Comparator.comparing(GpxImageEntry::getExifTime));
        return dateImgLst;
    }

    private GpxDataWrapper selectedGPX(boolean complain) {
        Object item = this.cbGpx.getSelectedItem();
        if (item == null || ((GpxDataWrapper)item).file == null) {
            if (complain) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("You should select a GPX track", new Object[0]), I18n.tr("No selected GPX track", new Object[0]), 0);
            }
            return null;
        }
        return (GpxDataWrapper)item;
    }

    private class AutoGuessActionListener
    implements ActionListener {
        private AutoGuessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GpxDataWrapper gpxW = CorrelateGpxWithImages.this.selectedGPX(true);
            if (gpxW == null) {
                return;
            }
            GpxData gpx = gpxW.data;
            List imgs = CorrelateGpxWithImages.this.getSortedImgList();
            try {
                Pair<GpxTimezone, GpxTimeOffset> r = CorrelateGpxWithImages.autoGuess(imgs, gpx);
                CorrelateGpxWithImages.this.timezone = (GpxTimezone)r.a;
                CorrelateGpxWithImages.this.delta = (GpxTimeOffset)r.b;
            }
            catch (IndexOutOfBoundsException ex) {
                Logging.debug(ex);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("The selected photos do not contain time information.", new Object[0]), I18n.tr("Photos do not contain time information", new Object[0]), 2);
                return;
            }
            catch (NoGpxTimestamps ex) {
                Logging.debug(ex);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("The selected GPX track does not contain timestamps. Please select another one.", new Object[0]), I18n.tr("GPX Track has no time information", new Object[0]), 2);
                return;
            }
            CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.timezone.formatTimezone());
            CorrelateGpxWithImages.this.tfOffset.setText(CorrelateGpxWithImages.this.delta.formatOffset());
            CorrelateGpxWithImages.this.tfOffset.requestFocus();
            CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    static class NoGpxTimestamps
    extends Exception {
        NoGpxTimestamps() {
        }
    }

    private class AdjustActionListener
    implements ActionListener {
        private AdjustActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GpxTimeOffset offset = GpxTimeOffset.milliseconds(CorrelateGpxWithImages.this.delta.getMilliseconds() + Math.round(CorrelateGpxWithImages.this.timezone.getHours() * (double)TimeUnit.HOURS.toMillis(1L)));
            final int dayOffset = offset.getDayOffset();
            Pair<GpxTimezone, GpxTimeOffset> timezoneOffsetPair = offset.withoutDayOffset().splitOutTimezone();
            final JLabel lblMatches = new JLabel();
            final JLabel lblTimezone = new JLabel();
            final JSlider sldTimezone = new JSlider(-24, 24, 0);
            sldTimezone.setPaintLabels(true);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            for (int i = -12; i <= 12; i += 6) {
                ((Dictionary)labelTable).put(i * 2, new JLabel(new GpxTimezone(i).formatTimezone()));
            }
            sldTimezone.setLabelTable(labelTable);
            final JLabel lblMinutes = new JLabel();
            final JSlider sldMinutes = new JSlider(-15, 15, 0);
            sldMinutes.setPaintLabels(true);
            sldMinutes.setMajorTickSpacing(5);
            final JLabel lblSeconds = new JLabel();
            final JSlider sldSeconds = new JSlider(-600, 600, 0);
            sldSeconds.setPaintLabels(true);
            labelTable = new Hashtable();
            for (int i = -60; i <= 60; i += 30) {
                ((Dictionary)labelTable).put(i * 10, new JLabel(GpxTimeOffset.seconds(i).formatOffset()));
            }
            sldSeconds.setLabelTable(labelTable);
            sldSeconds.setMajorTickSpacing(300);
            JPanel p = new JPanel(new GridBagLayout());
            p.setPreferredSize(new Dimension(400, 230));
            p.add((Component)lblMatches, GBC.eol().fill());
            p.add((Component)lblTimezone, GBC.eol().fill());
            p.add((Component)sldTimezone, GBC.eol().fill().insets(0, 0, 0, 10));
            p.add((Component)lblMinutes, GBC.eol().fill());
            p.add((Component)sldMinutes, GBC.eol().fill().insets(0, 0, 0, 10));
            p.add((Component)lblSeconds, GBC.eol().fill());
            p.add((Component)sldSeconds, GBC.eol().fill());
            try {
                sldTimezone.setValue((int)(((GpxTimezone)timezoneOffsetPair.a).getHours() * 2.0));
                sldMinutes.setValue((int)(((GpxTimeOffset)timezoneOffsetPair.b).getSeconds() / 60L));
                long deciSeconds = ((GpxTimeOffset)timezoneOffsetPair.b).getMilliseconds() / 100L;
                sldSeconds.setValue((int)(deciSeconds % 600L));
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                Logging.warn(e);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("An error occurred while trying to match the photos to the GPX track. You can adjust the sliders to manually match the photos.", new Object[0]), I18n.tr("Matching photos to track failed", new Object[0]), 2);
            }
            class SliderListener
            implements ChangeListener {
                SliderListener() {
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    CorrelateGpxWithImages.this.timezone = new GpxTimezone((double)sldTimezone.getValue() / 2.0);
                    lblTimezone.setText(I18n.tr("Timezone: {0}", CorrelateGpxWithImages.this.timezone.formatTimezone()));
                    lblMinutes.setText(I18n.tr("Minutes: {0}", sldMinutes.getValue()));
                    lblSeconds.setText(I18n.tr("Seconds: {0}", GpxTimeOffset.milliseconds(100L * (long)sldSeconds.getValue()).formatOffset()));
                    CorrelateGpxWithImages.this.delta = GpxTimeOffset.milliseconds(100L * (long)sldSeconds.getValue() + TimeUnit.MINUTES.toMillis(sldMinutes.getValue()) + TimeUnit.DAYS.toMillis(dayOffset));
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.timezone.formatTimezone());
                    CorrelateGpxWithImages.this.tfOffset.setText(CorrelateGpxWithImages.this.delta.formatOffset());
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    lblMatches.setText(CorrelateGpxWithImages.this.statusBarText.getText() + "<br>" + I18n.trn("(Time difference of {0} day)", "Time difference of {0} days", Math.abs(dayOffset), Math.abs(dayOffset)));
                    CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                }
            }
            new SliderListener().stateChanged(null);
            sldTimezone.addChangeListener(new SliderListener());
            sldMinutes.addChangeListener(new SliderListener());
            sldSeconds.addChangeListener(new SliderListener());
            new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Adjust timezone and offset", new Object[0]), I18n.tr("Close", new Object[0])).setContent(p).setButtonIcons("ok").showDialog();
        }
    }

    private class RepaintTheMapListener
    implements FocusListener {
        private RepaintTheMapListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class StatusBarUpdater
    implements DocumentListener,
    ItemListener,
    ActionListener {
        private final boolean doRepaint;

        StatusBarUpdater(boolean doRepaint) {
            this.doRepaint = doRepaint;
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            this.updateStatusBar();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            this.updateStatusBar();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateStatusBar();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateStatusBar();
        }

        public void updateStatusBar() {
            CorrelateGpxWithImages.this.statusBarText.setText(this.statusText());
            if (this.doRepaint) {
                CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
            }
        }

        private String statusText() {
            try {
                CorrelateGpxWithImages.this.timezone = GpxTimezone.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
                CorrelateGpxWithImages.this.delta = GpxTimeOffset.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException e) {
                return e.getMessage();
            }
            for (ImageEntry imageEntry : CorrelateGpxWithImages.this.yLayer.getImageData().getImages()) {
                imageEntry.discardTmp();
            }
            List dateImgLst = CorrelateGpxWithImages.this.getSortedImgList();
            for (ImageEntry ie : dateImgLst) {
                ie.createTmp();
                ie.getTmp().setPos(null);
            }
            GpxDataWrapper gpxDataWrapper = CorrelateGpxWithImages.this.selectedGPX(false);
            if (gpxDataWrapper == null) {
                return I18n.tr("No gpx selected", new Object[0]);
            }
            long offsetMs = (long)(CorrelateGpxWithImages.this.timezone.getHours() * (double)TimeUnit.HOURS.toMillis(1L)) + CorrelateGpxWithImages.this.delta.getMilliseconds();
            CorrelateGpxWithImages.this.lastNumMatched = GpxImageCorrelation.matchGpxTrack(dateImgLst, gpxDataWrapper.data, offsetMs, forceTags);
            return I18n.trn("<html>Matched <b>{0}</b> of <b>{1}</b> photo to GPX track.</html>", "<html>Matched <b>{0}</b> of <b>{1}</b> photos to GPX track.</html>", dateImgLst.size(), CorrelateGpxWithImages.this.lastNumMatched, dateImgLst.size());
        }
    }

    private class GpxLayerAddedListener
    implements LayerManager.LayerChangeListener {
        private GpxLayerAddedListener() {
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            Layer layer;
            if (CorrelateGpxWithImages.this.syncDialog != null && CorrelateGpxWithImages.this.syncDialog.isVisible() && (layer = e.getAddedLayer()) instanceof GpxLayer) {
                GpxLayer gpx = (GpxLayer)layer;
                GpxDataWrapper gdw = new GpxDataWrapper(gpx.getName(), gpx.data, gpx.data.storageFile);
                CorrelateGpxWithImages.this.gpxLst.add(gdw);
                MutableComboBoxModel model = (MutableComboBoxModel)CorrelateGpxWithImages.this.cbGpx.getModel();
                if (((GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(0)).file == null) {
                    CorrelateGpxWithImages.this.gpxLst.remove(0);
                    model.removeElementAt(0);
                }
                model.addElement(gdw);
            }
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        }
    }

    private class SetOffsetActionListener
    implements ActionListener {
        JCheckBox ckDst;
        ImageDisplay imgDisp;
        JLabel lbExifTime;
        JosmTextField tfGpsTime;

        private SetOffsetActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDateFormat dateFormat = (SimpleDateFormat)DateUtils.getDateTimeFormat(3, 2);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel(I18n.tr("<html>Take a photo of your GPS receiver while it displays the time.<br>Display that photo here.<br>And then, simply capture the time you read on the photo and select a timezone<hr></html>", new Object[0])), "North");
            this.imgDisp = new ImageDisplay();
            this.imgDisp.setPreferredSize(new Dimension(300, 225));
            panel.add((Component)this.imgDisp, "Center");
            JPanel panelTf = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("Photo time (from exif):", new Object[0])), gc);
            this.lbExifTime = new JLabel();
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.gridwidth = 2;
            panelTf.add((Component)this.lbExifTime, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("Gps time (read from the above photo): ", new Object[0])), gc);
            this.tfGpsTime = new JosmTextField(12);
            this.tfGpsTime.setEnabled(false);
            this.tfGpsTime.setMinimumSize(new Dimension(155, this.tfGpsTime.getMinimumSize().height));
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            panelTf.add((Component)this.tfGpsTime, gc);
            gc.gridx = 2;
            gc.weightx = 0.2;
            panelTf.add((Component)new JLabel(" [" + dateFormat.toLocalizedPattern() + ']'), gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("Photo taken in the timezone of: ", new Object[0])), gc);
            this.ckDst = new JCheckBox(I18n.tr("Use daylight saving time (where applicable)", new Object[0]), Config.getPref().getBoolean("geoimage.timezoneid.dst"));
            String[] tmp = TimeZone.getAvailableIDs();
            ArrayList<TimeZoneItem> vtTimezones = new ArrayList<TimeZoneItem>(tmp.length);
            String defTzStr = Config.getPref().get("geoimage.timezoneid", "");
            if (defTzStr.isEmpty()) {
                defTzStr = TimeZone.getDefault().getID();
            }
            TimeZoneItem defTzItem = null;
            for (String tzStr : tmp) {
                TimeZoneItem tz = new TimeZoneItem(TimeZone.getTimeZone(tzStr));
                vtTimezones.add(tz);
                if (!defTzStr.equals(tzStr)) continue;
                defTzItem = tz;
            }
            Collections.sort(vtTimezones);
            JosmComboBox<TimeZoneItem> cbTimezones = new JosmComboBox<TimeZoneItem>(vtTimezones.toArray(new TimeZoneItem[0]));
            if (defTzItem != null) {
                cbTimezones.setSelectedItem(defTzItem);
            }
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            gc.fill = 2;
            panelTf.add(cbTimezones, gc);
            gc.gridy = 3;
            panelTf.add((Component)this.ckDst, gc);
            this.ckDst.addActionListener(x -> cbTimezones.repaint());
            panel.add((Component)panelTf, "South");
            JPanel panelLst = new JPanel(new BorderLayout());
            JList<String> imgList = new JList<String>(new AbstractListModel<String>(){

                @Override
                public String getElementAt(int i) {
                    return CorrelateGpxWithImages.this.yLayer.getImageData().getImages().get(i).getFile().getName();
                }

                @Override
                public int getSize() {
                    return CorrelateGpxWithImages.this.yLayer.getImageData().getImages().size();
                }
            });
            imgList.getSelectionModel().setSelectionMode(0);
            imgList.getSelectionModel().addListSelectionListener(evt -> {
                int index = imgList.getSelectedIndex();
                ImageEntry img = CorrelateGpxWithImages.this.yLayer.getImageData().getImages().get(index);
                this.updateExifComponents(img);
            });
            panelLst.add((Component)new JScrollPane(imgList), "Center");
            JButton openButton = new JButton(I18n.tr("Open another photo", new Object[0]));
            openButton.addActionListener(ae -> {
                AbstractFileChooser fc = DiskAccessAction.createAndOpenFileChooser(true, false, null, JpgImporter.FILE_FILTER_WITH_FOLDERS, 0, "geoimage.lastdirectory");
                if (fc == null) {
                    return;
                }
                ImageEntry entry = new ImageEntry(fc.getSelectedFile());
                entry.extractExif();
                this.updateExifComponents(entry);
            });
            panelLst.add((Component)openButton, "Last");
            panel.add((Component)panelLst, "Before");
            boolean isOk = false;
            while (!isOk) {
                long delta;
                int answer = JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), panel, I18n.tr("Synchronize time from a photo of the GPS receiver", new Object[0]), 2, 3);
                if (answer == 2) {
                    return;
                }
                try {
                    delta = dateFormat.parse(this.lbExifTime.getText()).getTime() - dateFormat.parse(this.tfGpsTime.getText()).getTime();
                }
                catch (ParseException ex) {
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Error while parsing the date.\nPlease use the requested format", new Object[0]), I18n.tr("Invalid date", new Object[0]), 0);
                    continue;
                }
                TimeZoneItem selectedTz = (TimeZoneItem)cbTimezones.getSelectedItem();
                Config.getPref().put("geoimage.timezoneid", selectedTz.getID());
                Config.getPref().putBoolean("geoimage.timezoneid.dst", this.ckDst.isSelected());
                CorrelateGpxWithImages.this.tfOffset.setText(GpxTimeOffset.milliseconds(delta).formatOffset());
                CorrelateGpxWithImages.this.tfTimezone.setText(selectedTz.getFormattedString());
                isOk = true;
            }
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }

        void updateExifComponents(ImageEntry img) {
            this.imgDisp.setImage(img);
            Date date = img.getExifTime();
            if (date != null) {
                DateFormat df = DateUtils.getDateTimeFormat(3, 2);
                df.setTimeZone(DateUtils.UTC);
                this.lbExifTime.setText(df.format(date));
                this.tfGpsTime.setText(df.format(date));
                this.tfGpsTime.setCaretPosition(this.tfGpsTime.getText().length());
                this.tfGpsTime.setEnabled(true);
                this.tfGpsTime.requestFocus();
            } else {
                this.lbExifTime.setText(I18n.tr("No date", new Object[0]));
                this.tfGpsTime.setText("");
                this.tfGpsTime.setEnabled(false);
            }
        }

        class TimeZoneItem
        implements Comparable<TimeZoneItem> {
            private final TimeZone tz;
            private String rawString;
            private String dstString;

            TimeZoneItem(TimeZone tz) {
                this.tz = tz;
            }

            public String getFormattedString() {
                if (SetOffsetActionListener.this.ckDst.isSelected()) {
                    return this.getDstString();
                }
                return this.getRawString();
            }

            public String getDstString() {
                if (this.dstString == null) {
                    this.dstString = this.formatTimezone(this.tz.getRawOffset() + this.tz.getDSTSavings());
                }
                return this.dstString;
            }

            public String getRawString() {
                if (this.rawString == null) {
                    this.rawString = this.formatTimezone(this.tz.getRawOffset());
                }
                return this.rawString;
            }

            public String getID() {
                return this.tz.getID();
            }

            public String toString() {
                return this.getID() + " (" + this.getFormattedString() + ')';
            }

            @Override
            public int compareTo(TimeZoneItem o) {
                return this.getID().compareTo(o.getID());
            }

            private String formatTimezone(int offset) {
                return new GpxTimezone((double)offset / (double)TimeUnit.HOURS.toMillis(1L)).formatTimezone();
            }
        }
    }

    private class AdvancedSettingsActionListener
    implements ActionListener {
        private AdvancedSettingsActionListener() {
        }

        private void addCheckBoxActionListener(JCheckBox cb, JComponent ... c) {
            CheckBoxActionListener listener = new CheckBoxActionListener(c);
            cb.addActionListener(listener);
            listener.setEnabled(cb);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IPreferences s = Config.getPref();
            JPanel p = new JPanel(new GridBagLayout());
            Border border1 = BorderFactory.createEmptyBorder(0, 20, 0, 0);
            Border border2 = BorderFactory.createEmptyBorder(10, 0, 5, 0);
            Border border = BorderFactory.createEmptyBorder(0, 40, 0, 0);
            FlowLayout layout = new FlowLayout();
            JLabel l = new JLabel(I18n.tr("Segment settings", new Object[0]));
            l.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            p.add((Component)l, GBC.eol());
            JCheckBox cInterpolSeg = new JCheckBox(I18n.tr("Interpolate between segments", new Object[0]), s.getBoolean("geoimage.seg.int", true));
            cInterpolSeg.setBorder(border1);
            p.add((Component)cInterpolSeg, GBC.eol());
            JCheckBox cInterpolSegTime = new JCheckBox(I18n.tr("only when the segments are less than # minutes apart:", new Object[0]), s.getBoolean("geoimage.seg.int.time", true));
            JSpinner sInterpolSegTime = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.seg.int.time.val", 60), 0, Integer.MAX_VALUE, 1));
            ((JSpinner.DefaultEditor)sInterpolSegTime.getEditor()).getTextField().setColumns(3);
            JPanel pInterpolSegTime = new JPanel(layout);
            pInterpolSegTime.add(cInterpolSegTime);
            pInterpolSegTime.add(sInterpolSegTime);
            pInterpolSegTime.setBorder(border);
            p.add((Component)pInterpolSegTime, GBC.eol());
            JCheckBox cInterpolSegDist = new JCheckBox(I18n.tr("only when the segments are less than # meters apart:", new Object[0]), s.getBoolean("geoimage.seg.int.dist", true));
            JSpinner sInterpolSegDist = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.seg.int.dist.val", 50), 0, Integer.MAX_VALUE, 1));
            ((JSpinner.DefaultEditor)sInterpolSegDist.getEditor()).getTextField().setColumns(3);
            JPanel pInterpolSegDist = new JPanel(layout);
            pInterpolSegDist.add(cInterpolSegDist);
            pInterpolSegDist.add(sInterpolSegDist);
            pInterpolSegDist.setBorder(border);
            p.add((Component)pInterpolSegDist, GBC.eol());
            JCheckBox cTagSeg = new JCheckBox(I18n.tr("Tag images at the closest end of a segment, when not interpolated", new Object[0]), s.getBoolean("geoimage.seg.tag", true));
            cTagSeg.setBorder(border1);
            p.add((Component)cTagSeg, GBC.eol());
            JCheckBox cTagSegTime = new JCheckBox(I18n.tr("only within # minutes of the closest trackpoint:", new Object[0]), s.getBoolean("geoimage.seg.tag.time", true));
            JSpinner sTagSegTime = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.seg.tag.time.val", 2), 0, Integer.MAX_VALUE, 1));
            ((JSpinner.DefaultEditor)sTagSegTime.getEditor()).getTextField().setColumns(3);
            JPanel pTagSegTime = new JPanel(layout);
            pTagSegTime.add(cTagSegTime);
            pTagSegTime.add(sTagSegTime);
            pTagSegTime.setBorder(border);
            p.add((Component)pTagSegTime, GBC.eol());
            l = new JLabel(I18n.tr("Track settings (note that multiple tracks can be in one GPX file)", new Object[0]));
            l.setBorder(border2);
            p.add((Component)l, GBC.eol());
            JCheckBox cInterpolTrack = new JCheckBox(I18n.tr("Interpolate between tracks", new Object[0]), s.getBoolean("geoimage.trk.int", false));
            cInterpolTrack.setBorder(border1);
            p.add((Component)cInterpolTrack, GBC.eol());
            JCheckBox cInterpolTrackTime = new JCheckBox(I18n.tr("only when the tracks are less than # minutes apart:", new Object[0]), s.getBoolean("geoimage.trk.int.time", false));
            JSpinner sInterpolTrackTime = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.trk.int.time.val", 60), 0, Integer.MAX_VALUE, 1));
            ((JSpinner.DefaultEditor)sInterpolTrackTime.getEditor()).getTextField().setColumns(3);
            JPanel pInterpolTrackTime = new JPanel(layout);
            pInterpolTrackTime.add(cInterpolTrackTime);
            pInterpolTrackTime.add(sInterpolTrackTime);
            pInterpolTrackTime.setBorder(border);
            p.add((Component)pInterpolTrackTime, GBC.eol());
            JCheckBox cInterpolTrackDist = new JCheckBox(I18n.tr("only when the tracks are less than # meters apart:", new Object[0]), s.getBoolean("geoimage.trk.int.dist", false));
            JSpinner sInterpolTrackDist = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.trk.int.dist.val", 50), 0, Integer.MAX_VALUE, 1));
            ((JSpinner.DefaultEditor)sInterpolTrackDist.getEditor()).getTextField().setColumns(3);
            JPanel pInterpolTrackDist = new JPanel(layout);
            pInterpolTrackDist.add(cInterpolTrackDist);
            pInterpolTrackDist.add(sInterpolTrackDist);
            pInterpolTrackDist.setBorder(border);
            p.add((Component)pInterpolTrackDist, GBC.eol());
            JCheckBox cTagTrack = new JCheckBox("<html>" + I18n.tr("Tag images at the closest end of a track, when not interpolated<br>(also applies before the first and after the last track)", new Object[0]) + "</html>", s.getBoolean("geoimage.trk.tag", true));
            cTagTrack.setBorder(border1);
            p.add((Component)cTagTrack, GBC.eol());
            JCheckBox cTagTrackTime = new JCheckBox(I18n.tr("only within # minutes of the closest trackpoint:", new Object[0]), s.getBoolean("geoimage.trk.tag.time", true));
            JSpinner sTagTrackTime = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.trk.tag.time.val", 2), 0, Integer.MAX_VALUE, 1));
            ((JSpinner.DefaultEditor)sTagTrackTime.getEditor()).getTextField().setColumns(3);
            JPanel pTagTrackTime = new JPanel(layout);
            pTagTrackTime.add(cTagTrackTime);
            pTagTrackTime.add(sTagTrackTime);
            pTagTrackTime.setBorder(border);
            p.add((Component)pTagTrackTime, GBC.eol());
            l = new JLabel(I18n.tr("Advanced", new Object[0]));
            l.setBorder(border2);
            p.add((Component)l, GBC.eol());
            JCheckBox cForce = new JCheckBox("<html>" + I18n.tr("Force tagging of all pictures (temporarily overrides the settings above).", new Object[0]) + "<br>" + I18n.tr("This option will not be saved permanently.", new Object[0]) + "</html>", forceTags);
            cForce.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 0));
            p.add((Component)cForce, GBC.eol());
            this.addCheckBoxActionListener(cInterpolSegTime, sInterpolSegTime);
            this.addCheckBoxActionListener(cInterpolSegDist, sInterpolSegDist);
            this.addCheckBoxActionListener(cInterpolSeg, pInterpolSegTime, pInterpolSegDist);
            this.addCheckBoxActionListener(cTagSegTime, sTagSegTime);
            this.addCheckBoxActionListener(cTagSeg, pTagSegTime);
            this.addCheckBoxActionListener(cInterpolTrackTime, sInterpolTrackTime);
            this.addCheckBoxActionListener(cInterpolTrackDist, sInterpolTrackDist);
            this.addCheckBoxActionListener(cInterpolTrack, pInterpolTrackTime, pInterpolTrackDist);
            this.addCheckBoxActionListener(cTagTrackTime, sTagTrackTime);
            this.addCheckBoxActionListener(cTagTrack, pTagTrackTime);
            ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Advanced settings", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("ok", "cancel").setContent(p);
            if (ed.showDialog().getValue() == 1) {
                s.putBoolean("geoimage.seg.int", cInterpolSeg.isSelected());
                s.putBoolean("geoimage.seg.int.dist", cInterpolSegDist.isSelected());
                s.putInt("geoimage.seg.int.dist.val", (Integer)sInterpolSegDist.getValue());
                s.putBoolean("geoimage.seg.int.time", cInterpolSegTime.isSelected());
                s.putInt("geoimage.seg.int.time.val", (Integer)sInterpolSegTime.getValue());
                s.putBoolean("geoimage.seg.tag", cTagSeg.isSelected());
                s.putBoolean("geoimage.seg.tag.time", cTagSegTime.isSelected());
                s.putInt("geoimage.seg.tag.time.val", (Integer)sTagSegTime.getValue());
                s.putBoolean("geoimage.trk.int", cInterpolTrack.isSelected());
                s.putBoolean("geoimage.trk.int.dist", cInterpolTrackDist.isSelected());
                s.putInt("geoimage.trk.int.dist.val", (Integer)sInterpolTrackDist.getValue());
                s.putBoolean("geoimage.trk.int.time", cInterpolTrackTime.isSelected());
                s.putInt("geoimage.trk.int.time.val", (Integer)sInterpolTrackTime.getValue());
                s.putBoolean("geoimage.trk.tag", cTagTrack.isSelected());
                s.putBoolean("geoimage.trk.tag.time", cTagTrackTime.isSelected());
                s.putInt("geoimage.trk.tag.time.val", (Integer)sTagTrackTime.getValue());
                forceTags = cForce.isSelected();
                CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
                CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
            }
        }

        private class CheckBoxActionListener
        implements ActionListener {
            private final JComponent[] comps;

            CheckBoxActionListener(JComponent ... c) {
                this.comps = Objects.requireNonNull(c);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.setEnabled((JCheckBox)e.getSource());
            }

            public void setEnabled(JCheckBox cb) {
                for (JComponent comp : this.comps) {
                    if (comp instanceof JSpinner) {
                        comp.setEnabled(cb.isSelected());
                        continue;
                    }
                    if (!(comp instanceof JPanel)) continue;
                    boolean en = cb.isSelected();
                    for (Component c : comp.getComponents()) {
                        if (c instanceof JSpinner) {
                            c.setEnabled(en);
                            continue;
                        }
                        c.setEnabled(cb.isSelected());
                        if (!en || !(c instanceof JCheckBox)) continue;
                        en = ((JCheckBox)c).isSelected();
                    }
                }
            }
        }
    }

    private class LoadGpxDataActionListener
    implements ActionListener {
        private LoadGpxDataActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            block26: {
                ExtensionFileFilter gpxFilter = GpxImporter.getFileFilter();
                AbstractFileChooser fc = new FileChooserManager(true, null).createFileChooser(false, null, Arrays.asList(gpxFilter, NMEAImporter.FILE_FILTER), gpxFilter, 0).openFileChooser();
                if (fc == null) {
                    return;
                }
                File sel = fc.getSelectedFile();
                try {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    for (int i = CorrelateGpxWithImages.this.gpxLst.size() - 1; i >= 0; --i) {
                        GpxDataWrapper wrapper = (GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(i);
                        if (!sel.equals(wrapper.file)) continue;
                        CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(i);
                        if (!sel.getName().equals(wrapper.name)) {
                            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("File {0} is loaded yet under the name \"{1}\"", sel.getName(), wrapper.name), I18n.tr("Error", new Object[0]), 0);
                        }
                        return;
                    }
                    GpxData data = null;
                    try (InputStream iStream = Compression.getUncompressedFileInputStream(sel);){
                        IGpxReader reader = gpxFilter.accept(sel) ? new GpxReader(iStream) : new NmeaReader(iStream);
                        reader.parse(false);
                        data = reader.getGpxData();
                        data.storageFile = sel;
                    }
                    catch (SAXException ex) {
                        Logging.error(ex);
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Error while parsing {0}", sel.getName()) + ": " + ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    catch (IOException ex) {
                        Logging.error(ex);
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Could not read \"{0}\"", sel.getName()) + '\n' + ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    MutableComboBoxModel model = (MutableComboBoxModel)CorrelateGpxWithImages.this.cbGpx.getModel();
                    loadedGpxData.add(data);
                    if (((GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(0)).file == null) {
                        CorrelateGpxWithImages.this.gpxLst.remove(0);
                        model.removeElementAt(0);
                    }
                    GpxDataWrapper elem = new GpxDataWrapper(sel.getName(), data, sel);
                    CorrelateGpxWithImages.this.gpxLst.add(elem);
                    model.addElement(elem);
                    CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(CorrelateGpxWithImages.this.cbGpx.getItemCount() - 1);
                    break block26;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private static class GpxDataWrapper {
        private final String name;
        private final GpxData data;
        private final File file;

        GpxDataWrapper(String name, GpxData data, File file) {
            this.name = name;
            this.data = data;
            this.file = file;
        }

        public String toString() {
            return this.name;
        }
    }

    private final class SyncDialogWindowListener
    extends WindowAdapter {
        private static final int CANCEL = -1;
        private static final int DONE = 0;
        private static final int AGAIN = 1;
        private static final int NOTHING = 2;

        private SyncDialogWindowListener() {
        }

        private int checkAndSave() {
            if (CorrelateGpxWithImages.this.syncDialog.isVisible()) {
                return 2;
            }
            int answer = CorrelateGpxWithImages.this.syncDialog.getValue();
            if (answer != 1) {
                return -1;
            }
            try {
                CorrelateGpxWithImages.this.timezone = GpxTimezone.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), e.getMessage(), I18n.tr("Invalid timezone", new Object[0]), 0);
                return 1;
            }
            try {
                CorrelateGpxWithImages.this.delta = GpxTimeOffset.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), e.getMessage(), I18n.tr("Invalid offset", new Object[0]), 0);
                return 1;
            }
            if (CorrelateGpxWithImages.this.lastNumMatched == 0 && new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Correlate images with GPX track", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Try Again", new Object[0])).setContent(I18n.tr("No images could be matched!", new Object[0])).setButtonIcons("ok", "dialogs/refresh").showDialog().getValue() == 2) {
                return 1;
            }
            return 0;
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            int result = this.checkAndSave();
            switch (result) {
                case 2: {
                    break;
                }
                case -1: {
                    if (CorrelateGpxWithImages.this.yLayer == null) break;
                    for (ImageEntry ie : CorrelateGpxWithImages.this.yLayer.getImageData().getImages()) {
                        ie.discardTmp();
                    }
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                    break;
                }
                case 1: {
                    CorrelateGpxWithImages.this.actionPerformed(null);
                    break;
                }
                case 0: {
                    Config.getPref().put("geoimage.timezone", CorrelateGpxWithImages.this.timezone.formatTimezone());
                    Config.getPref().put("geoimage.delta", CorrelateGpxWithImages.this.delta.formatOffset());
                    Config.getPref().putBoolean("geoimage.showThumbs", ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.useThumbs);
                    ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.useThumbs = CorrelateGpxWithImages.this.cbShowThumbs.isSelected();
                    CorrelateGpxWithImages.this.yLayer.startLoadThumbs();
                    boolean boundingBoxedLayerFound = false;
                    for (Layer l : MainApplication.getLayerManager().getLayers()) {
                        if (l == CorrelateGpxWithImages.this.yLayer) continue;
                        BoundingXYVisitor bbox = new BoundingXYVisitor();
                        l.visitBoundingBox(bbox);
                        if (bbox.getBounds() == null) continue;
                        boundingBoxedLayerFound = true;
                        break;
                    }
                    if (!boundingBoxedLayerFound) {
                        BoundingXYVisitor bbox = new BoundingXYVisitor();
                        CorrelateGpxWithImages.this.yLayer.visitBoundingBox(bbox);
                        MainApplication.getMap().mapView.zoomTo(bbox);
                    }
                    for (ImageEntry ie : CorrelateGpxWithImages.this.yLayer.getImageData().getImages()) {
                        ie.applyTmp();
                    }
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

