/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.CommunicatorDescriptor;
import com.zeroc.IceGrid.PropertyDescriptor;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ListTextField;
import com.zeroc.IceGridGUI.Application.PropertiesField;
import com.zeroc.IceGridGUI.Application.SimpleMapField;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class CommunicatorSubEditor {
    protected Editor _mainEditor;
    private JTextArea _description = new JTextArea(3, 20);
    private ListTextField _propertySets = new ListTextField(20);
    private PropertiesField _properties;
    private SimpleMapField _logFiles;

    CommunicatorSubEditor(Editor mainEditor) {
        this._mainEditor = mainEditor;
        this._description.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._description.setToolTipText("An optional description");
        this._propertySets.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._propertySets.setToolTipText("Property Set References");
        this._properties = new PropertiesField(mainEditor);
        this._logFiles = new SimpleMapField(mainEditor, true, "Path", "Property");
        this._logFiles.setToolTipText("Log files used by this server or service");
    }

    void appendProperties(DefaultFormBuilder builder) {
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Property Sets");
        builder.append((Component)this._propertySets, 3);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._properties);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Log files");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-4);
        scrollPane = new JScrollPane(this._logFiles);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 5));
        builder.nextRow(4);
        builder.nextLine();
    }

    void writeDescriptor(CommunicatorDescriptor descriptor) {
        descriptor.propertySet.references = this._propertySets.getList().toArray(new String[0]);
        descriptor.propertySet.properties = this._properties.getProperties();
        descriptor.description = this._description.getText();
        TreeMap<String, String> tm = this._logFiles.get();
        descriptor.logs = new String[tm.size()];
        int i = 0;
        for (Map.Entry<String, String> p : tm.entrySet()) {
            String path = p.getKey();
            String prop = p.getValue().trim();
            descriptor.logs[i++] = path;
            if (prop.equals("")) continue;
            this.setProperty((LinkedList)descriptor.propertySet.properties, prop, path);
        }
    }

    void show(CommunicatorDescriptor descriptor, boolean isEditable) {
        Utils.Resolver detailResolver = this._mainEditor.getDetailResolver();
        isEditable = isEditable && detailResolver == null;
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String log : descriptor.logs) {
            String prop = this.lookupKey(descriptor.propertySet.properties, log);
            map.put(log, prop);
        }
        this._logFiles.set(map, detailResolver, isEditable);
        this._propertySets.setList(Arrays.asList(descriptor.propertySet.references), detailResolver);
        this._propertySets.setEditable(isEditable);
        this._properties.setProperties(descriptor.propertySet.properties, descriptor.adapters, descriptor.logs, detailResolver, isEditable);
        this._description.setText(Utils.substitute(descriptor.description, detailResolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
    }

    private String lookupKey(List<PropertyDescriptor> props, String value) {
        for (PropertyDescriptor p : props) {
            if (!p.value.equals(value)) continue;
            return p.name;
        }
        return "";
    }

    private void setProperty(LinkedList<PropertyDescriptor> props, String key, String newValue) {
        this.removeProperty(props, key);
        props.addFirst(new PropertyDescriptor(key, newValue));
    }

    private void removeProperty(List<PropertyDescriptor> props, String key) {
        Iterator<PropertyDescriptor> p = props.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = p.next();
            if (!pd.name.equals(key)) continue;
            p.remove();
        }
    }
}

