/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.twirl.TwirlImports;
import org.gradle.language.twirl.TwirlTemplateFormat;
import org.gradle.language.twirl.internal.DefaultTwirlTemplateFormat;
import org.gradle.play.internal.CleaningPlayToolCompiler;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.internal.twirl.DefaultTwirlCompileSpec;
import org.gradle.play.internal.twirl.TwirlCompileSpec;
import org.gradle.play.internal.twirl.TwirlCompilerFactory;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.play.toolchain.PlayToolChain;

@Incubating
public class TwirlCompile
extends SourceTask {
    private File outputDirectory;
    private TwirlImports defaultImports;
    private BaseForkOptions forkOptions;
    private TwirlStaleOutputCleaner cleaner;
    private PlayPlatform platform;
    private List<TwirlTemplateFormat> userTemplateFormats = Lists.newArrayList();
    private List<String> additionalImports = Lists.newArrayList();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    public BaseForkOptions getForkOptions() {
        if (this.forkOptions == null) {
            this.forkOptions = new BaseForkOptions();
        }
        return this.forkOptions;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public Object getDependencyNotation() {
        return TwirlCompilerFactory.createAdapter(this.platform).getDependencyNotation();
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Nullable
    @Optional
    @Input
    public TwirlImports getDefaultImports() {
        return this.defaultImports;
    }

    public void setDefaultImports(@Nullable TwirlImports defaultImports) {
        this.defaultImports = defaultImports;
    }

    @TaskAction
    void compile(IncrementalTaskInputs inputs) {
        RelativeFileCollector relativeFileCollector = new RelativeFileCollector();
        this.getSource().visit((FileVisitor)relativeFileCollector);
        DefaultTwirlCompileSpec spec = new DefaultTwirlCompileSpec(relativeFileCollector.relativeFiles, this.getOutputDirectory(), this.getForkOptions(), this.getDefaultImports(), this.userTemplateFormats, this.additionalImports);
        if (!inputs.isIncremental()) {
            new CleaningPlayToolCompiler<TwirlCompileSpec>(this.getCompiler(), this.getOutputs()).execute(spec);
        } else {
            final HashSet sourcesToCompile = new HashSet();
            inputs.outOfDate((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails inputFileDetails) {
                    sourcesToCompile.add(inputFileDetails.getFile());
                }
            });
            final HashSet<File> staleOutputFiles = new HashSet<File>();
            inputs.removed((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails inputFileDetails) {
                    staleOutputFiles.add(inputFileDetails.getFile());
                }
            });
            if (this.cleaner == null) {
                this.cleaner = new TwirlStaleOutputCleaner(this.getOutputDirectory());
            }
            this.cleaner.execute(staleOutputFiles);
            this.getCompiler().execute((CompileSpec)spec);
        }
    }

    private Compiler<TwirlCompileSpec> getCompiler() {
        PlayToolProvider toolProvider = ((PlayToolChainInternal)this.getToolChain()).select(this.platform);
        return toolProvider.newCompiler(TwirlCompileSpec.class);
    }

    void setCleaner(TwirlStaleOutputCleaner cleaner) {
        this.cleaner = cleaner;
    }

    public void setPlatform(PlayPlatform platform) {
        this.platform = platform;
    }

    @Inject
    public PlayToolChain getToolChain() {
        throw new UnsupportedOperationException();
    }

    public void setToolChain(PlayToolChain toolChain) {
        throw new UnsupportedOperationException();
    }

    @Input
    public List<TwirlTemplateFormat> getUserTemplateFormats() {
        return this.userTemplateFormats;
    }

    public void setUserTemplateFormats(List<TwirlTemplateFormat> userTemplateFormats) {
        this.userTemplateFormats = userTemplateFormats;
    }

    public void addUserTemplateFormat(String extension, String templateType, String ... imports) {
        this.userTemplateFormats.add(new DefaultTwirlTemplateFormat(extension, templateType, Arrays.asList(imports)));
    }

    @Input
    public List<String> getAdditionalImports() {
        return this.additionalImports;
    }

    public void setAdditionalImports(List<String> additionalImports) {
        this.additionalImports = additionalImports;
    }

    private static class RelativeFileCollector
    implements FileVisitor {
        List<RelativeFile> relativeFiles = Lists.newArrayList();

        private RelativeFileCollector() {
        }

        public void visitDir(FileVisitDetails dirDetails) {
        }

        public void visitFile(FileVisitDetails fileDetails) {
            this.relativeFiles.add(new RelativeFile(fileDetails.getFile(), fileDetails.getRelativePath()));
        }
    }

    private static class TwirlStaleOutputCleaner {
        private final File destinationDir;

        public TwirlStaleOutputCleaner(File destinationDir) {
            this.destinationDir = destinationDir;
        }

        public void execute(Set<File> staleSources) {
            for (File removedInputFile : staleSources) {
                File staleOuputFile = this.calculateOutputFile(removedInputFile);
                staleOuputFile.delete();
            }
        }

        File calculateOutputFile(File inputFile) {
            String inputFileName = inputFile.getName();
            String[] splits = inputFileName.split("\\.");
            String relativeOutputFilePath = "views/" + splits[2] + "/" + splits[0] + ".template.scala";
            return new File(this.destinationDir, relativeOutputFilePath);
        }
    }
}

