/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XStatusListener;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import org.openoffice.da.comp.w2lcommon.filter.UNOPublisher;
import org.openoffice.da.comp.w2lcommon.helper.MessageBox;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;
import org.openoffice.da.comp.writer2latex.LaTeXUNOPublisher;
import org.openoffice.da.comp.writer2latex.Messages;

public final class Writer2LaTeX
extends WeakBase
implements XServiceInfo,
XDispatchProvider,
XInitialization,
XDispatch {
    private static final String PROTOCOL = "org.openoffice.da.writer2latex:";
    private final XComponentContext m_xContext;
    private XFrame m_xFrame;
    private LaTeXUNOPublisher unoPublisher = null;
    public static final String __implementationName = Writer2LaTeX.class.getName();
    public static final String __serviceName = "com.sun.star.frame.ProtocolHandler";
    private static final String[] m_serviceNames = new String[]{"com.sun.star.frame.ProtocolHandler"};

    public Writer2LaTeX(XComponentContext xContext) {
        this.m_xContext = xContext;
    }

    public void initialize(Object[] object) throws Exception {
        if (object.length > 0) {
            this.m_xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)object[0]);
        }
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public XDispatch queryDispatch(URL aURL, String sTargetFrameName, int iSearchFlags) {
        if (aURL.Protocol.compareTo(PROTOCOL) == 0) {
            if (aURL.Path.compareTo("ProcessDocument") == 0) {
                return this;
            }
            if (aURL.Path.compareTo("ViewLog") == 0) {
                return this;
            }
            if (aURL.Path.compareTo("InsertBibTeX") == 0) {
                return this;
            }
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] seqDescriptors) {
        int nCount = seqDescriptors.length;
        XDispatch[] seqDispatcher = new XDispatch[seqDescriptors.length];
        for (int i = 0; i < nCount; ++i) {
            seqDispatcher[i] = this.queryDispatch(seqDescriptors[i].FeatureURL, seqDescriptors[i].FrameName, seqDescriptors[i].SearchFlags);
        }
        return seqDispatcher;
    }

    public void dispatch(URL aURL, PropertyValue[] aArguments) {
        if (aURL.Protocol.compareTo(PROTOCOL) == 0) {
            if (aURL.Path.compareTo("ProcessDocument") == 0) {
                this.process();
                return;
            }
            if (aURL.Path.compareTo("ViewLog") == 0) {
                this.viewLog();
                return;
            }
            if (aURL.Path.compareTo("InsertBibTeX") == 0) {
                this.insertBibTeX();
                return;
            }
        }
    }

    public void addStatusListener(XStatusListener xControl, URL aURL) {
    }

    public void removeStatusListener(XStatusListener xControl, URL aURL) {
    }

    private void process() {
        this.createUNOPublisher();
        this.unoPublisher.publish(UNOPublisher.TargetFormat.latex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void viewLog() {
        this.createUNOPublisher();
        if (!this.unoPublisher.documentSaved()) return;
        try {
            Object[] args = new Object[]{this.unoPublisher.getTargetPath() + this.unoPublisher.getTargetFileName()};
            Object dialog = this.m_xContext.getServiceManager().createInstanceWithArgumentsAndContext("org.openoffice.da.writer2latex.LogViewerDialog", args, this.m_xContext);
            XExecutableDialog xDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)dialog);
            if (xDialog.execute() != 1) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertBibTeX() {
        if (this.useExternalBibTeXFiles()) {
            this.createUNOPublisher();
            if (!this.unoPublisher.documentSaved()) return;
            try {
                Object[] args = new Object[]{this.m_xFrame, this.unoPublisher.getBibTeXDirectory().getPath()};
                Object dialog = this.m_xContext.getServiceManager().createInstanceWithArgumentsAndContext("org.openoffice.da.writer2latex.BibTeXDialog", args, this.m_xContext);
                XExecutableDialog xDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)dialog);
                if (xDialog.execute() != 1) return;
            }
            catch (Exception args) {}
            return;
        } else {
            MessageBox msgBox = new MessageBox(this.m_xContext, this.m_xFrame);
            msgBox.showMessage("Writer2LaTeX", Messages.getString("Writer2LaTeX.bibtexnotenabled"));
            {
                // empty if block
            }
        }
    }

    private boolean useExternalBibTeXFiles() {
        Object view;
        RegistryHelper registry = new RegistryHelper(this.m_xContext);
        try {
            view = registry.getRegistryView("/org.openoffice.da.Writer2LaTeX.toolbar.ToolbarOptions/BibliographyOptions", false);
        }
        catch (Exception e) {
            return false;
        }
        XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
        return XPropertySetHelper.getPropertyValueAsBoolean(xProps, "UseExternalBibTeXFiles");
    }

    private void createUNOPublisher() {
        if (this.unoPublisher == null) {
            this.unoPublisher = new LaTeXUNOPublisher(this.m_xContext, this.m_xFrame, "Writer2LaTeX");
        }
    }
}

