/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class RoundRect
extends EMFTag {
    private Rectangle bounds;
    private Dimension corner;

    public RoundRect() {
        super(44, 1);
    }

    public RoundRect(Rectangle bounds, Dimension corner) {
        this();
        this.bounds = bounds;
        this.corner = corner;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new RoundRect(emf.readRECTL(), emf.readSIZEL());
    }

    @Override
    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeSIZEL(this.corner);
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  corner: " + this.corner;
    }

    @Override
    public void render(EMFRenderer renderer) {
        renderer.fillAndDrawOrAppend(new RoundRectangle2D.Double(this.bounds.getX(), this.bounds.getX(), this.bounds.getWidth(), this.bounds.getHeight(), this.corner.getWidth(), this.corner.getHeight()));
    }
}

