//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.2
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Metrics_h__
#define __Ice_Metrics_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 2
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceMX
{

class Metrics;
class MetricsAdmin;
class MetricsAdminPrx;
class ThreadMetrics;
class DispatchMetrics;
class ChildInvocationMetrics;
class CollocatedMetrics;
class RemoteMetrics;
class InvocationMetrics;
class ConnectionMetrics;

}

namespace IceMX
{

/**
 * A dictionnary of strings to integers.
 */
using StringIntDict = ::std::map<::std::string, int>;

/**
 * A structure to keep track of failures associated with a given
 * metrics.
 * \headerfile Ice/Ice.h
 */
struct MetricsFailures
{
    /**
     * The identifier of the metrics object associated to the
     * failures.
     */
    ::std::string id;
    /**
     * The failures observed for this metrics.
     */
    StringIntDict failures;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const StringIntDict&> ice_tuple() const
    {
        return std::tie(id, failures);
    }
};

/**
 * A sequence of {@link MetricsFailures}.
 */
using MetricsFailuresSeq = ::std::vector<MetricsFailures>;

/**
 * A metrics map is a sequence of metrics. We use a sequence here
 * instead of a map because the ID of the metrics is already included
 * in the Metrics class and using sequences of metrics objects is more
 * efficient than using dictionaries since lookup is not necessary.
 */
using MetricsMap = ::std::vector<::std::shared_ptr<Metrics>>;

/**
 * A metrics view is a dictionary of metrics map. The key of the
 * dictionary is the name of the metrics map.
 */
using MetricsView = ::std::map<::std::string, MetricsMap>;

/**
 * Raised if a metrics view cannot be found.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) UnknownMetricsView : public ::Ice::UserExceptionHelper<UnknownMetricsView, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnknownMetricsView();

    UnknownMetricsView(const UnknownMetricsView&) = default;

    UnknownMetricsView() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static UnknownMetricsView _iceS_UnknownMetricsView_init;
/// \endcond

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceMX
{

/**
 * The metrics administrative facet interface. This interface allows
 * remote administrative clients to access metrics of an application
 * that enabled the Ice administrative facility and configured some
 * metrics views.
 * \headerfile Ice/Ice.h
 */
class ICE_API MetricsAdmin : public virtual ::Ice::Object
{
public:

    using ProxyType = MetricsAdminPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Encapsulates the results of a call to getMetricsViewNames.
     */
    struct GetMetricsViewNamesResult
    {
        /** The name of the enabled views. */
        ::Ice::StringSeq returnValue;
        /** The names of the disabled views. */
        ::Ice::StringSeq disabledViews;
    };

    /**
     * Get the names of enabled and disabled metrics.
     * @param disabledViews The names of the disabled views.
     * @param current The Current object for the invocation.
     * @return The name of the enabled views.
     */
    virtual ::Ice::StringSeq getMetricsViewNames(::Ice::StringSeq& disabledViews, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getMetricsViewNames(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param current The Current object for the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual void enableMetricsView(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_enableMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param current The Current object for the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual void disableMetricsView(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_disableMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Encapsulates the results of a call to getMetricsView.
     */
    struct GetMetricsViewResult
    {
        /** The metrics view data. */
        MetricsView returnValue;
        /** The local time of the process when the metrics object were retrieved. */
        long long int timestamp;
    };

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     * @param current The Current object for the invocation.
     * @return The metrics view data.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual MetricsView getMetricsView(::std::string view, long long int& timestamp, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param current The Current object for the invocation.
     * @return The metrics failures associated with the map.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual MetricsFailuresSeq getMapMetricsFailures(::std::string view, ::std::string map, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getMapMetricsFailures(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param current The Current object for the invocation.
     * @return The metrics failures associated with the metrics.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual MetricsFailures getMetricsFailures(::std::string view, ::std::string map, ::std::string id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getMetricsFailures(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceMX
{

/**
 * The base class for metrics. A metrics object represents a
 * collection of measurements associated to a given a system.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) Metrics : public ::Ice::ValueHelper<Metrics, ::Ice::Value>
{
public:

    ICE_MEMBER(ICE_API) virtual ~Metrics();

    Metrics() = default;

    Metrics(const Metrics&) = default;
    Metrics(Metrics&&) = default;
    Metrics& operator=(const Metrics&) = default;
    Metrics& operator=(Metrics&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     */
    Metrics(const ::std::string& id, long long int total, int current, long long int totalLifetime, int failures) :
        id(::std::move(id)),
        total(total),
        current(current),
        totalLifetime(totalLifetime),
        failures(failures)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    /**
     * The metrics identifier.
     */
    ::std::string id;
    /**
     * The total number of objects that were observed by this metrics.
     */
    long long int total = 0LL;
    /**
     * The current number of objects observed by this metrics.
     */
    int current = 0;
    /**
     * The sum of the lifetime of each observed objects. This does not
     * include the lifetime of objects which are currently observed.
     */
    long long int totalLifetime = 0LL;
    /**
     * The number of failures observed.
     */
    int failures = 0;
};

/// \cond INTERNAL
static Metrics _iceS_Metrics_init;
/// \endcond

/**
 * Provides information on the number of threads currently in use and
 * their activity.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) ThreadMetrics : public ::Ice::ValueHelper<ThreadMetrics, Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ThreadMetrics();

    ThreadMetrics() = default;

    ThreadMetrics(const ThreadMetrics&) = default;
    ThreadMetrics(ThreadMetrics&&) = default;
    ThreadMetrics& operator=(const ThreadMetrics&) = default;
    ThreadMetrics& operator=(ThreadMetrics&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param inUseForIO The number of threads which are currently performing socket read or writes.
     * @param inUseForUser The number of threads which are currently calling user code (servant dispatch, AMI callbacks, etc).
     * @param inUseForOther The number of threads which are currently performing other activities.
     */
    ThreadMetrics(const ::std::string& id, long long int total, int current, long long int totalLifetime, int failures, int inUseForIO, int inUseForUser, int inUseForOther) :
        Ice::ValueHelper<ThreadMetrics, Metrics>(::std::move(id), total, current, totalLifetime, failures),
        inUseForIO(inUseForIO),
        inUseForUser(inUseForUser),
        inUseForOther(inUseForOther)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const int&, const int&, const int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, inUseForIO, inUseForUser, inUseForOther);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    /**
     * The number of threads which are currently performing socket
     * read or writes.
     */
    int inUseForIO = 0;
    /**
     * The number of threads which are currently calling user code
     * (servant dispatch, AMI callbacks, etc).
     */
    int inUseForUser = 0;
    /**
     * The number of threads which are currently performing other
     * activities. These are all other that are not counted with
     * {@link #inUseForUser} or {@link #inUseForIO}, such as DNS
     * lookups, garbage collection).
     */
    int inUseForOther = 0;
};

/**
 * Provides information on servant dispatch.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) DispatchMetrics : public ::Ice::ValueHelper<DispatchMetrics, Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~DispatchMetrics();

    DispatchMetrics() = default;

    DispatchMetrics(const DispatchMetrics&) = default;
    DispatchMetrics(DispatchMetrics&&) = default;
    DispatchMetrics& operator=(const DispatchMetrics&) = default;
    DispatchMetrics& operator=(DispatchMetrics&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param userException The number of dispatch that failed with a user exception.
     * @param size The size of the dispatch.
     * @param replySize The size of the dispatch reply.
     */
    DispatchMetrics(const ::std::string& id, long long int total, int current, long long int totalLifetime, int failures, int userException, long long int size, long long int replySize) :
        Ice::ValueHelper<DispatchMetrics, Metrics>(::std::move(id), total, current, totalLifetime, failures),
        userException(userException),
        size(size),
        replySize(replySize)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, userException, size, replySize);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    /**
     * The number of dispatch that failed with a user exception.
     */
    int userException = 0;
    /**
     * The size of the dispatch. This corresponds to the size of the
     * marshalled input parameters.
     */
    long long int size = 0LL;
    /**
     * The size of the dispatch reply. This corresponds to the size of
     * the marshalled output and return parameters.
     */
    long long int replySize = 0LL;
};

/**
 * Provides information on child invocations. A child invocation is
 * either remote (sent over an Ice connection) or collocated. An
 * invocation can have multiple child invocation if it is
 * retried. Child invocation metrics are embedded within {@link
 * InvocationMetrics}.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) ChildInvocationMetrics : public ::Ice::ValueHelper<ChildInvocationMetrics, Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ChildInvocationMetrics();

    ChildInvocationMetrics() = default;

    ChildInvocationMetrics(const ChildInvocationMetrics&) = default;
    ChildInvocationMetrics(ChildInvocationMetrics&&) = default;
    ChildInvocationMetrics& operator=(const ChildInvocationMetrics&) = default;
    ChildInvocationMetrics& operator=(ChildInvocationMetrics&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param size The size of the invocation.
     * @param replySize The size of the invocation reply.
     */
    ChildInvocationMetrics(const ::std::string& id, long long int total, int current, long long int totalLifetime, int failures, long long int size, long long int replySize) :
        Ice::ValueHelper<ChildInvocationMetrics, Metrics>(::std::move(id), total, current, totalLifetime, failures),
        size(size),
        replySize(replySize)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, size, replySize);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    /**
     * The size of the invocation. This corresponds to the size of the
     * marshalled input parameters.
     */
    long long int size = 0LL;
    /**
     * The size of the invocation reply. This corresponds to the size
     * of the marshalled output and return parameters.
     */
    long long int replySize = 0LL;
};

/**
 * Provides information on invocations that are collocated. Collocated
 * metrics are embedded within {@link InvocationMetrics}.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) CollocatedMetrics : public ::Ice::ValueHelper<CollocatedMetrics, ChildInvocationMetrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CollocatedMetrics();

    CollocatedMetrics() = default;

    CollocatedMetrics(const CollocatedMetrics&) = default;
    CollocatedMetrics(CollocatedMetrics&&) = default;
    CollocatedMetrics& operator=(const CollocatedMetrics&) = default;
    CollocatedMetrics& operator=(CollocatedMetrics&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param size The size of the invocation.
     * @param replySize The size of the invocation reply.
     */
    CollocatedMetrics(const ::std::string& id, long long int total, int current, long long int totalLifetime, int failures, long long int size, long long int replySize) :
        Ice::ValueHelper<CollocatedMetrics, ChildInvocationMetrics>(::std::move(id), total, current, totalLifetime, failures, size, replySize)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, size, replySize);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

/**
 * Provides information on invocations that are specifically sent over
 * Ice connections. Remote metrics are embedded within {@link InvocationMetrics}.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) RemoteMetrics : public ::Ice::ValueHelper<RemoteMetrics, ChildInvocationMetrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~RemoteMetrics();

    RemoteMetrics() = default;

    RemoteMetrics(const RemoteMetrics&) = default;
    RemoteMetrics(RemoteMetrics&&) = default;
    RemoteMetrics& operator=(const RemoteMetrics&) = default;
    RemoteMetrics& operator=(RemoteMetrics&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param size The size of the invocation.
     * @param replySize The size of the invocation reply.
     */
    RemoteMetrics(const ::std::string& id, long long int total, int current, long long int totalLifetime, int failures, long long int size, long long int replySize) :
        Ice::ValueHelper<RemoteMetrics, ChildInvocationMetrics>(::std::move(id), total, current, totalLifetime, failures, size, replySize)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, size, replySize);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

/**
 * Provide measurements for proxy invocations. Proxy invocations can
 * either be sent over the wire or be collocated.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) InvocationMetrics : public ::Ice::ValueHelper<InvocationMetrics, Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~InvocationMetrics();

    InvocationMetrics() = default;

    InvocationMetrics(const InvocationMetrics&) = default;
    InvocationMetrics(InvocationMetrics&&) = default;
    InvocationMetrics& operator=(const InvocationMetrics&) = default;
    InvocationMetrics& operator=(InvocationMetrics&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param retry The number of retries for the invocation(s).
     * @param userException The number of invocations that failed with a user exception.
     * @param remotes The remote invocation metrics map.
     * @param collocated The collocated invocation metrics map.
     */
    InvocationMetrics(const ::std::string& id, long long int total, int current, long long int totalLifetime, int failures, int retry, int userException, const MetricsMap& remotes, const MetricsMap& collocated) :
        Ice::ValueHelper<InvocationMetrics, Metrics>(::std::move(id), total, current, totalLifetime, failures),
        retry(retry),
        userException(userException),
        remotes(::std::move(remotes)),
        collocated(::std::move(collocated))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const int&, const int&, const MetricsMap&, const MetricsMap&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, retry, userException, remotes, collocated);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    /**
     * The number of retries for the invocation(s).
     */
    int retry = 0;
    /**
     * The number of invocations that failed with a user exception.
     */
    int userException = 0;
    /**
     * The remote invocation metrics map.
     * @see RemoteMetrics
     */
    MetricsMap remotes;
    /**
     * The collocated invocation metrics map.
     * @see CollocatedMetrics
     */
    MetricsMap collocated;
};

/**
 * Provides information on the data sent and received over Ice
 * connections.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) ConnectionMetrics : public ::Ice::ValueHelper<ConnectionMetrics, Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionMetrics();

    ConnectionMetrics() = default;

    ConnectionMetrics(const ConnectionMetrics&) = default;
    ConnectionMetrics(ConnectionMetrics&&) = default;
    ConnectionMetrics& operator=(const ConnectionMetrics&) = default;
    ConnectionMetrics& operator=(ConnectionMetrics&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param receivedBytes The number of bytes received by the connection.
     * @param sentBytes The number of bytes sent by the connection.
     */
    ConnectionMetrics(const ::std::string& id, long long int total, int current, long long int totalLifetime, int failures, long long int receivedBytes, long long int sentBytes) :
        Ice::ValueHelper<ConnectionMetrics, Metrics>(::std::move(id), total, current, totalLifetime, failures),
        receivedBytes(receivedBytes),
        sentBytes(sentBytes)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, receivedBytes, sentBytes);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    /**
     * The number of bytes received by the connection.
     */
    long long int receivedBytes = 0LL;
    /**
     * The number of bytes sent by the connection.
     */
    long long int sentBytes = 0LL;
};

}

namespace IceMX
{

/**
 * The metrics administrative facet interface. This interface allows
 * remote administrative clients to access metrics of an application
 * that enabled the Ice administrative facility and configured some
 * metrics views.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) MetricsAdminPrx : public virtual ::Ice::Proxy<MetricsAdminPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Get the names of enabled and disabled metrics.
     * @param disabledViews The names of the disabled views.
     * @param context The Context map to send with the invocation.
     * @return The name of the enabled views.
     */
    ::Ice::StringSeq getMetricsViewNames(::Ice::StringSeq& disabledViews, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<MetricsAdmin::GetMetricsViewNamesResult>(true, this, &MetricsAdminPrx::_iceI_getMetricsViewNames, context).get();
        disabledViews = ::std::move(_result.disabledViews);
        return ::std::move(_result.returnValue);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getMetricsViewNamesAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<MetricsAdmin::GetMetricsViewNamesResult>>().get_future())
    {
        return _makePromiseOutgoing<MetricsAdmin::GetMetricsViewNamesResult, P>(false, this, &MetricsAdminPrx::_iceI_getMetricsViewNames, context);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getMetricsViewNamesAsync(::std::function<void(::Ice::StringSeq, ::Ice::StringSeq)> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](MetricsAdmin::GetMetricsViewNamesResult&& _result)
        {
            response(::std::move(_result.returnValue), ::std::move(_result.disabledViews));
        };
        return _makeLamdaOutgoing<MetricsAdmin::GetMetricsViewNamesResult>(_responseCb, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsViewNames, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getMetricsViewNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<MetricsAdmin::GetMetricsViewNamesResult>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    void enableMetricsView(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &MetricsAdminPrx::_iceI_enableMetricsView, name, context).get();
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto enableMetricsViewAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &MetricsAdminPrx::_iceI_enableMetricsView, name, context);
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    enableMetricsViewAsync(const ::std::string& name,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_enableMetricsView, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_enableMetricsView(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    void disableMetricsView(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &MetricsAdminPrx::_iceI_disableMetricsView, name, context).get();
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto disableMetricsViewAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &MetricsAdminPrx::_iceI_disableMetricsView, name, context);
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    disableMetricsViewAsync(const ::std::string& name,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_disableMetricsView, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_disableMetricsView(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     * @param context The Context map to send with the invocation.
     * @return The metrics view data.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    MetricsView getMetricsView(const ::std::string& view, long long int& timestamp, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<MetricsAdmin::GetMetricsViewResult>(true, this, &MetricsAdminPrx::_iceI_getMetricsView, view, context).get();
        timestamp = _result.timestamp;
        return ::std::move(_result.returnValue);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getMetricsViewAsync(const ::std::string& view, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<MetricsAdmin::GetMetricsViewResult>>().get_future())
    {
        return _makePromiseOutgoing<MetricsAdmin::GetMetricsViewResult, P>(false, this, &MetricsAdminPrx::_iceI_getMetricsView, view, context);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getMetricsViewAsync(const ::std::string& view,
                        ::std::function<void(MetricsView, long long int)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](MetricsAdmin::GetMetricsViewResult&& _result)
        {
            response(::std::move(_result.returnValue), _result.timestamp);
        };
        return _makeLamdaOutgoing<MetricsAdmin::GetMetricsViewResult>(_responseCb, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsView, view, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getMetricsView(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<MetricsAdmin::GetMetricsViewResult>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the map.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    MetricsFailuresSeq getMapMetricsFailures(const ::std::string& view, const ::std::string& map, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<MetricsFailuresSeq>(true, this, &MetricsAdminPrx::_iceI_getMapMetricsFailures, view, map, context).get();
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getMapMetricsFailuresAsync(const ::std::string& view, const ::std::string& map, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<MetricsFailuresSeq>>().get_future())
    {
        return _makePromiseOutgoing<MetricsFailuresSeq, P>(false, this, &MetricsAdminPrx::_iceI_getMapMetricsFailures, view, map, context);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getMapMetricsFailuresAsync(const ::std::string& view, const ::std::string& map,
                               ::std::function<void(MetricsFailuresSeq)> response,
                               ::std::function<void(::std::exception_ptr)> ex = nullptr,
                               ::std::function<void(bool)> sent = nullptr,
                               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<MetricsFailuresSeq>(response, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_getMapMetricsFailures, view, map, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getMapMetricsFailures(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<MetricsFailuresSeq>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the metrics.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    MetricsFailures getMetricsFailures(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<MetricsFailures>(true, this, &MetricsAdminPrx::_iceI_getMetricsFailures, view, map, id, context).get();
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getMetricsFailuresAsync(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<MetricsFailures>>().get_future())
    {
        return _makePromiseOutgoing<MetricsFailures, P>(false, this, &MetricsAdminPrx::_iceI_getMetricsFailures, view, map, id, context);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getMetricsFailuresAsync(const ::std::string& view, const ::std::string& map, const ::std::string& id,
                            ::std::function<void(MetricsFailures)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<MetricsFailures>(response, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsFailures, view, map, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getMetricsFailures(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<MetricsFailures>>&, const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    MetricsAdminPrx() = default;
    friend ::std::shared_ptr<MetricsAdminPrx> IceInternal::createProxy<MetricsAdminPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamReader<::IceMX::Metrics, S>
{
    static void read(S* istr, ::IceMX::Metrics& v)
    {
        istr->readAll(v.id, v.total, v.current, v.totalLifetime, v.failures);
    }
};

template<>
struct StreamableTraits<::IceMX::MetricsFailures>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceMX::MetricsFailures, S>
{
    static void read(S* istr, ::IceMX::MetricsFailures& v)
    {
        istr->readAll(v.id, v.failures);
    }
};

template<typename S>
struct StreamWriter<::IceMX::ThreadMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ThreadMetrics& v)
    {
        ostr->writeAll(v.inUseForIO, v.inUseForUser, v.inUseForOther);
    }
};

template<typename S>
struct StreamReader<::IceMX::ThreadMetrics, S>
{
    static void read(S* istr, ::IceMX::ThreadMetrics& v)
    {
        istr->readAll(v.inUseForIO, v.inUseForUser, v.inUseForOther);
    }
};

template<typename S>
struct StreamWriter<::IceMX::DispatchMetrics, S>
{
    static void write(S* ostr, const ::IceMX::DispatchMetrics& v)
    {
        ostr->writeAll(v.userException, v.size, v.replySize);
    }
};

template<typename S>
struct StreamReader<::IceMX::DispatchMetrics, S>
{
    static void read(S* istr, ::IceMX::DispatchMetrics& v)
    {
        istr->readAll(v.userException, v.size, v.replySize);
    }
};

template<typename S>
struct StreamWriter<::IceMX::ChildInvocationMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ChildInvocationMetrics& v)
    {
        ostr->writeAll(v.size, v.replySize);
    }
};

template<typename S>
struct StreamReader<::IceMX::ChildInvocationMetrics, S>
{
    static void read(S* istr, ::IceMX::ChildInvocationMetrics& v)
    {
        istr->readAll(v.size, v.replySize);
    }
};

template<typename S>
struct StreamWriter<::IceMX::CollocatedMetrics, S>
{
    static void write(S*, const ::IceMX::CollocatedMetrics&)
    {
    }
};

template<typename S>
struct StreamReader<::IceMX::CollocatedMetrics, S>
{
    static void read(S*, ::IceMX::CollocatedMetrics&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceMX::RemoteMetrics, S>
{
    static void write(S*, const ::IceMX::RemoteMetrics&)
    {
    }
};

template<typename S>
struct StreamReader<::IceMX::RemoteMetrics, S>
{
    static void read(S*, ::IceMX::RemoteMetrics&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceMX::InvocationMetrics, S>
{
    static void write(S* ostr, const ::IceMX::InvocationMetrics& v)
    {
        ostr->writeAll(v.retry, v.userException, v.remotes, v.collocated);
    }
};

template<typename S>
struct StreamReader<::IceMX::InvocationMetrics, S>
{
    static void read(S* istr, ::IceMX::InvocationMetrics& v)
    {
        istr->readAll(v.retry, v.userException, v.remotes, v.collocated);
    }
};

template<typename S>
struct StreamWriter<::IceMX::ConnectionMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ConnectionMetrics& v)
    {
        ostr->writeAll(v.receivedBytes, v.sentBytes);
    }
};

template<typename S>
struct StreamReader<::IceMX::ConnectionMetrics, S>
{
    static void read(S* istr, ::IceMX::ConnectionMetrics& v)
    {
        istr->readAll(v.receivedBytes, v.sentBytes);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IceMX
{

using MetricsPtr = ::std::shared_ptr<Metrics>;

using MetricsAdminPtr = ::std::shared_ptr<MetricsAdmin>;
using MetricsAdminPrxPtr = ::std::shared_ptr<MetricsAdminPrx>;

using ThreadMetricsPtr = ::std::shared_ptr<ThreadMetrics>;

using DispatchMetricsPtr = ::std::shared_ptr<DispatchMetrics>;

using ChildInvocationMetricsPtr = ::std::shared_ptr<ChildInvocationMetrics>;

using CollocatedMetricsPtr = ::std::shared_ptr<CollocatedMetrics>;

using RemoteMetricsPtr = ::std::shared_ptr<RemoteMetrics>;

using InvocationMetricsPtr = ::std::shared_ptr<InvocationMetrics>;

using ConnectionMetricsPtr = ::std::shared_ptr<ConnectionMetrics>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceMX
{

class Metrics;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Metrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(Metrics*);
/// \endcond

class MetricsAdmin;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< MetricsAdmin>&);
ICE_API ::IceProxy::Ice::Object* upCast(MetricsAdmin*);
/// \endcond

class ThreadMetrics;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ThreadMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(ThreadMetrics*);
/// \endcond

class DispatchMetrics;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< DispatchMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(DispatchMetrics*);
/// \endcond

class ChildInvocationMetrics;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ChildInvocationMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(ChildInvocationMetrics*);
/// \endcond

class CollocatedMetrics;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< CollocatedMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(CollocatedMetrics*);
/// \endcond

class RemoteMetrics;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< RemoteMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(RemoteMetrics*);
/// \endcond

class InvocationMetrics;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< InvocationMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(InvocationMetrics*);
/// \endcond

class ConnectionMetrics;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ConnectionMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(ConnectionMetrics*);
/// \endcond

}

}

namespace IceMX
{

class Metrics;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(Metrics*);
/// \endcond
typedef ::IceInternal::Handle< Metrics> MetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::Metrics> MetricsPrx;
typedef MetricsPrx MetricsPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(MetricsPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class MetricsAdmin;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(MetricsAdmin*);
/// \endcond
typedef ::IceInternal::Handle< MetricsAdmin> MetricsAdminPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::MetricsAdmin> MetricsAdminPrx;
typedef MetricsAdminPrx MetricsAdminPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(MetricsAdminPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ThreadMetrics;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(ThreadMetrics*);
/// \endcond
typedef ::IceInternal::Handle< ThreadMetrics> ThreadMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ThreadMetrics> ThreadMetricsPrx;
typedef ThreadMetricsPrx ThreadMetricsPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(ThreadMetricsPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class DispatchMetrics;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(DispatchMetrics*);
/// \endcond
typedef ::IceInternal::Handle< DispatchMetrics> DispatchMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::DispatchMetrics> DispatchMetricsPrx;
typedef DispatchMetricsPrx DispatchMetricsPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(DispatchMetricsPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ChildInvocationMetrics;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(ChildInvocationMetrics*);
/// \endcond
typedef ::IceInternal::Handle< ChildInvocationMetrics> ChildInvocationMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ChildInvocationMetrics> ChildInvocationMetricsPrx;
typedef ChildInvocationMetricsPrx ChildInvocationMetricsPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(ChildInvocationMetricsPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class CollocatedMetrics;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(CollocatedMetrics*);
/// \endcond
typedef ::IceInternal::Handle< CollocatedMetrics> CollocatedMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::CollocatedMetrics> CollocatedMetricsPrx;
typedef CollocatedMetricsPrx CollocatedMetricsPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(CollocatedMetricsPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class RemoteMetrics;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(RemoteMetrics*);
/// \endcond
typedef ::IceInternal::Handle< RemoteMetrics> RemoteMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::RemoteMetrics> RemoteMetricsPrx;
typedef RemoteMetricsPrx RemoteMetricsPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(RemoteMetricsPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class InvocationMetrics;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(InvocationMetrics*);
/// \endcond
typedef ::IceInternal::Handle< InvocationMetrics> InvocationMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::InvocationMetrics> InvocationMetricsPrx;
typedef InvocationMetricsPrx InvocationMetricsPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(InvocationMetricsPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ConnectionMetrics;
/// \cond INTERNAL
ICE_API ::Ice::Object* upCast(ConnectionMetrics*);
/// \endcond
typedef ::IceInternal::Handle< ConnectionMetrics> ConnectionMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ConnectionMetrics> ConnectionMetricsPrx;
typedef ConnectionMetricsPrx ConnectionMetricsPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(ConnectionMetricsPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceMX
{

/**
 * A dictionnary of strings to integers.
 */
typedef ::std::map< ::std::string, ::Ice::Int> StringIntDict;

/**
 * A structure to keep track of failures associated with a given
 * metrics.
 * \headerfile Ice/Ice.h
 */
struct MetricsFailures
{
    /**
     * The identifier of the metrics object associated to the
     * failures.
     */
    ::std::string id;
    /**
     * The failures observed for this metrics.
     */
    StringIntDict failures;
};

/**
 * A sequence of {@link MetricsFailures}.
 */
typedef ::std::vector<MetricsFailures> MetricsFailuresSeq;

/**
 * A metrics map is a sequence of metrics. We use a sequence here
 * instead of a map because the ID of the metrics is already included
 * in the Metrics class and using sequences of metrics objects is more
 * efficient than using dictionaries since lookup is not necessary.
 */
typedef ::std::vector<MetricsPtr> MetricsMap;

/**
 * A metrics view is a dictionary of metrics map. The key of the
 * dictionary is the name of the metrics map.
 */
typedef ::std::map< ::std::string, MetricsMap> MetricsView;

/**
 * Raised if a metrics view cannot be found.
 * \headerfile Ice/Ice.h
 */
class ICE_API UnknownMetricsView : public ::Ice::UserException
{
public:

    UnknownMetricsView() {}
    virtual ~UnknownMetricsView() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual UnknownMetricsView* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static UnknownMetricsView _iceS_UnknownMetricsView_init;
/// \endcond

}

namespace IceMX
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsViewNames.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsViewNames.
 */
class Callback_MetricsAdmin_getMetricsViewNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_getMetricsViewNames_Base> Callback_MetricsAdmin_getMetricsViewNamesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_enableMetricsView.
 */
class Callback_MetricsAdmin_enableMetricsView_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_enableMetricsView_Base> Callback_MetricsAdmin_enableMetricsViewPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_disableMetricsView.
 */
class Callback_MetricsAdmin_disableMetricsView_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_disableMetricsView_Base> Callback_MetricsAdmin_disableMetricsViewPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsView.
 */
class Callback_MetricsAdmin_getMetricsView_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_getMetricsView_Base> Callback_MetricsAdmin_getMetricsViewPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMapMetricsFailures.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMapMetricsFailures.
 */
class Callback_MetricsAdmin_getMapMetricsFailures_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_getMapMetricsFailures_Base> Callback_MetricsAdmin_getMapMetricsFailuresPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsFailures.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsFailures.
 */
class Callback_MetricsAdmin_getMetricsFailures_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_getMetricsFailures_Base> Callback_MetricsAdmin_getMetricsFailuresPtr;

}

namespace IceProxy
{

namespace IceMX
{

class ICE_CLASS(ICE_API) Metrics : public virtual ::Ice::Proxy<Metrics, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) MetricsAdmin : public virtual ::Ice::Proxy<MetricsAdmin, ::IceProxy::Ice::Object>
{
public:

    /**
     * Get the names of enabled and disabled metrics.
     * @param disabledViews The names of the disabled views.
     * @param context The Context map to send with the invocation.
     * @return The name of the enabled views.
     */
    ICE_MEMBER(ICE_API) ::Ice::StringSeq getMetricsViewNames(::Ice::StringSeq& disabledViews, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getMetricsViewNames(disabledViews, _iceI_begin_getMetricsViewNames(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getMetricsViewNames(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsViewNames(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsViewNames(context, cb, cookie);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::IceMX::Callback_MetricsAdmin_getMetricsViewNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsViewNames(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_getMetricsViewNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsViewNames(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getMetricsViewNames.
     * @param disabledViews The names of the disabled views.
     * @param result The asynchronous result object for the invocation.
     * @return The name of the enabled views.
     */
    ICE_MEMBER(ICE_API) ::Ice::StringSeq end_getMetricsViewNames(::Ice::StringSeq& disabledViews, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) void _iceI_end_getMetricsViewNames(::Ice::StringSeq& iceP_disabledViews, ::Ice::StringSeq& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getMetricsViewNames(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) void enableMetricsView(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_enableMetricsView(_iceI_begin_enableMetricsView(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_enableMetricsView(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableMetricsView(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableMetricsView(name, context, cb, cookie);
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& name, const ::IceMX::Callback_MetricsAdmin_enableMetricsViewPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableMetricsView(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& name, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_enableMetricsViewPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableMetricsView(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_enableMetricsView.
     * @param result The asynchronous result object for the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) void end_enableMetricsView(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_enableMetricsView(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) void disableMetricsView(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_disableMetricsView(_iceI_begin_disableMetricsView(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_disableMetricsView(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_disableMetricsView(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_disableMetricsView(name, context, cb, cookie);
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& name, const ::IceMX::Callback_MetricsAdmin_disableMetricsViewPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_disableMetricsView(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& name, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_disableMetricsViewPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_disableMetricsView(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_disableMetricsView.
     * @param result The asynchronous result object for the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) void end_disableMetricsView(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_disableMetricsView(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     * @param context The Context map to send with the invocation.
     * @return The metrics view data.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) ::IceMX::MetricsView getMetricsView(const ::std::string& view, ::Ice::Long& timestamp, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getMetricsView(timestamp, _iceI_begin_getMetricsView(view, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& view, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getMetricsView(view, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& view, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsView(view, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& view, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsView(view, context, cb, cookie);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& view, const ::IceMX::Callback_MetricsAdmin_getMetricsViewPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsView(view, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& view, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_getMetricsViewPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsView(view, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getMetricsView.
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     * @param result The asynchronous result object for the invocation.
     * @return The metrics view data.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) ::IceMX::MetricsView end_getMetricsView(::Ice::Long& timestamp, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) void _iceI_end_getMetricsView(::Ice::Long& iceP_timestamp, ::IceMX::MetricsView& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getMetricsView(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the map.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) ::IceMX::MetricsFailuresSeq getMapMetricsFailures(const ::std::string& view, const ::std::string& map, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getMapMetricsFailures(_iceI_begin_getMapMetricsFailures(view, map, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& view, const ::std::string& map, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getMapMetricsFailures(view, map, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& view, const ::std::string& map, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMapMetricsFailures(view, map, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& view, const ::std::string& map, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMapMetricsFailures(view, map, context, cb, cookie);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& view, const ::std::string& map, const ::IceMX::Callback_MetricsAdmin_getMapMetricsFailuresPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMapMetricsFailures(view, map, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& view, const ::std::string& map, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_getMapMetricsFailuresPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMapMetricsFailures(view, map, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getMapMetricsFailures.
     * @param result The asynchronous result object for the invocation.
     * @return The metrics failures associated with the map.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) ::IceMX::MetricsFailuresSeq end_getMapMetricsFailures(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getMapMetricsFailures(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the metrics.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) ::IceMX::MetricsFailures getMetricsFailures(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getMetricsFailures(_iceI_begin_getMetricsFailures(view, map, id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getMetricsFailures(view, map, id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsFailures(view, map, id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsFailures(view, map, id, context, cb, cookie);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::IceMX::Callback_MetricsAdmin_getMetricsFailuresPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsFailures(view, map, id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_getMetricsFailuresPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsFailures(view, map, id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getMetricsFailures.
     * @param result The asynchronous result object for the invocation.
     * @return The metrics failures associated with the metrics.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) ::IceMX::MetricsFailures end_getMetricsFailures(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getMetricsFailures(const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) ThreadMetrics : public virtual ::Ice::Proxy<ThreadMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) DispatchMetrics : public virtual ::Ice::Proxy<DispatchMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) ChildInvocationMetrics : public virtual ::Ice::Proxy<ChildInvocationMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) CollocatedMetrics : public virtual ::Ice::Proxy<CollocatedMetrics, ::IceProxy::IceMX::ChildInvocationMetrics>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) RemoteMetrics : public virtual ::Ice::Proxy<RemoteMetrics, ::IceProxy::IceMX::ChildInvocationMetrics>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) InvocationMetrics : public virtual ::Ice::Proxy<InvocationMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) ConnectionMetrics : public virtual ::Ice::Proxy<ConnectionMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceMX
{

/**
 * The base class for metrics. A metrics object represents a
 * collection of measurements associated to a given a system.
 * \headerfile Ice/Ice.h
 */
class ICE_API Metrics : public virtual ::Ice::Object
{
public:

    typedef MetricsPrx ProxyType;
    typedef MetricsPtr PointerType;

    virtual ~Metrics();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    Metrics() :
        total(ICE_INT64(0)),
        current(0),
        totalLifetime(ICE_INT64(0)),
        failures(0)
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     */
    Metrics(const ::std::string& id, ::Ice::Long total, ::Ice::Int current, ::Ice::Long totalLifetime, ::Ice::Int failures) :
        id(id),
        total(total),
        current(current),
        totalLifetime(totalLifetime),
        failures(failures)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The metrics identifier.
     */
    ::std::string id;
    /**
     * The total number of objects that were observed by this metrics.
     */
    ::Ice::Long total;
    /**
     * The current number of objects observed by this metrics.
     */
    ::Ice::Int current;
    /**
     * The sum of the lifetime of each observed objects. This does not
     * include the lifetime of objects which are currently observed.
     */
    ::Ice::Long totalLifetime;
    /**
     * The number of failures observed.
     */
    ::Ice::Int failures;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_Metrics_init = ::IceMX::Metrics::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const Metrics& lhs, const Metrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Metrics& lhs, const Metrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The metrics administrative facet interface. This interface allows
 * remote administrative clients to access metrics of an application
 * that enabled the Ice administrative facility and configured some
 * metrics views.
 * \headerfile Ice/Ice.h
 */
class ICE_API MetricsAdmin : public virtual ::Ice::Object
{
public:

    typedef MetricsAdminPrx ProxyType;
    typedef MetricsAdminPtr PointerType;

    virtual ~MetricsAdmin();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the names of enabled and disabled metrics.
     * @param disabledViews The names of the disabled views.
     * @param current The Current object for the invocation.
     * @return The name of the enabled views.
     */
    virtual ::Ice::StringSeq getMetricsViewNames(::Ice::StringSeq& disabledViews, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getMetricsViewNames(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Enables a metrics view.
     * @param name The metrics view name.
     * @param current The Current object for the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual void enableMetricsView(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_enableMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Disable a metrics view.
     * @param name The metrics view name.
     * @param current The Current object for the invocation.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual void disableMetricsView(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_disableMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * @param view The name of the metrics view.
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     * @param current The Current object for the invocation.
     * @return The metrics view data.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual MetricsView getMetricsView(const ::std::string& view, ::Ice::Long& timestamp, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the metrics failures associated with the given view and map.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param current The Current object for the invocation.
     * @return The metrics failures associated with the map.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual MetricsFailuresSeq getMapMetricsFailures(const ::std::string& view, const ::std::string& map, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getMapMetricsFailures(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the metrics failure associated for the given metrics.
     * @param view The name of the metrics view.
     * @param map The name of the metrics map.
     * @param id The ID of the metrics.
     * @param current The Current object for the invocation.
     * @return The metrics failures associated with the metrics.
     * @throws IceMX::UnknownMetricsView Raised if the metrics view cannot be
     * found.
     */
    virtual MetricsFailures getMetricsFailures(const ::std::string& view, const ::std::string& map, const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getMetricsFailures(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const MetricsAdmin& lhs, const MetricsAdmin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const MetricsAdmin& lhs, const MetricsAdmin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Provides information on the number of threads currently in use and
 * their activity.
 * \headerfile Ice/Ice.h
 */
class ICE_API ThreadMetrics : public Metrics
{
public:

    typedef ThreadMetricsPrx ProxyType;
    typedef ThreadMetricsPtr PointerType;

    virtual ~ThreadMetrics();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    ThreadMetrics() :
        inUseForIO(0),
        inUseForUser(0),
        inUseForOther(0)
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param inUseForIO The number of threads which are currently performing socket read or writes.
     * @param inUseForUser The number of threads which are currently calling user code (servant dispatch, AMI callbacks, etc).
     * @param inUseForOther The number of threads which are currently performing other activities.
     */
    ThreadMetrics(const ::std::string& id, ::Ice::Long total, ::Ice::Int current, ::Ice::Long totalLifetime, ::Ice::Int failures, ::Ice::Int inUseForIO, ::Ice::Int inUseForUser, ::Ice::Int inUseForOther) :
        ::IceMX::Metrics(id, total, current, totalLifetime, failures),
        inUseForIO(inUseForIO),
        inUseForUser(inUseForUser),
        inUseForOther(inUseForOther)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The number of threads which are currently performing socket
     * read or writes.
     */
    ::Ice::Int inUseForIO;
    /**
     * The number of threads which are currently calling user code
     * (servant dispatch, AMI callbacks, etc).
     */
    ::Ice::Int inUseForUser;
    /**
     * The number of threads which are currently performing other
     * activities. These are all other that are not counted with
     * {@link #inUseForUser} or {@link #inUseForIO}, such as DNS
     * lookups, garbage collection).
     */
    ::Ice::Int inUseForOther;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_ThreadMetrics_init = ::IceMX::ThreadMetrics::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const ThreadMetrics& lhs, const ThreadMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ThreadMetrics& lhs, const ThreadMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Provides information on servant dispatch.
 * \headerfile Ice/Ice.h
 */
class ICE_API DispatchMetrics : public Metrics
{
public:

    typedef DispatchMetricsPrx ProxyType;
    typedef DispatchMetricsPtr PointerType;

    virtual ~DispatchMetrics();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    DispatchMetrics() :
        userException(0),
        size(ICE_INT64(0)),
        replySize(ICE_INT64(0))
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param userException The number of dispatch that failed with a user exception.
     * @param size The size of the dispatch.
     * @param replySize The size of the dispatch reply.
     */
    DispatchMetrics(const ::std::string& id, ::Ice::Long total, ::Ice::Int current, ::Ice::Long totalLifetime, ::Ice::Int failures, ::Ice::Int userException, ::Ice::Long size, ::Ice::Long replySize) :
        ::IceMX::Metrics(id, total, current, totalLifetime, failures),
        userException(userException),
        size(size),
        replySize(replySize)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The number of dispatch that failed with a user exception.
     */
    ::Ice::Int userException;
    /**
     * The size of the dispatch. This corresponds to the size of the
     * marshalled input parameters.
     */
    ::Ice::Long size;
    /**
     * The size of the dispatch reply. This corresponds to the size of
     * the marshalled output and return parameters.
     */
    ::Ice::Long replySize;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_DispatchMetrics_init = ::IceMX::DispatchMetrics::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const DispatchMetrics& lhs, const DispatchMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const DispatchMetrics& lhs, const DispatchMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Provides information on child invocations. A child invocation is
 * either remote (sent over an Ice connection) or collocated. An
 * invocation can have multiple child invocation if it is
 * retried. Child invocation metrics are embedded within {@link
 * InvocationMetrics}.
 * \headerfile Ice/Ice.h
 */
class ICE_API ChildInvocationMetrics : public Metrics
{
public:

    typedef ChildInvocationMetricsPrx ProxyType;
    typedef ChildInvocationMetricsPtr PointerType;

    virtual ~ChildInvocationMetrics();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    ChildInvocationMetrics() :
        size(ICE_INT64(0)),
        replySize(ICE_INT64(0))
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param size The size of the invocation.
     * @param replySize The size of the invocation reply.
     */
    ChildInvocationMetrics(const ::std::string& id, ::Ice::Long total, ::Ice::Int current, ::Ice::Long totalLifetime, ::Ice::Int failures, ::Ice::Long size, ::Ice::Long replySize) :
        ::IceMX::Metrics(id, total, current, totalLifetime, failures),
        size(size),
        replySize(replySize)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The size of the invocation. This corresponds to the size of the
     * marshalled input parameters.
     */
    ::Ice::Long size;
    /**
     * The size of the invocation reply. This corresponds to the size
     * of the marshalled output and return parameters.
     */
    ::Ice::Long replySize;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_ChildInvocationMetrics_init = ::IceMX::ChildInvocationMetrics::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const ChildInvocationMetrics& lhs, const ChildInvocationMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ChildInvocationMetrics& lhs, const ChildInvocationMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Provides information on invocations that are collocated. Collocated
 * metrics are embedded within {@link InvocationMetrics}.
 * \headerfile Ice/Ice.h
 */
class ICE_API CollocatedMetrics : public ChildInvocationMetrics
{
public:

    typedef CollocatedMetricsPrx ProxyType;
    typedef CollocatedMetricsPtr PointerType;

    virtual ~CollocatedMetrics();

    CollocatedMetrics()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param size The size of the invocation.
     * @param replySize The size of the invocation reply.
     */
    CollocatedMetrics(const ::std::string& id, ::Ice::Long total, ::Ice::Int current, ::Ice::Long totalLifetime, ::Ice::Int failures, ::Ice::Long size, ::Ice::Long replySize) :
        ::IceMX::ChildInvocationMetrics(id, total, current, totalLifetime, failures, size, replySize)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_CollocatedMetrics_init = ::IceMX::CollocatedMetrics::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const CollocatedMetrics& lhs, const CollocatedMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const CollocatedMetrics& lhs, const CollocatedMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Provides information on invocations that are specifically sent over
 * Ice connections. Remote metrics are embedded within {@link InvocationMetrics}.
 * \headerfile Ice/Ice.h
 */
class ICE_API RemoteMetrics : public ChildInvocationMetrics
{
public:

    typedef RemoteMetricsPrx ProxyType;
    typedef RemoteMetricsPtr PointerType;

    virtual ~RemoteMetrics();

    RemoteMetrics()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param size The size of the invocation.
     * @param replySize The size of the invocation reply.
     */
    RemoteMetrics(const ::std::string& id, ::Ice::Long total, ::Ice::Int current, ::Ice::Long totalLifetime, ::Ice::Int failures, ::Ice::Long size, ::Ice::Long replySize) :
        ::IceMX::ChildInvocationMetrics(id, total, current, totalLifetime, failures, size, replySize)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_RemoteMetrics_init = ::IceMX::RemoteMetrics::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const RemoteMetrics& lhs, const RemoteMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RemoteMetrics& lhs, const RemoteMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Provide measurements for proxy invocations. Proxy invocations can
 * either be sent over the wire or be collocated.
 * \headerfile Ice/Ice.h
 */
class ICE_API InvocationMetrics : public Metrics, public ::IceInternal::GCObject
{
public:

    typedef InvocationMetricsPrx ProxyType;
    typedef InvocationMetricsPtr PointerType;

    virtual ~InvocationMetrics();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    InvocationMetrics() :
        retry(0),
        userException(0)
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param retry The number of retries for the invocation(s).
     * @param userException The number of invocations that failed with a user exception.
     * @param remotes The remote invocation metrics map.
     * @param collocated The collocated invocation metrics map.
     */
    InvocationMetrics(const ::std::string& id, ::Ice::Long total, ::Ice::Int current, ::Ice::Long totalLifetime, ::Ice::Int failures, ::Ice::Int retry, ::Ice::Int userException, const MetricsMap& remotes, const MetricsMap& collocated) :
        ::IceMX::Metrics(id, total, current, totalLifetime, failures),
        retry(retry),
        userException(userException),
        remotes(remotes),
        collocated(collocated)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
    /// \cond INTERNAL
    virtual void _iceGcVisitMembers(::IceInternal::GCVisitor&);
    /// \endcond

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The number of retries for the invocation(s).
     */
    ::Ice::Int retry;
    /**
     * The number of invocations that failed with a user exception.
     */
    ::Ice::Int userException;
    /**
     * The remote invocation metrics map.
     * @see RemoteMetrics
     */
    MetricsMap remotes;
    /**
     * The collocated invocation metrics map.
     * @see CollocatedMetrics
     */
    MetricsMap collocated;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_InvocationMetrics_init = ::IceMX::InvocationMetrics::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const InvocationMetrics& lhs, const InvocationMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InvocationMetrics& lhs, const InvocationMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Provides information on the data sent and received over Ice
 * connections.
 * \headerfile Ice/Ice.h
 */
class ICE_API ConnectionMetrics : public Metrics
{
public:

    typedef ConnectionMetricsPrx ProxyType;
    typedef ConnectionMetricsPtr PointerType;

    virtual ~ConnectionMetrics();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    ConnectionMetrics() :
        receivedBytes(ICE_INT64(0)),
        sentBytes(ICE_INT64(0))
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The metrics identifier.
     * @param total The total number of objects that were observed by this metrics.
     * @param current The current number of objects observed by this metrics.
     * @param totalLifetime The sum of the lifetime of each observed objects.
     * @param failures The number of failures observed.
     * @param receivedBytes The number of bytes received by the connection.
     * @param sentBytes The number of bytes sent by the connection.
     */
    ConnectionMetrics(const ::std::string& id, ::Ice::Long total, ::Ice::Int current, ::Ice::Long totalLifetime, ::Ice::Int failures, ::Ice::Long receivedBytes, ::Ice::Long sentBytes) :
        ::IceMX::Metrics(id, total, current, totalLifetime, failures),
        receivedBytes(receivedBytes),
        sentBytes(sentBytes)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The number of bytes received by the connection.
     */
    ::Ice::Long receivedBytes;
    /**
     * The number of bytes sent by the connection.
     */
    ::Ice::Long sentBytes;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_ConnectionMetrics_init = ::IceMX::ConnectionMetrics::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const ConnectionMetrics& lhs, const ConnectionMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ConnectionMetrics& lhs, const ConnectionMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamWriter< ::IceMX::Metrics, S>
{
    static void write(S* ostr, const ::IceMX::Metrics& v)
    {
        ostr->write(v.id);
        ostr->write(v.total);
        ostr->write(v.current);
        ostr->write(v.totalLifetime);
        ostr->write(v.failures);
    }
};

template<typename S>
struct StreamReader< ::IceMX::Metrics, S>
{
    static void read(S* istr, ::IceMX::Metrics& v)
    {
        istr->read(v.id);
        istr->read(v.total);
        istr->read(v.current);
        istr->read(v.totalLifetime);
        istr->read(v.failures);
    }
};

template<>
struct StreamableTraits< ::IceMX::MetricsFailures>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceMX::MetricsFailures, S>
{
    static void write(S* ostr, const ::IceMX::MetricsFailures& v)
    {
        ostr->write(v.id);
        ostr->write(v.failures);
    }
};

template<typename S>
struct StreamReader< ::IceMX::MetricsFailures, S>
{
    static void read(S* istr, ::IceMX::MetricsFailures& v)
    {
        istr->read(v.id);
        istr->read(v.failures);
    }
};

template<>
struct StreamableTraits< ::IceMX::UnknownMetricsView>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceMX::ThreadMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ThreadMetrics& v)
    {
        ostr->write(v.inUseForIO);
        ostr->write(v.inUseForUser);
        ostr->write(v.inUseForOther);
    }
};

template<typename S>
struct StreamReader< ::IceMX::ThreadMetrics, S>
{
    static void read(S* istr, ::IceMX::ThreadMetrics& v)
    {
        istr->read(v.inUseForIO);
        istr->read(v.inUseForUser);
        istr->read(v.inUseForOther);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::DispatchMetrics, S>
{
    static void write(S* ostr, const ::IceMX::DispatchMetrics& v)
    {
        ostr->write(v.userException);
        ostr->write(v.size);
        ostr->write(v.replySize);
    }
};

template<typename S>
struct StreamReader< ::IceMX::DispatchMetrics, S>
{
    static void read(S* istr, ::IceMX::DispatchMetrics& v)
    {
        istr->read(v.userException);
        istr->read(v.size);
        istr->read(v.replySize);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::ChildInvocationMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ChildInvocationMetrics& v)
    {
        ostr->write(v.size);
        ostr->write(v.replySize);
    }
};

template<typename S>
struct StreamReader< ::IceMX::ChildInvocationMetrics, S>
{
    static void read(S* istr, ::IceMX::ChildInvocationMetrics& v)
    {
        istr->read(v.size);
        istr->read(v.replySize);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::InvocationMetrics, S>
{
    static void write(S* ostr, const ::IceMX::InvocationMetrics& v)
    {
        ostr->write(v.retry);
        ostr->write(v.userException);
        ostr->write(v.remotes);
        ostr->write(v.collocated);
    }
};

template<typename S>
struct StreamReader< ::IceMX::InvocationMetrics, S>
{
    static void read(S* istr, ::IceMX::InvocationMetrics& v)
    {
        istr->read(v.retry);
        istr->read(v.userException);
        istr->read(v.remotes);
        istr->read(v.collocated);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::ConnectionMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ConnectionMetrics& v)
    {
        ostr->write(v.receivedBytes);
        ostr->write(v.sentBytes);
    }
};

template<typename S>
struct StreamReader< ::IceMX::ConnectionMetrics, S>
{
    static void read(S* istr, ::IceMX::ConnectionMetrics& v)
    {
        istr->read(v.receivedBytes);
        istr->read(v.sentBytes);
    }
};

}
/// \endcond

namespace IceMX
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsViewNames.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsViewNames.
 */
template<class T>
class CallbackNC_MetricsAdmin_getMetricsViewNames : public Callback_MetricsAdmin_getMetricsViewNames_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const ::Ice::StringSeq&);

    CallbackNC_MetricsAdmin_getMetricsViewNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq iceP_disabledViews;
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getMetricsViewNames(iceP_disabledViews, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_disabledViews);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsViewNames.
 */
template<class T> Callback_MetricsAdmin_getMetricsViewNamesPtr
newCallback_MetricsAdmin_getMetricsViewNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsViewNames<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsViewNames.
 */
template<class T> Callback_MetricsAdmin_getMetricsViewNamesPtr
newCallback_MetricsAdmin_getMetricsViewNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsViewNames<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsViewNames.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsViewNames.
 */
template<class T, typename CT>
class Callback_MetricsAdmin_getMetricsViewNames : public Callback_MetricsAdmin_getMetricsViewNames_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const ::Ice::StringSeq&, const CT&);

    Callback_MetricsAdmin_getMetricsViewNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq iceP_disabledViews;
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getMetricsViewNames(iceP_disabledViews, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_disabledViews, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsViewNames.
 */
template<class T, typename CT> Callback_MetricsAdmin_getMetricsViewNamesPtr
newCallback_MetricsAdmin_getMetricsViewNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsViewNames<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsViewNames.
 */
template<class T, typename CT> Callback_MetricsAdmin_getMetricsViewNamesPtr
newCallback_MetricsAdmin_getMetricsViewNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsViewNames<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_enableMetricsView.
 */
template<class T>
class CallbackNC_MetricsAdmin_enableMetricsView : public Callback_MetricsAdmin_enableMetricsView_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_MetricsAdmin_enableMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_enableMetricsView(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 */
template<class T> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_enableMetricsView<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 */
template<class T> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_enableMetricsView<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 */
template<class T> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_enableMetricsView<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 */
template<class T> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_enableMetricsView<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_enableMetricsView.
 */
template<class T, typename CT>
class Callback_MetricsAdmin_enableMetricsView : public Callback_MetricsAdmin_enableMetricsView_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_MetricsAdmin_enableMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_enableMetricsView(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_enableMetricsView<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_enableMetricsView<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_enableMetricsView<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_enableMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_enableMetricsView<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_disableMetricsView.
 */
template<class T>
class CallbackNC_MetricsAdmin_disableMetricsView : public Callback_MetricsAdmin_disableMetricsView_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_MetricsAdmin_disableMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_disableMetricsView(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 */
template<class T> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_disableMetricsView<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 */
template<class T> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_disableMetricsView<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 */
template<class T> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_disableMetricsView<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 */
template<class T> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_disableMetricsView<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_disableMetricsView.
 */
template<class T, typename CT>
class Callback_MetricsAdmin_disableMetricsView : public Callback_MetricsAdmin_disableMetricsView_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_MetricsAdmin_disableMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_disableMetricsView(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_disableMetricsView<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_disableMetricsView<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_disableMetricsView<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_disableMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_disableMetricsView<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsView.
 */
template<class T>
class CallbackNC_MetricsAdmin_getMetricsView : public Callback_MetricsAdmin_getMetricsView_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const MetricsView&, ::Ice::Long);

    CallbackNC_MetricsAdmin_getMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_timestamp;
        MetricsView ret;
        try
        {
            ret = proxy->end_getMetricsView(iceP_timestamp, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_timestamp);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsView.
 */
template<class T> Callback_MetricsAdmin_getMetricsViewPtr
newCallback_MetricsAdmin_getMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(const MetricsView&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsView<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsView.
 */
template<class T> Callback_MetricsAdmin_getMetricsViewPtr
newCallback_MetricsAdmin_getMetricsView(T* instance, void (T::*cb)(const MetricsView&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsView<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsView.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsView.
 */
template<class T, typename CT>
class Callback_MetricsAdmin_getMetricsView : public Callback_MetricsAdmin_getMetricsView_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const MetricsView&, ::Ice::Long, const CT&);

    Callback_MetricsAdmin_getMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_timestamp;
        MetricsView ret;
        try
        {
            ret = proxy->end_getMetricsView(iceP_timestamp, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_timestamp, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_getMetricsViewPtr
newCallback_MetricsAdmin_getMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(const MetricsView&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsView<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsView.
 */
template<class T, typename CT> Callback_MetricsAdmin_getMetricsViewPtr
newCallback_MetricsAdmin_getMetricsView(T* instance, void (T::*cb)(const MetricsView&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsView<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMapMetricsFailures.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMapMetricsFailures.
 */
template<class T>
class CallbackNC_MetricsAdmin_getMapMetricsFailures : public Callback_MetricsAdmin_getMapMetricsFailures_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const MetricsFailuresSeq&);

    CallbackNC_MetricsAdmin_getMapMetricsFailures(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        MetricsFailuresSeq ret;
        try
        {
            ret = proxy->end_getMapMetricsFailures(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMapMetricsFailures.
 */
template<class T> Callback_MetricsAdmin_getMapMetricsFailuresPtr
newCallback_MetricsAdmin_getMapMetricsFailures(const IceUtil::Handle<T>& instance, void (T::*cb)(const MetricsFailuresSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMapMetricsFailures<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMapMetricsFailures.
 */
template<class T> Callback_MetricsAdmin_getMapMetricsFailuresPtr
newCallback_MetricsAdmin_getMapMetricsFailures(T* instance, void (T::*cb)(const MetricsFailuresSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMapMetricsFailures<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMapMetricsFailures.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMapMetricsFailures.
 */
template<class T, typename CT>
class Callback_MetricsAdmin_getMapMetricsFailures : public Callback_MetricsAdmin_getMapMetricsFailures_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const MetricsFailuresSeq&, const CT&);

    Callback_MetricsAdmin_getMapMetricsFailures(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        MetricsFailuresSeq ret;
        try
        {
            ret = proxy->end_getMapMetricsFailures(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMapMetricsFailures.
 */
template<class T, typename CT> Callback_MetricsAdmin_getMapMetricsFailuresPtr
newCallback_MetricsAdmin_getMapMetricsFailures(const IceUtil::Handle<T>& instance, void (T::*cb)(const MetricsFailuresSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMapMetricsFailures<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMapMetricsFailures.
 */
template<class T, typename CT> Callback_MetricsAdmin_getMapMetricsFailuresPtr
newCallback_MetricsAdmin_getMapMetricsFailures(T* instance, void (T::*cb)(const MetricsFailuresSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMapMetricsFailures<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsFailures.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsFailures.
 */
template<class T>
class CallbackNC_MetricsAdmin_getMetricsFailures : public Callback_MetricsAdmin_getMetricsFailures_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const MetricsFailures&);

    CallbackNC_MetricsAdmin_getMetricsFailures(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        MetricsFailures ret;
        try
        {
            ret = proxy->end_getMetricsFailures(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsFailures.
 */
template<class T> Callback_MetricsAdmin_getMetricsFailuresPtr
newCallback_MetricsAdmin_getMetricsFailures(const IceUtil::Handle<T>& instance, void (T::*cb)(const MetricsFailures&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsFailures<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsFailures.
 */
template<class T> Callback_MetricsAdmin_getMetricsFailuresPtr
newCallback_MetricsAdmin_getMetricsFailures(T* instance, void (T::*cb)(const MetricsFailures&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsFailures<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceMX::MetricsAdmin::begin_getMetricsFailures.
 * Create a wrapper instance by calling ::IceMX::newCallback_MetricsAdmin_getMetricsFailures.
 */
template<class T, typename CT>
class Callback_MetricsAdmin_getMetricsFailures : public Callback_MetricsAdmin_getMetricsFailures_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const MetricsFailures&, const CT&);

    Callback_MetricsAdmin_getMetricsFailures(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        MetricsAdminPrx proxy = MetricsAdminPrx::uncheckedCast(result->getProxy());
        MetricsFailures ret;
        try
        {
            ret = proxy->end_getMetricsFailures(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsFailures.
 */
template<class T, typename CT> Callback_MetricsAdmin_getMetricsFailuresPtr
newCallback_MetricsAdmin_getMetricsFailures(const IceUtil::Handle<T>& instance, void (T::*cb)(const MetricsFailures&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsFailures<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceMX::MetricsAdmin::begin_getMetricsFailures.
 */
template<class T, typename CT> Callback_MetricsAdmin_getMetricsFailuresPtr
newCallback_MetricsAdmin_getMetricsFailures(T* instance, void (T::*cb)(const MetricsFailures&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsFailures<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
