/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class SingleTypeReference
extends TypeReference {
    public char[] token;

    public SingleTypeReference(char[] cArray, long l) {
        this.token = cArray;
        this.sourceStart = (int)(l >>> 32);
        this.sourceEnd = (int)(l & 0xFFFFFFFFL);
    }

    @Override
    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        int n2 = this.dimensions() + n;
        Annotation[][] annotationArray2 = this.getMergedAnnotationsOnDimensions(n, annotationArray);
        ArrayTypeReference arrayTypeReference = new ArrayTypeReference(this.token, n2, annotationArray2, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        arrayTypeReference.annotations = this.annotations;
        arrayTypeReference.bits |= this.bits & 0x100000;
        if (!bl) {
            arrayTypeReference.extendedDimensions = n;
        }
        return arrayTypeReference;
    }

    @Override
    public char[] getLastToken() {
        return this.token;
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.resolvedType = scope.getType(this.token);
        if (this.resolvedType instanceof TypeVariableBinding) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.resolvedType;
            if (typeVariableBinding.declaringElement instanceof SourceTypeBinding) {
                scope.tagAsAccessingEnclosingInstanceStateOf((ReferenceBinding)typeVariableBinding.declaringElement, true);
            }
        } else if (this.resolvedType instanceof LocalTypeBinding) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.resolvedType;
            MethodScope methodScope = scope.methodScope();
            if (methodScope != null && !methodScope.isStatic) {
                methodScope.tagAsAccessingEnclosingInstanceStateOf(localTypeBinding, false);
            }
        }
        if (scope.kind == 3 && this.resolvedType.isValidBinding() && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this)) {
            return null;
        }
        return this.resolvedType;
    }

    @Override
    public char[][] getTypeName() {
        return new char[][]{this.token};
    }

    @Override
    public boolean isBaseTypeReference() {
        return this.token == BYTE || this.token == SHORT || this.token == INT || this.token == LONG || this.token == FLOAT || this.token == DOUBLE || this.token == CHAR || this.token == BOOLEAN || this.token == NULL || this.token == VOID;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.annotations != null && this.annotations[0] != null) {
            SingleTypeReference.printAnnotations(this.annotations[0], stringBuffer);
            stringBuffer.append(' ');
        }
        return stringBuffer.append(this.token);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        this.resolvedType = blockScope.getMemberType(this.token, referenceBinding);
        boolean bl = false;
        this.resolveAnnotations(blockScope, 0);
        TypeBinding typeBinding = this.resolvedType;
        if (!typeBinding.isValidBinding()) {
            bl = true;
            blockScope.problemReporter().invalidEnclosingType(this, typeBinding, referenceBinding);
            typeBinding = ((ReferenceBinding)typeBinding).closestMatch();
            if (typeBinding == null) {
                return null;
            }
        }
        if (this.isTypeUseDeprecated(typeBinding, blockScope)) {
            this.reportDeprecatedType(typeBinding, blockScope);
        }
        if ((typeBinding = blockScope.environment().convertToRawType(typeBinding, false)).isRawType() && (this.bits & 0x40000000) == 0 && blockScope.compilerOptions().getSeverity(0x20010000) != 256) {
            blockScope.problemReporter().rawTypeReference(this, typeBinding);
        }
        if (bl) {
            return typeBinding;
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.annotations != null) {
            int n;
            Annotation[] annotationArray = this.annotations[0];
            int n2 = n = annotationArray == null ? 0 : annotationArray.length;
            for (int i = 0; i < n; ++i) {
                annotationArray[i].traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope) && this.annotations != null) {
            int n;
            Annotation[] annotationArray = this.annotations[0];
            int n2 = n = annotationArray == null ? 0 : annotationArray.length;
            for (int i = 0; i < n; ++i) {
                annotationArray[i].traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

