/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.EffectType;
import java.awt.Color;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributes
implements Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.markup.TextAttributes");
    public static final TextAttributes ERASE_MARKER = new TextAttributes();
    @NotNull
    private AttributesFlyweight myAttrs;

    public TextAttributes() {
        this(null, null, null, EffectType.BOXED, 0);
    }

    private TextAttributes(@NotNull AttributesFlyweight attributesFlyweight) {
        if (attributesFlyweight == null) {
            TextAttributes.$$$reportNull$$$0(0);
        }
        this.myAttrs = attributesFlyweight;
    }

    public TextAttributes(@Nullable Color foregroundColor, @Nullable Color backgroundColor, @Nullable Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.setAttributes(foregroundColor, backgroundColor, effectColor, null, effectType, fontType);
    }

    public void setAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, Color errorStripeColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.myAttrs = AttributesFlyweight.create(foregroundColor, backgroundColor, fontType, effectColor, effectType, errorStripeColor);
    }

    public Color getForegroundColor() {
        return this.myAttrs.getForeground();
    }

    public Color getBackgroundColor() {
        return this.myAttrs.getBackground();
    }

    public Color getEffectColor() {
        return this.myAttrs.getEffectColor();
    }

    public Color getErrorStripeColor() {
        return this.myAttrs.getErrorStripeColor();
    }

    public EffectType getEffectType() {
        return this.myAttrs.getEffectType();
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myAttrs.getFontType();
    }

    public TextAttributes clone() {
        return new TextAttributes(this.myAttrs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        return this.myAttrs == ((TextAttributes)obj).myAttrs;
    }

    public int hashCode() {
        return this.myAttrs.hashCode();
    }

    public String toString() {
        return "[" + this.getForegroundColor() + "," + this.getBackgroundColor() + "," + this.getFontType() + "," + (Object)((Object)this.getEffectType()) + "," + this.getEffectColor() + "," + this.getErrorStripeColor() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesFlyweight";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/TextAttributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flyweight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlyweight";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromFlyweight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromFlyweight";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

