/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.InitializersLowering;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "shouldRemoveFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.jvm"})
final class InterfaceLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final JvmBackendContext context;

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        if (!IrUtilsKt.isInterface(irClass)) {
            return;
        }
        IrClass defaultImplsIrClass = this.context.getDeclarationFactory().getDefaultImplsClass(irClass);
        irClass.getDeclarations().add(defaultImplsIrClass);
        List<IrDeclaration> members = defaultImplsIrClass.getDeclarations();
        for (IrDeclaration function2 : irClass.getDeclarations()) {
            if (!(function2 instanceof IrSimpleFunction) || ((IrSimpleFunction)function2).getModality() == Modality.ABSTRACT || !(Intrinsics.areEqual(function2.getOrigin(), IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) ^ true)) continue;
            IrSimpleFunction element = this.context.getDeclarationFactory().getDefaultImplsFunction((IrSimpleFunction)function2);
            members.add(element);
            element.setBody(((IrSimpleFunction)function2).getBody());
            ((IrSimpleFunction)function2).setBody(null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, this);
        CollectionsKt.removeAll(irClass.getDeclarations(), (Function1)new Function1<IrDeclaration, Boolean>(this){
            final /* synthetic */ InterfaceLowering this$0;

            public final boolean invoke(@NotNull IrDeclaration it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return it instanceof IrFunction && InterfaceLowering.access$shouldRemoveFunction(this.this$0, (IrFunction)it);
            }
            {
                this.this$0 = interfaceLowering;
                super(1);
            }
        });
    }

    private final boolean shouldRemoveFunction(IrFunction function2) {
        return Visibilities.isPrivate(function2.getVisibility()) && Intrinsics.areEqual(function2.getName(), InitializersLowering.Companion.getClinitName()) ^ true || Intrinsics.areEqual(function2.getOrigin(), IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) || Intrinsics.areEqual(function2.getOrigin(), JvmLoweredDeclarationOrigin.SYNTHETIC_METHOD_FOR_PROPERTY_ANNOTATIONS.INSTANCE);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InterfaceLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.state = this.context.getState();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ boolean access$shouldRemoveFunction(InterfaceLowering $this, IrFunction function2) {
        return $this.shouldRemoveFunction(function2);
    }
}

