/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.interpretation;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.interpretation.ContractInterpretationDispatcher;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.functors.IsFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/contracts/interpretation/ConditionInterpreter;", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "", "dispatcher", "Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "(Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;)V", "constants", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstants;", "visitBooleanConstantDescriptor", "booleanConstantDescriptor", "Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanConstantReference;", "data", "(Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanConstantReference;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitBooleanVariableReference", "booleanVariableReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanVariableReference;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanVariableReference;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitLogicalAnd", "logicalAnd", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitLogicalOr", "logicalOr", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "resolution"})
public final class ConditionInterpreter
implements ContractDescriptionVisitor<ESExpression, Unit> {
    private final ESConstants constants;
    private final ContractInterpretationDispatcher dispatcher;

    @Override
    @Nullable
    public ESExpression visitLogicalOr(@NotNull LogicalOr logicalOr, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(logicalOr, "logicalOr");
        Intrinsics.checkParameterIsNotNull(data, "data");
        ESExpression eSExpression = (ESExpression)logicalOr.getLeft().accept(this, data);
        if (eSExpression == null) {
            return null;
        }
        ESExpression left = eSExpression;
        ESExpression eSExpression2 = (ESExpression)logicalOr.getRight().accept(this, data);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression right = eSExpression2;
        return new ESOr(this.constants, left, right);
    }

    @Override
    @Nullable
    public ESExpression visitLogicalAnd(@NotNull LogicalAnd logicalAnd, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(logicalAnd, "logicalAnd");
        Intrinsics.checkParameterIsNotNull(data, "data");
        ESExpression eSExpression = (ESExpression)logicalAnd.getLeft().accept(this, data);
        if (eSExpression == null) {
            return null;
        }
        ESExpression left = eSExpression;
        ESExpression eSExpression2 = (ESExpression)logicalAnd.getRight().accept(this, data);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression right = eSExpression2;
        return new ESAnd(this.constants, left, right);
    }

    @Override
    @Nullable
    public ESExpression visitLogicalNot(@NotNull LogicalNot logicalNot, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(logicalNot, "logicalNot");
        Intrinsics.checkParameterIsNotNull(data, "data");
        ESExpression eSExpression = (ESExpression)logicalNot.getArg().accept(this, data);
        if (eSExpression == null) {
            return null;
        }
        ESExpression arg = eSExpression;
        return new ESNot(this.constants, arg);
    }

    @Override
    @Nullable
    public ESExpression visitIsInstancePredicate(@NotNull IsInstancePredicate isInstancePredicate, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(isInstancePredicate, "isInstancePredicate");
        Intrinsics.checkParameterIsNotNull(data, "data");
        ESVariable eSVariable = this.dispatcher.interpretVariable$resolution(isInstancePredicate.getArg());
        if (eSVariable == null) {
            return null;
        }
        ESVariable esVariable = eSVariable;
        return new ESIs(esVariable, new IsFunctor(this.constants, isInstancePredicate.getType(), isInstancePredicate.isNegated()));
    }

    @Override
    @Nullable
    public ESExpression visitIsNullPredicate(@NotNull IsNullPredicate isNullPredicate, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(isNullPredicate, "isNullPredicate");
        Intrinsics.checkParameterIsNotNull(data, "data");
        ESVariable eSVariable = this.dispatcher.interpretVariable$resolution(isNullPredicate.getArg());
        if (eSVariable == null) {
            return null;
        }
        ESVariable variable2 = eSVariable;
        return new ESEqual(this.constants, variable2, this.constants.getNullValue(), isNullPredicate.isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitBooleanConstantDescriptor(@NotNull BooleanConstantReference booleanConstantDescriptor, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(booleanConstantDescriptor, "booleanConstantDescriptor");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return this.dispatcher.interpretConstant$resolution(booleanConstantDescriptor);
    }

    @Override
    @Nullable
    public ESExpression visitBooleanVariableReference(@NotNull BooleanVariableReference booleanVariableReference, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(booleanVariableReference, "booleanVariableReference");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return this.dispatcher.interpretVariable$resolution(booleanVariableReference);
    }

    public ConditionInterpreter(@NotNull ContractInterpretationDispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull(dispatcher, "dispatcher");
        this.dispatcher = dispatcher;
        this.constants = this.dispatcher.getComponents().getConstants();
    }

    @Override
    @Nullable
    public ESExpression visitContractDescriptionElement(@NotNull ContractDescriptionElement contractDescriptionElement, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(contractDescriptionElement, "contractDescriptionElement");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitContractDescriptionElement(this, contractDescriptionElement, data);
    }

    @Override
    @Nullable
    public ESExpression visitEffectDeclaration(@NotNull EffectDeclaration effectDeclaration, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(effectDeclaration, "effectDeclaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitEffectDeclaration(this, effectDeclaration, data);
    }

    @Override
    @Nullable
    public ESExpression visitConditionalEffectDeclaration(@NotNull ConditionalEffectDeclaration conditionalEffect, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(conditionalEffect, "conditionalEffect");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitConditionalEffectDeclaration(this, conditionalEffect, data);
    }

    @Override
    @Nullable
    public ESExpression visitReturnsEffectDeclaration(@NotNull ReturnsEffectDeclaration returnsEffect, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(returnsEffect, "returnsEffect");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitReturnsEffectDeclaration(this, returnsEffect, data);
    }

    @Override
    @Nullable
    public ESExpression visitCallsEffectDeclaration(@NotNull CallsEffectDeclaration callsEffect, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(callsEffect, "callsEffect");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitCallsEffectDeclaration(this, callsEffect, data);
    }

    @Override
    @Nullable
    public ESExpression visitBooleanExpression(@NotNull BooleanExpression booleanExpression, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(booleanExpression, "booleanExpression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitBooleanExpression(this, booleanExpression, data);
    }

    @Override
    @Nullable
    public ESExpression visitValue(@NotNull ContractDescriptionValue value, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitValue(this, value, data);
    }

    @Override
    @Nullable
    public ESExpression visitConstantDescriptor(@NotNull ConstantReference constantReference, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(constantReference, "constantReference");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitConstantDescriptor(this, constantReference, data);
    }

    @Override
    @Nullable
    public ESExpression visitVariableReference(@NotNull VariableReference variableReference, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(variableReference, "variableReference");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return ContractDescriptionVisitor.DefaultImpls.visitVariableReference(this, variableReference, data);
    }
}

