/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.spi.JavaPlatformManagerProvider;
import org.netbeans.modules.profiler.spi.JavaPlatformProvider;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class RunCalibrationAction
extends AbstractAction {
    private static final HelpCtx HELP_CTX = new HelpCtx("ManageCalibration.HelpCtx");

    public RunCalibrationAction() {
        this.putValue("Name", Bundle.LBL_RunCalibrationAction());
        this.putValue("ShortDescription", Bundle.HINT_RunCalibrationAction());
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List list = JavaPlatform.getPlatforms();
        Object[] objectArray = new String[]{Bundle.LBL_JavaPlatform(), Bundle.LBL_LastCalibrated()};
        Object[][] objectArray2 = new Object[list.size()][2];
        for (int i = 0; i < list.size(); ++i) {
            objectArray2[i] = new Object[]{list.get(i), null};
        }
        final DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunCalibrationAction.this.displayUI(defaultTableModel);
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                RunCalibrationAction.this.refreshTimes(defaultTableModel);
            }
        });
    }

    private void displayUI(TableModel tableModel) {
        final ProfilerTable profilerTable = new ProfilerTable(tableModel, false, true, null);
        profilerTable.getColumnModel().getColumn(1).setCellRenderer(new CalibrationDateCellRenderer());
        profilerTable.setDefaultColumnWidth(this.getColumnWidth());
        profilerTable.setSortColumn(0);
        profilerTable.setPreferredScrollableViewportSize(new Dimension(400, 10));
        profilerTable.setVisibleRows(6);
        profilerTable.setColumnToolTips(new String[]{Bundle.TTP_PlatformName(), Bundle.TTP_CalibrationDate()});
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(profilerTable, true, null);
        profilerTableContainer.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.LBL_JavaPlatformsForProfiling());
        jLabel.setLabelFor((Component)profilerTable);
        jLabel.setBorder(BorderFactory.createEmptyBorder(15, 10, 5, 10));
        final JButton jButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                RunCalibrationAction.this.calibrate(profilerTable);
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Bundle.LBL_Calibrate());
        JButton jButton2 = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                JavaPlatform.showCustomizer();
                RunCalibrationAction.this.refreshModel(profilerTable);
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)Bundle.LBL_JavaPlatforms());
        JPanel jPanel = new JPanel(new FlowLayout(3, 10, 10));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        profilerTable.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunCalibrationAction.this.calibrate(profilerTable);
            }
        });
        profilerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (profilerTable.getSelectedRow() != -1) {
                    boolean bl = RunCalibrationAction.isRemotePlatform((JavaPlatform)profilerTable.getValueAt(profilerTable.getSelectedRow(), profilerTable.convertColumnIndexToView(0)));
                    if (bl) {
                        jButton.setToolTipText(Bundle.HINT_CalibrateDisabled());
                    } else {
                        jButton.setToolTipText("");
                    }
                    jButton.setEnabled(!bl);
                }
            }
        });
        jButton.setEnabled(false);
        profilerTable.clearSelection();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)profilerTableContainer, "Center");
        jPanel2.add((Component)jPanel, "South");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel2, Bundle.HINT_RunCalibrationAction(), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, HELP_CTX, null);
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
    }

    private int getColumnWidth() {
        int n = new JLabel((String)new StringBuilder().append((String)Bundle.LBL_LastCalibrated()).append((String)"XXX").toString()).getPreferredSize().width;
        n = Math.max(n, new JLabel((String)new StringBuilder().append((String)Bundle.LBL_NotCalibrated()).append((String)"XXX").toString()).getPreferredSize().width);
        n = Math.max(n, new JLabel((String)new StringBuilder().append((String)DateFormat.getDateInstance().format((Date)new Date())).append((String)"XXX").toString()).getPreferredSize().width);
        n = Math.max(n, new JLabel((String)new StringBuilder().append((String)DateFormat.getTimeInstance().format((Date)new Date())).append((String)"XXX").toString()).getPreferredSize().width);
        return n;
    }

    private void refreshTimes(final TableModel tableModel) {
        int n = 0;
        while (n < tableModel.getRowCount()) {
            File file;
            JavaPlatform javaPlatform = (JavaPlatform)tableModel.getValueAt(n, 0);
            boolean bl = RunCalibrationAction.isRemotePlatform(javaPlatform);
            String string = javaPlatform.getPlatformJDKVersion();
            Long l = null;
            if (bl) {
                try {
                    file = new File(CalibrationDataFileIO.getCalibrationDataFileName((String)string) + "." + (String)javaPlatform.getProperties().get("platform.host"));
                    if (file.isFile()) {
                        l = file.lastModified();
                    }
                }
                catch (Exception exception) {}
            } else {
                try {
                    file = new File(CalibrationDataFileIO.getCalibrationDataFileName((String)string));
                    if (file.isFile()) {
                        l = file.lastModified();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            final int n2 = n++;
            final Long l2 = l;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tableModel.setValueAt(l2, n2, 1);
                }
            });
        }
    }

    private void refreshModel(ProfilerTable profilerTable) {
        JavaPlatform javaPlatform;
        JavaPlatform javaPlatform2 = null;
        HashSet<JavaPlatform> hashSet = new HashSet<JavaPlatform>();
        int n = profilerTable.getSelectedRow();
        int n2 = profilerTable.convertColumnIndexToView(0);
        for (int i = 0; i < profilerTable.getRowCount(); ++i) {
            javaPlatform = profilerTable.getValueAt(i, n2);
            hashSet.add(javaPlatform);
            if (i != n) continue;
            javaPlatform2 = javaPlatform;
        }
        final DefaultTableModel defaultTableModel = (DefaultTableModel)profilerTable.getModel();
        javaPlatform = defaultTableModel.getDataVector();
        javaPlatform.clear();
        for (JavaPlatform javaPlatform3 : JavaPlatform.getPlatforms()) {
            javaPlatform.add(new Vector<JavaPlatform>(Arrays.asList(javaPlatform3, null)));
            if (hashSet.contains(javaPlatform3)) continue;
            javaPlatform2 = javaPlatform3;
        }
        profilerTable.clearSelection();
        defaultTableModel.fireTableDataChanged();
        if (javaPlatform2 != null) {
            profilerTable.selectValue(javaPlatform2, n2, true);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                RunCalibrationAction.this.refreshTimes(defaultTableModel);
            }
        });
    }

    private void calibrate(ProfilerTable profilerTable) {
        int n = profilerTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        int n2 = profilerTable.convertColumnIndexToView(0);
        final JavaPlatform javaPlatform = (JavaPlatform)profilerTable.getValueAt(n, n2);
        final DefaultTableModel defaultTableModel = (DefaultTableModel)profilerTable.getModel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunCalibrationAction.this.calibrate(javaPlatform, defaultTableModel);
            }
        });
    }

    private static boolean isRemotePlatform(JavaPlatform javaPlatform) {
        JavaPlatformManagerProvider javaPlatformManagerProvider = (JavaPlatformManagerProvider)Lookup.getDefault().lookup(JavaPlatformManagerProvider.class);
        if (javaPlatformManagerProvider == null) {
            ProfilerUtils.getProfilerErrorManager().log(Level.WARNING.intValue(), "No instance of JavaPlatformManagerProvider found in Lookup");
            return false;
        }
        for (JavaPlatformProvider javaPlatformProvider : javaPlatformManagerProvider.getPlatforms()) {
            if (javaPlatform.getPlatformId() == null || !javaPlatform.getPlatformId().equals(javaPlatformProvider.getPlatformId()) || !javaPlatform.getProperties().containsKey("platform.host")) continue;
            return true;
        }
        return false;
    }

    private void calibrate(final JavaPlatform javaPlatform, final TableModel tableModel) {
        int n = Profiler.getDefault().getProfilingState();
        int n2 = Profiler.getDefault().getProfilingMode();
        boolean bl = false;
        boolean bl2 = false;
        if (n == 8 || n == 4) {
            if (n2 == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.MSG_CalibrationOnProfile(), (String)Bundle.CAPTION_Question())) {
                    return;
                }
                bl = true;
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.MSG_CalibrationOnAttach(), (String)Bundle.CAPTION_Question())) {
                    return;
                }
                bl2 = true;
            }
        }
        final boolean bl3 = bl2;
        final boolean bl4 = bl;
        ProfilerUtils.getProfilerRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (bl3) {
                    Profiler.getDefault().detachFromApp();
                } else if (bl4) {
                    Profiler.getDefault().stopApp();
                }
                boolean bl = Profiler.getDefault().runCalibration(false, javaPlatform.getPlatformJavaFile(), javaPlatform.getPlatformJDKVersion(), javaPlatform.getPlatformArchitecture());
                RunCalibrationAction.this.refreshTimes(tableModel);
                if (!bl) {
                    ProfilerDialogs.displayError((String)Bundle.MSG_CalibrationFailed());
                }
            }
        }, 0, 10);
    }

    private static class CalibrationDateCellRenderer
    extends DefaultTableCellRenderer {
        private static Calendar CALENDAR;
        private static int REF_DAY_OF_YEAR;
        private static int DAY_OF_YEAR;
        private static int YEAR;
        private static int ERA;
        private static Date DATE;
        private static DateFormat FORMAT_TIME;
        private static DateFormat FORMAT_DATE;

        CalibrationDateCellRenderer() {
            this.setHorizontalAlignment(11);
        }

        @Override
        protected void setValue(Object object) {
            if (object == null) {
                this.setText(Bundle.LBL_NotCalibrated());
            } else {
                long l = (Long)object;
                this.setValue(l, CalibrationDateCellRenderer.isToday(l));
            }
        }

        private void setValue(long l, boolean bl) {
            DateFormat dateFormat;
            if (bl) {
                if (FORMAT_TIME == null) {
                    FORMAT_TIME = DateFormat.getTimeInstance();
                }
                dateFormat = FORMAT_TIME;
            } else {
                if (FORMAT_DATE == null) {
                    FORMAT_DATE = DateFormat.getDateInstance();
                }
                dateFormat = FORMAT_DATE;
            }
            if (DATE == null) {
                DATE = new Date();
            }
            DATE.setTime(l);
            this.setText(dateFormat.format(DATE));
        }

        private static boolean isToday(long l) {
            if (REF_DAY_OF_YEAR != -1 && CALENDAR.get(6) != REF_DAY_OF_YEAR) {
                CALENDAR = null;
            }
            if (CALENDAR == null) {
                CalibrationDateCellRenderer.initializeCalendar();
            }
            CALENDAR.setTimeInMillis(l);
            return DAY_OF_YEAR == CALENDAR.get(6) && YEAR == CALENDAR.get(1) && ERA == CALENDAR.get(0);
        }

        private static void initializeCalendar() {
            CALENDAR = Calendar.getInstance();
            DAY_OF_YEAR = CALENDAR.get(6);
            YEAR = CALENDAR.get(1);
            ERA = CALENDAR.get(0);
            if (REF_DAY_OF_YEAR == -1) {
                REF_DAY_OF_YEAR = DAY_OF_YEAR;
            }
        }

        static {
            REF_DAY_OF_YEAR = -1;
            DAY_OF_YEAR = -1;
            YEAR = -1;
            ERA = -1;
        }
    }
}

