/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateUtilsRounding;
import org.joda.time.DateTimeZone;

public class DateUtils {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(DateFormatters.class));
    static final Map<String, String> DEPRECATED_SHORT_TIMEZONES;
    public static final Set<String> DEPRECATED_SHORT_TZ_IDS;
    private static final Instant MAX_NANOSECOND_INSTANT;

    public static DateTimeZone zoneIdToDateTimeZone(ZoneId zoneId) {
        if (zoneId == null) {
            return null;
        }
        if (zoneId instanceof ZoneOffset) {
            return DateTimeZone.forOffsetMillis((int)(((ZoneOffset)zoneId).getTotalSeconds() * 1000));
        }
        return DateTimeZone.forID((String)zoneId.getId());
    }

    public static ZoneId dateTimeZoneToZoneId(DateTimeZone timeZone) {
        if (timeZone == null) {
            return null;
        }
        if (DateTimeZone.UTC.equals((Object)timeZone)) {
            return ZoneOffset.UTC;
        }
        return DateUtils.of(timeZone.getID());
    }

    public static ZoneId of(String zoneId) {
        String deprecatedId = DEPRECATED_SHORT_TIMEZONES.get(zoneId);
        if (deprecatedId != null) {
            deprecationLogger.deprecatedAndMaybeLog("timezone", "Use of short timezone id " + zoneId + " is deprecated. Use " + deprecatedId + " instead", new Object[0]);
            return ZoneId.of(deprecatedId);
        }
        return ZoneId.of(zoneId).normalized();
    }

    public static long toLong(Instant instant) {
        if (instant.isBefore(Instant.EPOCH)) {
            throw new IllegalArgumentException("date[" + instant + "] is before the epoch in 1970 and cannot be stored in nanosecond resolution");
        }
        if (instant.isAfter(MAX_NANOSECOND_INSTANT)) {
            throw new IllegalArgumentException("date[" + instant + "] is after 2262-04-11T23:47:16.854775807 and cannot be stored in nanosecond resolution");
        }
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    public static Instant toInstant(long nanoSecondsSinceEpoch) {
        if (nanoSecondsSinceEpoch < 0L) {
            throw new IllegalArgumentException("nanoseconds are [" + nanoSecondsSinceEpoch + "] are before the epoch in 1970 and cannot be processed in nanosecond resolution");
        }
        if (nanoSecondsSinceEpoch == 0L) {
            return Instant.EPOCH;
        }
        long seconds = nanoSecondsSinceEpoch / 1000000000L;
        long nanos = nanoSecondsSinceEpoch % 1000000000L;
        return Instant.ofEpochSecond(seconds, nanos);
    }

    public static long toMilliSeconds(long nanoSecondsSinceEpoch) {
        if (nanoSecondsSinceEpoch < 0L) {
            throw new IllegalArgumentException("nanoseconds are [" + nanoSecondsSinceEpoch + "] are before the epoch in 1970 and will be converted to milliseconds");
        }
        if (nanoSecondsSinceEpoch == 0L) {
            return 0L;
        }
        return nanoSecondsSinceEpoch / 1000000L;
    }

    public static long roundFloor(long utcMillis, long unitMillis) {
        if (utcMillis >= 0L) {
            return utcMillis - utcMillis % unitMillis;
        }
        return ++utcMillis - utcMillis % unitMillis - unitMillis;
    }

    public static long roundQuarterOfYear(long utcMillis) {
        int year = DateUtilsRounding.getYear(utcMillis);
        int month = DateUtilsRounding.getMonthOfYear(utcMillis, year);
        int firstMonthOfQuarter = (month - 1) / 3 * 3 + 1;
        return DateUtils.of(year, firstMonthOfQuarter);
    }

    public static long roundMonthOfYear(long utcMillis) {
        int year = DateUtilsRounding.getYear(utcMillis);
        int month = DateUtilsRounding.getMonthOfYear(utcMillis, year);
        return DateUtils.of(year, month);
    }

    public static long roundYear(long utcMillis) {
        int year = DateUtilsRounding.getYear(utcMillis);
        return DateUtilsRounding.utcMillisAtStartOfYear(year);
    }

    public static long roundWeekOfWeekYear(long utcMillis) {
        return DateUtils.roundFloor(utcMillis + 259200000L, 604800000L) - 259200000L;
    }

    private static long of(int year, int month) {
        long millis = DateUtilsRounding.utcMillisAtStartOfYear(year);
        return millis += DateUtilsRounding.getTotalMillisByYearMonth(year, month);
    }

    public static ZonedDateTime nowWithMillisResolution() {
        return DateUtils.nowWithMillisResolution(Clock.systemUTC());
    }

    public static ZonedDateTime nowWithMillisResolution(Clock clock) {
        Clock millisResolutionClock = Clock.tick(clock, Duration.ofMillis(1L));
        return ZonedDateTime.now(millisResolutionClock);
    }

    static {
        HashMap<String, String> tzs = new HashMap<String, String>();
        tzs.put("EST", "-05:00");
        tzs.put("HST", "-10:00");
        tzs.put("MST", "-07:00");
        tzs.put("ROC", "Asia/Taipei");
        tzs.put("Eire", "Europe/London");
        DEPRECATED_SHORT_TIMEZONES = Collections.unmodifiableMap(tzs);
        DEPRECATED_SHORT_TZ_IDS = tzs.keySet();
        MAX_NANOSECOND_INSTANT = Instant.parse("2262-04-11T23:47:16.854775807Z");
    }
}

