/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.FreeColSeed;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.logging.DefaultHandler;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.FreeColServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class FreeCol {
    private static final Logger logger = Logger.getLogger(FreeCol.class.getName());
    private static final String FREECOL_VERSION = "0.11.6";
    public static final String[] DIFFICULTIES = new String[]{"veryEasy", "easy", "medium", "hard", "veryHard"};
    public static final String FREECOL_SAVE_EXTENSION = "fsg";
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final long MEMORY_MAX = Runtime.getRuntime().maxMemory();
    public static final String CLIENT_THREAD = "FreeColClient:";
    public static final String SERVER_THREAD = "FreeColServer:";
    public static final String METASERVER_THREAD = "FreeColMetaServer:";
    public static final String META_SERVER_ADDRESS = "meta.freecol.org";
    public static final int META_SERVER_PORT = 3540;
    private static String freeColRevision = null;
    private static Locale locale = null;
    private static final NationOptions.Advantages ADVANTAGES_DEFAULT = NationOptions.Advantages.SELECTABLE;
    private static final String DIFFICULTY_DEFAULT = "model.difficulty.medium";
    private static final int EUROPEANS_DEFAULT = 4;
    private static final int EUROPEANS_MIN = 1;
    private static final Level LOGLEVEL_DEFAULT = Level.INFO;
    private static final String JAVA_VERSION_MIN = "1.8";
    private static final int MEMORY_MIN = 128;
    private static final int PORT_DEFAULT = 3541;
    private static final String SPLASH_DEFAULT = "splash.jpg";
    private static final String TC_DEFAULT = "freecol";
    public static final int TIMEOUT_DEFAULT = 60;
    public static final int TIMEOUT_MIN = 10;
    private static final int GUI_SCALE_MIN_PCT = 100;
    private static final int GUI_SCALE_MAX_PCT = 200;
    private static final int GUI_SCALE_STEP_PCT = 25;
    public static final float GUI_SCALE_MIN = 1.0f;
    public static final float GUI_SCALE_MAX = 2.0f;
    public static final float GUI_SCALE_STEP = 0.25f;
    public static final float GUI_SCALE_DEFAULT = 1.0f;
    private static boolean checkIntegrity = false;
    private static boolean consoleLogging = false;
    private static boolean debugStart = false;
    private static boolean fastStart = false;
    private static boolean headless = false;
    private static boolean introVideo = true;
    private static boolean javaCheck = true;
    private static boolean memoryCheck = true;
    private static boolean publicServer = true;
    private static boolean sound = true;
    private static boolean standAloneServer = false;
    private static NationOptions.Advantages advantages = null;
    private static String difficulty = null;
    private static int europeanCount = 4;
    private static String fontName = null;
    private static Level logLevel = LOGLEVEL_DEFAULT;
    private static String name = null;
    private static int serverPort = -1;
    private static String serverName = null;
    private static InputStream splashStream;
    private static String tc;
    private static int timeout;
    private static Dimension windowSize;
    private static float guiScale;

    private FreeCol() {
    }

    public static void main(String[] args) {
        Locale clientLocale;
        String clientLanguage;
        Handler[] handlers;
        String localeArg;
        JarURLConnection juc;
        freeColRevision = FREECOL_VERSION;
        try {
            juc = FreeCol.getJarURLConnection(FreeCol.class);
        }
        catch (IOException ioe) {
            juc = null;
            System.err.println("Unable to open class jar: " + ioe.getMessage());
        }
        if (juc != null) {
            try {
                String revision = FreeCol.readVersion(juc);
                if (revision != null) {
                    freeColRevision = freeColRevision + " (Revision: " + revision + ")";
                }
            }
            catch (Exception e2) {
                System.err.println("Unable to load Manifest: " + e2.getMessage());
            }
            try {
                splashStream = FreeCol.getDefaultSplashStream(juc);
            }
            catch (Exception e3) {
                System.err.println("Unable to open default splash: " + e3.getMessage());
            }
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        String dataDirectoryArg = FreeCol.findArg("--freecol-data", args);
        String err = FreeColDirectories.setDataDirectory(dataDirectoryArg);
        if (err != null) {
            FreeCol.fatal(err);
        }
        if ((localeArg = FreeCol.findArg("--default-locale", args)) == null) {
            locale = Locale.getDefault();
        } else {
            int index = localeArg.indexOf(46);
            if (index > 0) {
                localeArg = localeArg.substring(0, index);
            }
            locale = Messages.getLocale(localeArg);
        }
        Messages.loadMessageBundle(locale);
        FreeCol.handleArgs(args);
        if (javaCheck && JAVA_VERSION_MIN.compareTo(JAVA_VERSION) > 0) {
            FreeCol.fatal(StringTemplate.template("main.javaVersion").addName("%version%", JAVA_VERSION).addName("%minVersion%", JAVA_VERSION_MIN));
        }
        if (memoryCheck && MEMORY_MAX < 128000000L) {
            FreeCol.fatal(StringTemplate.template("main.memory").addAmount("%memory%", MEMORY_MAX).addAmount("%minMemory%", 128));
        }
        String userMsg = FreeColDirectories.setUserDirectories();
        Logger baseLogger = Logger.getLogger("");
        for (Handler handler : handlers = baseLogger.getHandlers()) {
            baseLogger.removeHandler(handler);
        }
        String logFile = FreeColDirectories.getLogFilePath();
        try {
            baseLogger.addHandler(new DefaultHandler(consoleLogging, logFile));
            Logger freecolLogger = Logger.getLogger("net.sf.freecol");
            freecolLogger.setLevel(logLevel);
        }
        catch (FreeColException e4) {
            System.err.println("Logging initialization failure: " + e4.getMessage());
            e4.printStackTrace();
        }
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> baseLogger.log(Level.WARNING, "Uncaught exception from thread: " + thread, e));
        if (localeArg == null && (clientLanguage = ClientOptions.getLanguageOption()) != null && !"automatic".equalsIgnoreCase(clientLanguage) && (clientLocale = Messages.getLocale(clientLanguage)) != locale) {
            locale = clientLocale;
            Messages.loadMessageBundle(locale);
            logger.info("Loaded messages for " + locale);
        }
        Mods.loadMods();
        Messages.loadModMessageBundle(locale);
        if (userMsg != null) {
            logger.info(Messages.message(userMsg));
        }
        logger.info(FreeCol.getConfiguration().toString());
        if (standAloneServer) {
            FreeCol.startServer();
        } else {
            FreeCol.startClient(userMsg);
        }
    }

    private static JarURLConnection getJarURLConnection(Class c) throws IOException {
        String resourceName = "/" + c.getName().replace('.', '/') + ".class";
        URL url = c.getResource(resourceName);
        return (JarURLConnection)url.openConnection();
    }

    private static String readVersion(JarURLConnection juc) throws IOException {
        Manifest mf = juc.getManifest();
        return mf == null ? null : mf.getMainAttributes().getValue("Package-Version");
    }

    private static InputStream getDefaultSplashStream(JarURLConnection juc) throws IOException {
        JarFile jf = juc.getJarFile();
        ZipEntry ze = jf.getEntry(SPLASH_DEFAULT);
        return jf.getInputStream(ze);
    }

    public static void fatal(StringTemplate template) {
        FreeCol.fatal(Messages.message(template));
    }

    public static void fatal(String err) {
        if (err == null || err.isEmpty()) {
            err = "Bogus null fatal error message";
            Thread.dumpStack();
        }
        System.err.println(err);
        System.exit(1);
    }

    public static void gripe(StringTemplate template) {
        System.err.println(Messages.message(template));
    }

    public static void gripe(String key) {
        System.err.println(Messages.message(key));
    }

    private static String findArg(String option, String[] args) {
        for (int i = args.length - 2; i >= 0; --i) {
            if (!option.equals(args[i])) continue;
            return args[i + 1];
        }
        return null;
    }

    private static void handleArgs(String[] args) {
        Options options = new Options();
        String help = Messages.message("cli.help");
        File dummy = new File("dummy");
        String argDirectory = Messages.message("cli.arg.directory");
        OptionBuilder.withLongOpt((String)"usage");
        OptionBuilder.withDescription((String)help);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)help);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"freecol-data");
        OptionBuilder.withDescription((String)Messages.message("cli.freecol-data"));
        OptionBuilder.withArgName((String)argDirectory);
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"default-locale");
        OptionBuilder.withDescription((String)Messages.message("cli.default-locale"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.locale"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"advantages");
        OptionBuilder.withDescription((String)Messages.message(StringTemplate.template("cli.advantages").addName("%advantages%", FreeCol.getValidAdvantages())));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.advantages"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"check-savegame");
        OptionBuilder.withDescription((String)Messages.message("cli.check-savegame"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.file"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"clientOptions");
        OptionBuilder.withDescription((String)Messages.message("cli.clientOptions"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.clientOptions"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)Messages.message(StringTemplate.template("cli.debug").addName("%modes%", FreeColDebugger.getDebugModes())));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.debug"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"debug-run");
        OptionBuilder.withDescription((String)Messages.message("cli.debug-run"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.debugRun"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"debug-start");
        OptionBuilder.withDescription((String)Messages.message("cli.debug-start"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"difficulty");
        OptionBuilder.withDescription((String)Messages.message("cli.difficulty"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.difficulty"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"europeans");
        OptionBuilder.withDescription((String)Messages.message("cli.european-count"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.europeans"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"fast");
        OptionBuilder.withDescription((String)Messages.message("cli.fast"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"font");
        OptionBuilder.withDescription((String)Messages.message("cli.font"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.font"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"full-screen");
        OptionBuilder.withDescription((String)Messages.message("cli.full-screen"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"gui-scale");
        OptionBuilder.withDescription((String)Messages.message(StringTemplate.template("cli.gui-scale").addName("%scales%", FreeCol.getValidGUIScales())));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.gui-scale"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"headless");
        OptionBuilder.withDescription((String)Messages.message("cli.headless"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"load-savegame");
        OptionBuilder.withDescription((String)Messages.message("cli.load-savegame"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.file"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"log-console");
        OptionBuilder.withDescription((String)Messages.message("cli.log-console"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"log-file");
        OptionBuilder.withDescription((String)Messages.message("cli.log-file"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.name"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"log-level");
        OptionBuilder.withDescription((String)Messages.message("cli.log-level"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.loglevel"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"name");
        OptionBuilder.withDescription((String)Messages.message("cli.name"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.name"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-intro");
        OptionBuilder.withDescription((String)Messages.message("cli.no-intro"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-java-check");
        OptionBuilder.withDescription((String)Messages.message("cli.no-java-check"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-memory-check");
        OptionBuilder.withDescription((String)Messages.message("cli.no-memory-check"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-sound");
        OptionBuilder.withDescription((String)Messages.message("cli.no-sound"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-splash");
        OptionBuilder.withDescription((String)Messages.message("cli.no-splash"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"private");
        OptionBuilder.withDescription((String)Messages.message("cli.private"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"seed");
        OptionBuilder.withDescription((String)Messages.message("cli.seed"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.seed"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"server");
        OptionBuilder.withDescription((String)Messages.message("cli.server"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"server-name");
        OptionBuilder.withDescription((String)Messages.message("cli.server-name"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.name"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"server-port");
        OptionBuilder.withDescription((String)Messages.message("cli.server-port"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.port"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"splash");
        OptionBuilder.withDescription((String)Messages.message("cli.splash"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.file"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"tc");
        OptionBuilder.withDescription((String)Messages.message("cli.tc"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.name"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"timeout");
        OptionBuilder.withDescription((String)Messages.message("cli.timeout"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.timeout"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"user-cache-directory");
        OptionBuilder.withDescription((String)Messages.message("cli.user-cache-directory"));
        OptionBuilder.withArgName((String)argDirectory);
        OptionBuilder.withType((Object)dummy);
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"user-config-directory");
        OptionBuilder.withDescription((String)Messages.message("cli.user-config-directory"));
        OptionBuilder.withArgName((String)argDirectory);
        OptionBuilder.withType((Object)dummy);
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"user-data-directory");
        OptionBuilder.withDescription((String)Messages.message("cli.user-data-directory"));
        OptionBuilder.withArgName((String)argDirectory);
        OptionBuilder.withType((Object)dummy);
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)Messages.message("cli.version"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"windowed");
        OptionBuilder.withDescription((String)Messages.message("cli.windowed"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.dimensions"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        PosixParser parser = new PosixParser();
        boolean usageError = false;
        try {
            String errMsg;
            int e;
            String difficulty;
            String fileName;
            String arg;
            NationOptions.Advantages a;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help") || line.hasOption("usage")) {
                FreeCol.printUsage(options, 0);
            }
            if (line.hasOption("default-locale")) {
                // empty if block
            }
            if (line.hasOption("freecol-data")) {
                // empty if block
            }
            if (line.hasOption("advantages") && (a = FreeCol.selectAdvantages(arg = line.getOptionValue("advantages"))) == null) {
                FreeCol.fatal(StringTemplate.template("cli.error.advantages").addName("%advantages%", FreeCol.getValidAdvantages()).addName("%arg%", arg));
            }
            if (line.hasOption("check-savegame")) {
                arg = line.getOptionValue("check-savegame");
                if (!FreeColDirectories.setSavegameFile(arg)) {
                    FreeCol.fatal(StringTemplate.template("cli.err.save").addName("%string%", arg));
                }
                checkIntegrity = true;
                standAloneServer = true;
            }
            if (line.hasOption("clientOptions") && !FreeColDirectories.setClientOptionsFile(fileName = line.getOptionValue("clientOptions"))) {
                FreeCol.gripe(StringTemplate.template("cli.error.clientOptions").addName("%string%", fileName));
            }
            if (line.hasOption("debug")) {
                arg = line.getOptionValue("debug");
                if (arg == null || arg.isEmpty()) {
                    arg = FreeColDebugger.DebugMode.MENUS.toString();
                }
                if (!FreeColDebugger.setDebugModes(arg)) {
                    FreeCol.gripe(StringTemplate.template("cli.error.debug").addName("%modes%", FreeColDebugger.getDebugModes()));
                }
                if (!line.hasOption("log-level")) {
                    logLevel = Level.FINEST;
                }
            }
            if (line.hasOption("debug-run")) {
                FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
                FreeColDebugger.configureDebugRun(line.getOptionValue("debug-run"));
            }
            if (line.hasOption("debug-start")) {
                debugStart = true;
                FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
            }
            if (line.hasOption("difficulty") && (difficulty = FreeCol.selectDifficulty(arg = line.getOptionValue("difficulty"))) == null) {
                FreeCol.fatal(StringTemplate.template("cli.error.difficulties").addName("%difficulties%", FreeCol.getValidDifficulties()).addName("%arg%", arg));
            }
            if (line.hasOption("europeans") && (e = FreeCol.selectEuropeanCount(line.getOptionValue("europeans"))) < 0) {
                FreeCol.gripe(StringTemplate.template("cli.error.europeans").addAmount("%min%", 1));
            }
            if (line.hasOption("fast")) {
                fastStart = true;
                introVideo = false;
            }
            if (line.hasOption("font")) {
                fontName = line.getOptionValue("font");
            }
            if (line.hasOption("full-screen")) {
                windowSize = null;
            }
            if (line.hasOption("gui-scale") && !FreeCol.setGUIScale(arg = line.getOptionValue("gui-scale"))) {
                FreeCol.gripe(StringTemplate.template("cli.error.gui-scale").addName("%scales%", FreeCol.getValidGUIScales()).addName("%arg%", arg));
            }
            if (line.hasOption("headless")) {
                headless = true;
            }
            if (line.hasOption("load-savegame") && !FreeColDirectories.setSavegameFile(arg = line.getOptionValue("load-savegame"))) {
                FreeCol.fatal(StringTemplate.template("cli.error.save").addName("%string%", arg));
            }
            if (line.hasOption("log-console")) {
                consoleLogging = true;
            }
            if (line.hasOption("log-file")) {
                FreeColDirectories.setLogFilePath(line.getOptionValue("log-file"));
            }
            if (line.hasOption("log-level")) {
                FreeCol.setLogLevel(line.getOptionValue("log-level"));
            }
            if (line.hasOption("name")) {
                FreeCol.setName(line.getOptionValue("name"));
            }
            if (line.hasOption("no-intro")) {
                introVideo = false;
            }
            if (line.hasOption("no-java-check")) {
                javaCheck = false;
            }
            if (line.hasOption("no-memory-check")) {
                memoryCheck = false;
            }
            if (line.hasOption("no-sound")) {
                sound = false;
            }
            if (line.hasOption("no-splash")) {
                splashStream = null;
            }
            if (line.hasOption("private")) {
                publicServer = false;
            }
            if (line.hasOption("server")) {
                standAloneServer = true;
            }
            if (line.hasOption("server-name")) {
                serverName = line.getOptionValue("server-name");
            }
            if (line.hasOption("server-port") && !FreeCol.setServerPort(arg = line.getOptionValue("server-port"))) {
                FreeCol.fatal(StringTemplate.template("cli.error.serverPort").addName("%string%", arg));
            }
            if (line.hasOption("seed")) {
                FreeColSeed.setFreeColSeed(line.getOptionValue("seed"));
            }
            if (line.hasOption("splash")) {
                String splash = line.getOptionValue("splash");
                try {
                    FileInputStream fis = new FileInputStream(splash);
                    splashStream = fis;
                }
                catch (FileNotFoundException fnfe) {
                    FreeCol.gripe(StringTemplate.template("cli.error.splash").addName("%name%", splash));
                }
            }
            if (line.hasOption("tc")) {
                FreeCol.setTC(line.getOptionValue("tc"));
            }
            if (line.hasOption("timeout") && !FreeCol.setTimeout(arg = line.getOptionValue("timeout"))) {
                FreeCol.gripe(StringTemplate.template("cli.error.timeout").addName("%string%", arg).addName("%minimum%", Integer.toString(10)));
            }
            if (line.hasOption("user-cache-directory") && (errMsg = FreeColDirectories.setUserCacheDirectory(arg = line.getOptionValue("user-cache-directory"))) != null) {
                FreeCol.gripe(StringTemplate.template(errMsg).addName("%string%", arg));
            }
            if (line.hasOption("user-config-directory") && (errMsg = FreeColDirectories.setUserConfigDirectory(arg = line.getOptionValue("user-config-directory"))) != null) {
                FreeCol.gripe(StringTemplate.template(errMsg).addName("%string%", arg));
            }
            if (line.hasOption("user-data-directory") && (errMsg = FreeColDirectories.setUserDataDirectory(arg = line.getOptionValue("user-data-directory"))) != null) {
                FreeCol.fatal(StringTemplate.template(errMsg).addName("%string%", arg));
            }
            if (line.hasOption("version")) {
                System.out.println("FreeCol " + FreeCol.getVersion());
                System.exit(0);
            }
            if (line.hasOption("windowed")) {
                arg = line.getOptionValue("windowed");
                FreeCol.setWindowSize(arg);
            }
        }
        catch (ParseException e) {
            System.err.println("\n" + e.getMessage() + "\n");
            usageError = true;
        }
        if (usageError) {
            FreeCol.printUsage(options, 1);
        }
    }

    private static void printUsage(Options options, int status) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -Xmx 256M -jar freecol.jar [OPTIONS]", options);
        System.exit(status);
    }

    public static Specification loadSpecification(FreeColTcFile tcf, NationOptions.Advantages advantages, String difficulty) {
        Specification spec = null;
        try {
            if (tcf != null) {
                spec = tcf.getSpecification();
            }
        }
        catch (IOException ioe) {
            System.err.println("Spec read failed in " + tcf.getId() + ": " + ioe.getMessage() + "\n");
        }
        if (spec != null) {
            spec.prepare(advantages, difficulty);
        }
        return spec;
    }

    private static Specification getTCSpecification() {
        Specification spec = FreeCol.loadSpecification(FreeCol.getTCFile(), FreeCol.getAdvantages(), FreeCol.getDifficulty());
        if (spec == null) {
            FreeCol.fatal(StringTemplate.template("cli.error.badTC").addName("%tc%", FreeCol.getTC()));
        }
        return spec;
    }

    public static NationOptions.Advantages getAdvantages() {
        return advantages == null ? ADVANTAGES_DEFAULT : advantages;
    }

    private static NationOptions.Advantages selectAdvantages(String advantages) {
        NationOptions.Advantages adv = CollectionUtils.find(NationOptions.Advantages.values(), a -> Messages.getName(a).equals(advantages), null);
        if (adv != null) {
            FreeCol.setAdvantages(adv);
        }
        return adv;
    }

    public static void setAdvantages(NationOptions.Advantages advantages) {
        FreeCol.advantages = advantages;
    }

    private static String getValidAdvantages() {
        return Arrays.stream(NationOptions.Advantages.values()).map(a -> Messages.getName(a)).collect(Collectors.joining(","));
    }

    public static String getDifficulty() {
        return difficulty == null ? DIFFICULTY_DEFAULT : difficulty;
    }

    public static String selectDifficulty(String arg) {
        String difficulty = CollectionUtils.find(CollectionUtils.map(DIFFICULTIES, d -> "model.difficulty." + d), k -> Messages.getName(k).equals(arg), null);
        if (difficulty != null) {
            FreeCol.setDifficulty(difficulty);
        }
        return difficulty;
    }

    public static void setDifficulty(OptionGroup difficulty) {
        FreeCol.setDifficulty(difficulty.getId());
    }

    public static void setDifficulty(String difficulty) {
        FreeCol.difficulty = difficulty;
    }

    public static String getValidDifficulties() {
        return Arrays.stream(DIFFICULTIES).map(d -> Messages.getName("model.difficulty." + d)).collect(Collectors.joining(","));
    }

    public static int getEuropeanCount() {
        return europeanCount;
    }

    public static void setEuropeanCount(int n) {
        europeanCount = n;
    }

    public static boolean setGUIScale(String arg) {
        boolean valid = true;
        if (arg == null) {
            guiScale = 2.0f;
        } else {
            try {
                int n = Integer.parseInt(arg);
                if (n < 100) {
                    valid = false;
                    n = 100;
                } else if (n > 200) {
                    valid = false;
                    n = 200;
                } else if (n % 25 != 0) {
                    valid = false;
                }
                guiScale = (float)(n / 25) * 0.25f;
            }
            catch (NumberFormatException nfe) {
                valid = false;
                guiScale = 2.0f;
            }
        }
        return valid;
    }

    public static String getValidGUIScales() {
        String result = "";
        for (int i = 100; i < 200; i += 25) {
            result = result + i + ",";
        }
        result = result + 200;
        return result;
    }

    public static int selectEuropeanCount(String arg) {
        try {
            int n = Integer.parseInt(arg);
            if (n >= 1) {
                FreeCol.setEuropeanCount(n);
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static void setLogLevel(String arg) {
        logLevel = Level.parse(arg.toUpperCase());
    }

    public static String getName() {
        return name != null ? name : System.getProperty("user.name", Messages.message("main.defaultPlayerName"));
    }

    public static void setName(String name) {
        FreeCol.name = name;
        logger.info("Set FreeCol.name = " + name);
    }

    public static Locale getLocale() {
        return locale;
    }

    public static String getRevision() {
        return freeColRevision;
    }

    public static String getServerHost() {
        return InetAddress.getLoopbackAddress().getHostAddress();
    }

    public static int getServerPort() {
        return serverPort < 0 ? 3541 : serverPort;
    }

    public static boolean setServerPort(String arg) {
        if (arg == null) {
            return false;
        }
        try {
            serverPort = Integer.parseInt(arg);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static String getTC() {
        return tc == null ? TC_DEFAULT : tc;
    }

    public static void setTC(String tc) {
        FreeCol.tc = tc;
    }

    public static FreeColTcFile getTCFile() {
        try {
            return new FreeColTcFile(FreeCol.getTC());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static int getTimeout(boolean singlePlayer) {
        return timeout >= 10 ? timeout : (singlePlayer ? Integer.MAX_VALUE : 60);
    }

    public static boolean setTimeout(String timeout) {
        try {
            int result = Integer.parseInt(timeout);
            if (result >= 10) {
                FreeCol.timeout = result;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static String getVersion() {
        return FREECOL_VERSION;
    }

    private static void setWindowSize(String arg) {
        String[] xy;
        if (arg != null && (xy = arg.split("[^0-9]")) != null && xy.length == 2) {
            try {
                windowSize = new Dimension(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (windowSize == null) {
            windowSize = new Dimension(-1, -1);
        }
    }

    public static StringTemplate badLoad(File file) {
        return StringTemplate.template("error.couldNotLoad").addName("%name%", file.getPath());
    }

    public static StringTemplate badSave(File file) {
        return StringTemplate.template("error.couldNotSave").addName("%name%", file.getPath());
    }

    public static StringBuilder getConfiguration() {
        File autosave = FreeColDirectories.getAutosaveDirectory();
        File clientOptionsFile = FreeColDirectories.getClientOptionsFile();
        File save = FreeColDirectories.getSaveDirectory();
        File userConfig = FreeColDirectories.getUserConfigDirectory();
        File userData = FreeColDirectories.getUserDataDirectory();
        File userMods = FreeColDirectories.getUserModsDirectory();
        StringBuilder sb = new StringBuilder(256);
        sb.append("Configuration:").append("\n  version     ").append(FreeCol.getRevision()).append("\n  java:       ").append(JAVA_VERSION).append("\n  memory:     ").append(MEMORY_MAX).append("\n  locale:     ").append(locale).append("\n  data:       ").append(FreeColDirectories.getDataDirectory().getPath()).append("\n  userConfig: ").append(userConfig == null ? "NONE" : userConfig.getPath()).append("\n  userData:   ").append(userData == null ? "NONE" : userData.getPath()).append("\n  autosave:   ").append(autosave == null ? "NONE" : autosave.getPath()).append("\n  logFile:    ").append(FreeColDirectories.getLogFilePath()).append("\n  options:    ").append(clientOptionsFile == null ? "NONE" : clientOptionsFile.getPath()).append("\n  save:       ").append(save == null ? "NONE" : save.getPath()).append("\n  userMods:   ").append(userMods == null ? "NONE" : userMods.getPath());
        return sb;
    }

    private static void startClient(String userMsg) {
        Specification spec = null;
        File savegame = FreeColDirectories.getSavegameFile();
        if (debugStart) {
            spec = FreeCol.getTCSpecification();
        } else if (fastStart && savegame == null && (savegame = FreeColDirectories.getLastSaveGameFile()) == null) {
            spec = FreeCol.getTCSpecification();
        }
        FreeColClient freeColClient = new FreeColClient(splashStream, fontName, guiScale, headless);
        freeColClient.startClient(windowSize, userMsg, sound, introVideo, savegame, spec);
    }

    /*
     * Unable to fully structure code
     */
    private static void startServer() {
        FreeCol.logger.info("Starting stand-alone server.");
        saveGame = FreeColDirectories.getSavegameFile();
        if (saveGame != null) {
            try {
                fis = new FreeColSavegameFile(saveGame);
                freeColServer = new FreeColServer(fis, null, FreeCol.serverPort, FreeCol.serverName);
                if (!FreeCol.checkIntegrity) ** GOTO lbl26
                integrityOK = freeColServer.getIntegrity() > 0;
                FreeCol.gripe(integrityOK != false ? "cli.check-savegame.success" : "cli.check-savegame.failure");
                System.exit(integrityOK != false ? 0 : 2);
            }
            catch (Exception e) {
                if (FreeCol.checkIntegrity) {
                    FreeCol.gripe("cli.check-savegame.failure");
                }
                FreeCol.fatal(Messages.message(FreeCol.badLoad(saveGame)) + ": " + e.getMessage());
                return;
            }
        } else {
            spec = FreeCol.getTCSpecification();
            try {
                freeColServer = new FreeColServer(FreeCol.publicServer, false, spec, FreeCol.serverPort, FreeCol.serverName);
            }
            catch (Exception e) {
                FreeCol.fatal(Messages.message("server.initialize") + ": " + e.getMessage());
                return;
            }
            if (FreeCol.publicServer && freeColServer != null && !freeColServer.getPublicServer()) {
                FreeCol.gripe(Messages.message("server.noRouteToServer"));
            }
        }
lbl26:
        // 5 sources

        quit = "FreeColServer:Quit Game";
        Runtime.getRuntime().addShutdownHook(new Thread(quit){

            @Override
            public void run() {
                freeColServer.getController().shutdown();
            }
        });
    }

    static {
        tc = null;
        timeout = -1;
        windowSize = new Dimension(-1, -1);
        guiScale = 1.0f;
    }
}

