/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractOption;

public class UnitTypeOption
extends AbstractOption<UnitType> {
    private static final Logger logger = Logger.getLogger(UnitTypeOption.class.getName());
    private UnitType value;
    private boolean addNone;
    private TypeSelector selector = TypeSelector.UNITS;
    private final List<UnitType> choices = new ArrayList<UnitType>();
    private static final String ADD_NONE_TAG = "addNone";
    private static final String CHOICE_TAG = "choice";
    private static final String GENERATE_TAG = "generate";

    public UnitTypeOption(Specification specification) {
        super(specification);
    }

    public UnitTypeOption(String id, Specification specification) {
        super(id, specification);
    }

    public final boolean addNone() {
        return this.addNone;
    }

    public final List<UnitType> getChoices() {
        return this.choices;
    }

    public final TypeSelector getGenerateChoices() {
        return this.selector;
    }

    @Override
    public UnitTypeOption clone() {
        UnitTypeOption result = new UnitTypeOption(this.getId(), this.getSpecification());
        result.value = this.value;
        result.addNone = this.addNone;
        result.selector = this.selector;
        result.generateChoices();
        result.isDefined = true;
        return result;
    }

    @Override
    public UnitType getValue() {
        return this.value;
    }

    @Override
    public void setValue(UnitType value) {
        UnitType oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        if (valueString != null) {
            this.setValue(this.getSpecification().getUnitType(valueString));
        } else if (defaultValueString != null) {
            this.setValue(this.getSpecification().getUnitType(defaultValueString));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    public void generateChoices() {
        if (this.selector == null) {
            this.choices.add(this.getValue());
        } else {
            List<UnitType> unitTypeList = this.getSpecification().getUnitTypeList();
            this.choices.clear();
            switch (this.selector) {
                case UNITS: {
                    this.choices.addAll(unitTypeList);
                    break;
                }
                case IMMIGRANTS: {
                    for (UnitType unitType : unitTypeList) {
                        if (!unitType.isRecruitable()) continue;
                        this.choices.add(unitType);
                    }
                    break;
                }
                case NAVAL_UNITS: {
                    for (UnitType unitType : unitTypeList) {
                        if (!unitType.hasAbility("model.ability.navalUnit")) continue;
                        this.choices.add(unitType);
                    }
                    break;
                }
                case LAND_UNITS: {
                    for (UnitType unitType : unitTypeList) {
                        if (unitType.hasAbility("model.ability.navalUnit")) continue;
                        this.choices.add(unitType);
                    }
                    break;
                }
            }
            if (this.addNone) {
                this.choices.add(0, null);
            }
        }
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.value != null) {
            xw.writeAttribute("value", this.value);
        }
        if (this.selector != null) {
            xw.writeAttribute(GENERATE_TAG, this.selector);
        }
        if (this.addNone) {
            xw.writeAttribute(ADD_NONE_TAG, this.addNone);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.choices != null && !this.choices.isEmpty()) {
            for (UnitType choice : this.choices) {
                xw.writeStartElement(CHOICE_TAG);
                xw.writeAttribute("value", choice);
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.selector = xr.getAttribute(GENERATE_TAG, TypeSelector.class, null);
        this.addNone = xr.getAttribute(ADD_NONE_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.choices.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (CHOICE_TAG.equals(tag)) {
            this.choices.add(xr.getType(spec, "value", UnitType.class, null));
            xr.closeTag(CHOICE_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(this.getId()).append(" value=").append(this.value).append(" addNone=").append(this.addNone).append(" selector=").append((Object)this.selector).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return UnitTypeOption.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "unitTypeOption";
    }

    public static enum TypeSelector {
        UNITS,
        IMMIGRANTS,
        LAND_UNITS,
        NAVAL_UNITS;

    }
}

