/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.server.FreeColServer;

public class MapConverter {
    public static void main(String[] args) throws Exception {
        Specification specification = new FreeColTcFile("freecol").getSpecification();
        for (String filename : args) {
            File out = new File(filename);
            if (!out.exists()) continue;
            try {
                String newName = filename + ".old";
                File in = new File(newName);
                out.renameTo(in);
                System.out.println("Renamed " + filename + " to " + newName + ".");
                FreeColSavegameFile savegame = new FreeColSavegameFile(in);
                BufferedImage thumbnail = null;
                try {
                    thumbnail = ImageIO.read(savegame.getInputStream("thumbnail.png"));
                    System.out.println("Loaded thumbnail.");
                }
                catch (FileNotFoundException e) {
                    System.out.println("No thumbnail present.");
                }
                FreeColServer server = new FreeColServer(savegame, specification, FreeCol.getServerPort(), "mapTransformer");
                System.out.println("Started server.");
                server.saveGame(out, null, thumbnail);
                System.out.println("Saved updated savegame.");
                server.shutdown();
                System.out.println("Shut down server.");
            }
            catch (IOException | XMLStreamException | FreeColException e) {
                System.out.println(e);
            }
        }
    }
}

