/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin.dynamic;

import javax.swing.JPanel;
import org.gephi.statistics.plugin.dynamic.DynamicNbNodes;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.dynamic.DynamicNbNodesPanel;
import org.openide.util.NbBundle;

public class DynamicNbNodesUI
implements StatisticsUI {
    private final StatSettings settings = new StatSettings();
    private DynamicNbNodes nbNodes;
    private DynamicNbNodesPanel panel;

    public JPanel getSettingsPanel() {
        this.panel = new DynamicNbNodesPanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.nbNodes = (DynamicNbNodes)statistics;
        if (this.panel != null) {
            this.settings.load(this.nbNodes);
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.settings.save(this.nbNodes);
        }
        this.nbNodes = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return DynamicNbNodes.class;
    }

    public String getValue() {
        return "";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"DynamicNbNodesUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_DYNAMIC;
    }

    public int getPosition() {
        return 100;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"DynamicNbNodesUI.shortDescription");
    }

    private static class StatSettings {
        private double window = 0.0;
        private double tick = 0.0;

        private StatSettings() {
        }

        private void save(DynamicNbNodes stat) {
            this.window = stat.getWindow();
            this.tick = stat.getTick();
        }

        private void load(DynamicNbNodes stat) {
            stat.setWindow(this.window);
            stat.setTick(this.tick);
        }
    }
}

