/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.io;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.io.SocketConnection;
import com.mysql.cj.api.io.SocketFactory;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.FeatureNotAvailableException;
import com.mysql.cj.core.exceptions.RSAException;
import com.mysql.cj.core.exceptions.SSLParamsException;
import com.mysql.cj.core.util.Base64Decoder;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ExportControlled {
    public static boolean enabled() {
        return true;
    }

    public static void transformSocketToSSLSocket(SocketConnection socketConnection, ServerVersion serverVersion) throws IOException, SSLParamsException, FeatureNotAvailableException {
        boolean overrideCiphers;
        String[] stringArray;
        StandardSSLSocketFactory sslFact = new StandardSSLSocketFactory(ExportControlled.getSSLSocketFactoryDefaultOrConfigured(socketConnection.getPropertySet(), socketConnection.getExceptionInterceptor()), socketConnection.getSocketFactory(), socketConnection.getMysqlSocket());
        socketConnection.setMysqlSocket(sslFact.connect(socketConnection.getHost(), socketConnection.getPort(), null, 0));
        ArrayList<String> allowedProtocols = new ArrayList<String>();
        List<String> supportedProtocols = Arrays.asList(((SSLSocket)socketConnection.getMysqlSocket()).getSupportedProtocols());
        if (serverVersion.meetsMinimum(ServerVersion.parseVersion("5.6.0")) && Util.isEnterpriseEdition(serverVersion.toString())) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "TLSv1.2";
            stringArray2[1] = "TLSv1.1";
            stringArray = stringArray2;
            stringArray2[2] = "TLSv1";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "TLSv1.1";
            stringArray = stringArray3;
            stringArray3[1] = "TLSv1";
        }
        for (String protocol : stringArray) {
            if (!supportedProtocols.contains(protocol)) continue;
            allowedProtocols.add(protocol);
        }
        ((SSLSocket)socketConnection.getMysqlSocket()).setEnabledProtocols(allowedProtocols.toArray(new String[0]));
        String enabledSSLCipherSuites = socketConnection.getPropertySet().getStringReadableProperty("enabledSSLCipherSuites").getValue();
        boolean bl = overrideCiphers = enabledSSLCipherSuites != null && enabledSSLCipherSuites.length() > 0;
        if (overrideCiphers) {
            ArrayList<String> allowedCiphers = new ArrayList<String>();
            List<String> availableCiphers = Arrays.asList(((SSLSocket)socketConnection.getMysqlSocket()).getEnabledCipherSuites());
            for (String cipher : enabledSSLCipherSuites.split("\\s*,\\s*")) {
                if (!availableCiphers.contains(cipher)) continue;
                allowedCiphers.add(cipher);
            }
            ((SSLSocket)socketConnection.getMysqlSocket()).setEnabledCipherSuites(allowedCiphers.toArray(new String[0]));
        } else if (!(serverVersion.meetsMinimum(ServerVersion.parseVersion("5.7.6")) || serverVersion.meetsMinimum(ServerVersion.parseVersion("5.6.26")) && !serverVersion.meetsMinimum(ServerVersion.parseVersion("5.7.0")) || serverVersion.meetsMinimum(ServerVersion.parseVersion("5.5.45")) && !serverVersion.meetsMinimum(ServerVersion.parseVersion("5.6.0")))) {
            ArrayList<String> allowedCiphers = new ArrayList<String>();
            for (String cipher : ((SSLSocket)socketConnection.getMysqlSocket()).getEnabledCipherSuites()) {
                if (cipher.indexOf("_DHE_") != -1 || cipher.indexOf("_DH_") != -1) continue;
                allowedCiphers.add(cipher);
            }
            ((SSLSocket)socketConnection.getMysqlSocket()).setEnabledCipherSuites(allowedCiphers.toArray(new String[0]));
        }
        ((SSLSocket)socketConnection.getMysqlSocket()).startHandshake();
        if (socketConnection.getPropertySet().getBooleanReadableProperty("useUnbufferedInput").getValue().booleanValue()) {
            socketConnection.setMysqlInput(socketConnection.getMysqlSocket().getInputStream());
        } else {
            socketConnection.setMysqlInput(new BufferedInputStream(socketConnection.getMysqlSocket().getInputStream(), 16384));
        }
        socketConnection.setMysqlOutput(new BufferedOutputStream(socketConnection.getMysqlSocket().getOutputStream(), 16384));
        socketConnection.getMysqlOutput().flush();
        socketConnection.setSocketFactory(sslFact);
    }

    private ExportControlled() {
    }

    private static SSLSocketFactory getSSLSocketFactoryDefaultOrConfigured(PropertySet propertySet, ExceptionInterceptor exceptionInterceptor) throws SSLParamsException {
        String keyStoreUrl = propertySet.getStringReadableProperty("clientCertificateKeyStoreUrl").getValue();
        String trustStoreUrl = propertySet.getStringReadableProperty("trustCertificateKeyStoreUrl").getValue();
        if (StringUtils.isNullOrEmpty(keyStoreUrl) && StringUtils.isNullOrEmpty(trustStoreUrl) && propertySet.getBooleanReadableProperty("verifyServerCertificate").getValue().booleanValue()) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        String keyStoreType = propertySet.getStringReadableProperty("clientCertificateKeyStoreType").getValue();
        String keyStorePassword = propertySet.getStringReadableProperty("clientCertificateKeyStorePassword").getValue();
        String trustStoreType = propertySet.getStringReadableProperty("trustCertificateKeyStoreType").getValue();
        String trustStorePassword = propertySet.getStringReadableProperty("trustCertificateKeyStorePassword").getValue();
        boolean verifyServerCert = propertySet.getBooleanReadableProperty("verifyServerCertificate").getValue();
        return ExportControlled.getSSLContext(keyStoreUrl, keyStoreType, keyStorePassword, trustStoreUrl, trustStoreType, trustStorePassword, verifyServerCert, exceptionInterceptor).getSocketFactory();
    }

    /*
     * Unable to fully structure code
     */
    public static SSLContext getSSLContext(String keyStoreUrl, String keyStoreType, String keyStorePassword, String trustStoreUrl, String trustStoreType, String trustStorePassword, boolean verifyServerCert, ExceptionInterceptor exceptionInterceptor) throws SSLParamsException {
        tmf = null;
        kmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw ExceptionFactory.createException(SSLParamsException.class, "Default algorithm definitions for TrustManager and/or KeyManager are invalid.  Check java security properties file.", nsae, exceptionInterceptor);
        }
        if (!StringUtils.isNullOrEmpty(keyStoreUrl)) {
            ksIS = null;
            try {
                if (!StringUtils.isNullOrEmpty(keyStoreType)) {
                    clientKeyStore = KeyStore.getInstance(keyStoreType);
                    ksURL = new URL(keyStoreUrl);
                    password = keyStorePassword == null ? new char[]{} : keyStorePassword.toCharArray();
                    ksIS = ksURL.openStream();
                    clientKeyStore.load(ksIS, password);
                    kmf.init(clientKeyStore, password);
                }
            }
            catch (UnrecoverableKeyException uke) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Could not recover keys from client keystore.  Check password?", uke, exceptionInterceptor);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Unsupported keystore algorithm [" + nsae.getMessage() + "]", nsae, exceptionInterceptor);
            }
            catch (KeyStoreException kse) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Could not create KeyStore instance [" + kse.getMessage() + "]", kse, exceptionInterceptor);
            }
            catch (CertificateException nsae) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Could not load client" + keyStoreType + " keystore from " + keyStoreUrl, nsae, exceptionInterceptor);
            }
            catch (MalformedURLException mue) {
                throw ExceptionFactory.createException(SSLParamsException.class, keyStoreUrl + " does not appear to be a valid URL.", mue, exceptionInterceptor);
            }
            catch (IOException ioe) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Cannot open " + keyStoreUrl + " [" + ioe.getMessage() + "]", ioe, exceptionInterceptor);
            }
            finally {
                if (ksIS != null) {
                    try {
                        ksIS.close();
                    }
                    catch (IOException var15_33) {}
                }
            }
        }
        if (!StringUtils.isNullOrEmpty(trustStoreUrl)) {
            ksIS = null;
            try {
                if (StringUtils.isNullOrEmpty(trustStoreType)) ** GOTO lbl73
                trustKeyStore = KeyStore.getInstance(trustStoreType);
                ksURL = new URL(trustStoreUrl);
                password = trustStorePassword == null ? new char[]{} : trustStorePassword.toCharArray();
                ksIS = ksURL.openStream();
                trustKeyStore.load(ksIS, password);
                tmf.init(trustKeyStore);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Unsupported keystore algorithm [" + nsae.getMessage() + "]", nsae, exceptionInterceptor);
            }
            catch (KeyStoreException kse) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Could not create KeyStore instance [" + kse.getMessage() + "]", kse, exceptionInterceptor);
            }
            catch (CertificateException nsae) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Could not load trust" + trustStoreType + " keystore from " + trustStoreUrl, nsae, exceptionInterceptor);
            }
            catch (MalformedURLException mue) {
                throw ExceptionFactory.createException(SSLParamsException.class, trustStoreUrl + " does not appear to be a valid URL.", mue, exceptionInterceptor);
            }
            catch (IOException ioe) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Cannot open " + trustStoreUrl + " [" + ioe.getMessage() + "]", ioe, exceptionInterceptor);
            }
            finally {
                if (ksIS != null) {
                    try {
                        ksIS.close();
                    }
                    catch (IOException var17_35) {}
                }
            }
        } else {
            try {
                tmf.init((KeyStore)null);
            }
            catch (KeyStoreException kse) {
                throw ExceptionFactory.createException(SSLParamsException.class, "Could not create KeyStore instance [" + kse.getMessage() + "]", kse, exceptionInterceptor);
            }
        }
lbl73:
        // 3 sources

        sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            v0 = StringUtils.isNullOrEmpty(keyStoreUrl) != false ? null : kmf.getKeyManagers();
            if (verifyServerCert) {
                v1 = tmf.getTrustManagers();
            } else {
                v2 = new X509TrustManager[1];
                v1 = v2;
                v2[0] = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
            }
            sslContext.init(v0, v1, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLParamsException("TLS is not a valid SSL protocol.", nsae);
        }
        catch (KeyManagementException kme) {
            throw new SSLParamsException("KeyManagementException: " + kme.getMessage(), kme);
        }
        catch (Exception e) {
            throw new SSLParamsException("now what?", e);
        }
    }

    public static boolean isSSLEstablished(Socket socket) {
        return SSLSocket.class.isAssignableFrom(socket.getClass());
    }

    public static RSAPublicKey decodeRSAPublicKey(String key) throws RSAException {
        if (key == null) {
            throw ExceptionFactory.createException(RSAException.class, "Key parameter is null");
        }
        int offset = key.indexOf("\n") + 1;
        int len = key.indexOf("-----END PUBLIC KEY-----") - offset;
        byte[] certificateData = Base64Decoder.decode(key.getBytes(), offset, len);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(certificateData);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)kf.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw ExceptionFactory.createException(RSAException.class, "Unable to decode public key", e);
        }
    }

    public static byte[] encryptWithRSAPublicKey(byte[] source, RSAPublicKey key) throws RSAException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, key);
            return cipher.doFinal(source);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw ExceptionFactory.createException(RSAException.class, e.getMessage(), e);
        }
    }

    public static class StandardSSLSocketFactory
    implements SocketFactory {
        private SSLSocket rawSocket = null;
        private final SSLSocketFactory sslFact;
        private final SocketFactory existingSocketFactory;
        private final Socket existingSocket;

        public StandardSSLSocketFactory(SSLSocketFactory sslFact, SocketFactory existingSocketFactory, Socket existingSocket) {
            this.sslFact = sslFact;
            this.existingSocketFactory = existingSocketFactory;
            this.existingSocket = existingSocket;
        }

        @Override
        public Socket afterHandshake() throws SocketException, IOException {
            this.existingSocketFactory.afterHandshake();
            return this.rawSocket;
        }

        @Override
        public Socket beforeHandshake() throws SocketException, IOException {
            return this.rawSocket;
        }

        @Override
        public Socket connect(String host, int portNumber, Properties props, int loginTimeout) throws SocketException, IOException {
            this.rawSocket = (SSLSocket)this.sslFact.createSocket(this.existingSocket, host, portNumber, true);
            return this.rawSocket;
        }

        @Override
        public boolean isLocallyConnected(MysqlConnection conn) {
            return this.existingSocketFactory.isLocallyConnected(conn);
        }
    }
}

