/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search.importer;

import java.util.Set;
import org.protege.editor.owl.model.search.AxiomBasedSearchMetadataImporter;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.model.search.SearchMetadata;
import org.protege.editor.owl.model.search.SearchMetadataDB;
import org.protege.editor.owl.model.search.SearchMetadataImportContext;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class AxiomAnnotationSearchMetadataImporter
extends AxiomBasedSearchMetadataImporter {
    @Override
    public boolean isImporterFor(AxiomType<?> axiomType, Set<SearchCategory> categories) {
        return categories.contains((Object)SearchCategory.ANNOTATION_VALUE);
    }

    @Override
    public void generateSearchMetadataFor(OWLAxiom axiom, OWLEntity axiomSubject, String axiomSubjectRendering, SearchMetadataImportContext context, SearchMetadataDB db) {
        for (OWLAnnotation annotation : axiom.getAnnotations()) {
            this.generateSearchMetadataForAnnotation(annotation, axiomSubject, axiomSubjectRendering, context, db);
        }
    }

    private void generateSearchMetadataForAnnotation(final OWLAnnotation annotation, OWLEntity axiomSubject, String axiomSubjectRendering, final SearchMetadataImportContext context, SearchMetadataDB db) {
        String group = context.getRendering((OWLObject)annotation.getProperty());
        StyledString ren = context.getStyledStringRendering((OWLObject)annotation);
        SearchMetadata md = new SearchMetadata(SearchCategory.ANNOTATION_VALUE, group, (OWLObject)axiomSubject, axiomSubjectRendering, ren.getString()){

            @Override
            public StyledString getStyledSearchSearchString() {
                return context.getStyledStringRendering((OWLObject)annotation);
            }
        };
        db.addResult(md);
        for (OWLAnnotation anno : annotation.getAnnotations()) {
            this.generateSearchMetadataForAnnotation(anno, axiomSubject, axiomSubjectRendering, context, db);
        }
    }
}

