/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class OWLObjectRemover {
    public List<OWLOntologyChange> getChangesToRemoveObject(OWLEntity object, OWLOntology ontology) {
        return this.getChangesToRemoveObject((OWLObject)object, ontology);
    }

    public List<OWLOntologyChange> getChangesToRemoveObject(OWLAnonymousIndividual object, OWLOntology ontology) {
        return this.getChangesToRemoveObject((OWLObject)object, ontology);
    }

    private List<OWLOntologyChange> getChangesToRemoveObject(OWLObject object, final OWLOntology ontology) {
        return (List)object.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<List<OWLOntologyChange>>(Collections.emptyList()){

            public List<OWLOntologyChange> visit(OWLDatatype datatype) {
                return OWLObjectRemover.this.getChangesForEntity((OWLEntity)datatype, ontology);
            }

            public List<OWLOntologyChange> visit(OWLDataProperty property) {
                return OWLObjectRemover.this.getChangesForEntity((OWLEntity)property, ontology);
            }

            public List<OWLOntologyChange> visit(OWLObjectProperty property) {
                return OWLObjectRemover.this.getChangesForEntity((OWLEntity)property, ontology);
            }

            public List<OWLOntologyChange> visit(OWLNamedIndividual individual) {
                return OWLObjectRemover.this.getChangesForEntity((OWLEntity)individual, ontology);
            }

            public List<OWLOntologyChange> visit(OWLClass desc) {
                return OWLObjectRemover.this.getChangesForEntity((OWLEntity)desc, ontology);
            }

            public List<OWLOntologyChange> visit(OWLAnonymousIndividual individual) {
                return OWLObjectRemover.this.getChangesForAnonymousIndividual(individual, ontology);
            }

            public List<OWLOntologyChange> visit(OWLAnnotationProperty property) {
                List changes = OWLObjectRemover.this.getChangesForEntity((OWLEntity)property, ontology);
                changes.addAll(OWLObjectRemover.this.getChangesForOntologyAnnotations(property, ontology));
                return changes;
            }
        });
    }

    private List<OWLOntologyChange> getChangesForAnonymousIndividual(OWLAnonymousIndividual individual, OWLOntology ont) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom ax : ont.getReferencingAxioms((OWLPrimitive)individual)) {
            changes.add((OWLOntologyChange)new RemoveAxiom(ont, ax));
        }
        changes.addAll(this.getChangesForAnnotationSubject((OWLAnnotationSubject)individual, ont));
        changes.addAll(this.getChangesForAnnotationValue((OWLAnnotationValue)individual, ont));
        return changes;
    }

    private List<OWLOntologyChange> getChangesForEntity(OWLEntity entity, OWLOntology ont) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom ax : ont.getReferencingAxioms((OWLPrimitive)entity)) {
            changes.add((OWLOntologyChange)new RemoveAxiom(ont, ax));
        }
        IRI entityIRI = entity.getIRI();
        changes.addAll(this.getChangesForAnnotationSubject((OWLAnnotationSubject)entityIRI, ont));
        changes.addAll(this.getChangesForAnnotationValue((OWLAnnotationValue)entityIRI, ont));
        changes.addAll(this.getChangesForOntologyAnnotations((OWLAnnotationValue)entityIRI, ont));
        return changes;
    }

    private List<OWLOntologyChange> getChangesForAnnotationSubject(OWLAnnotationSubject subject, OWLOntology ont) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAnnotationAssertionAxiom ax : ont.getAnnotationAssertionAxioms(subject)) {
            changes.add((OWLOntologyChange)new RemoveAxiom(ont, (OWLAxiom)ax));
        }
        return changes;
    }

    private List<OWLOntologyChange> getChangesForAnnotationValue(OWLAnnotationValue object, OWLOntology ont) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAnnotationAssertionAxiom ax : ont.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            if (!ax.getValue().equals(object)) continue;
            changes.add((OWLOntologyChange)new RemoveAxiom(ont, (OWLAxiom)ax));
        }
        return changes;
    }

    private List<OWLOntologyChange> getChangesForOntologyAnnotations(OWLAnnotationProperty annotationProperty, OWLOntology ont) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAnnotation annotation : ont.getAnnotations()) {
            if (!annotation.getProperty().equals(annotationProperty)) continue;
            changes.add((OWLOntologyChange)new RemoveOntologyAnnotation(ont, annotation));
        }
        return changes;
    }

    private List<OWLOntologyChange> getChangesForOntologyAnnotations(OWLAnnotationValue value, OWLOntology ont) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAnnotation annotation : ont.getAnnotations()) {
            if (!annotation.getValue().equals(value)) continue;
            changes.add((OWLOntologyChange)new RemoveOntologyAnnotation(ont, annotation));
        }
        return changes;
    }
}

