/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.List;
import org.protege.editor.owl.ui.action.FocusedComponentAction;
import org.protege.editor.owl.ui.transfer.TransferableOWLObject;
import org.protege.editor.owl.ui.view.Cuttable;
import org.protege.editor.owl.ui.view.ViewClipboard;
import org.semanticweb.owlapi.model.OWLObject;

public class CutAction
extends FocusedComponentAction<Cuttable> {
    @Override
    protected Class<Cuttable> initialiseAction() {
        return Cuttable.class;
    }

    @Override
    protected boolean canPerform() {
        return ((Cuttable)this.getCurrentTarget()).canCut();
    }

    public void actionPerformed(ActionEvent e) {
        List<OWLObject> objects = ((Cuttable)this.getCurrentTarget()).cutObjects();
        if (objects.isEmpty()) {
            return;
        }
        ViewClipboard clipboard = ViewClipboard.getInstance();
        clipboard.getClipboard().setContents(new TransferableOWLObject(this.getOWLModelManager(), objects), null);
        new TransferableOWLObject(this.getOWLModelManager(), objects);
        StringBuilder buffer = new StringBuilder();
        for (OWLObject owlObject : objects) {
            buffer.append(this.getOWLModelManager().getRendering(owlObject));
            buffer.append("\n");
        }
        StringSelection stringSelection = new StringSelection(buffer.toString().trim());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }
}

