/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.List;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.refactor.AllDifferentCreator;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.HasIndividualsInSignature;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public class MakeAllIndividualsDifferent
extends ProtegeOWLAction {
    private final OWLOntologyChangeListener changeListener = this::handleOntologyChanges;
    private final OWLModelManagerListener modelManagerListener = event -> {
        if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
            this.updateState();
        }
    };

    public void actionPerformed(ActionEvent e) {
        OWLModelManager modelManager = this.getOWLModelManager();
        OWLOntology activeOntology = modelManager.getActiveOntology();
        AllDifferentCreator creator = new AllDifferentCreator(modelManager.getOWLDataFactory(), activeOntology, modelManager.getActiveOntologies());
        modelManager.applyChanges(creator.getChanges());
        this.updateState();
    }

    public void initialise() throws Exception {
        this.getOWLModelManager().addListener(this.modelManagerListener);
        this.getOWLModelManager().addOntologyChangeListener(this.changeListener);
        this.updateState();
    }

    public void dispose() {
        this.getOWLModelManager().removeListener(this.modelManagerListener);
        this.getOWLModelManager().removeOntologyChangeListener(this.changeListener);
    }

    private void updateState() {
        boolean enabled = this.getOWLModelManager().getActiveOntologies().stream().filter(o -> !o.getIndividualsInSignature().isEmpty()).findAny().isPresent();
        this.setEnabled(enabled);
    }

    private void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        changes.stream().filter(OWLOntologyChange::isAxiomChange).map(OWLOntologyChange::getAxiom).map(HasIndividualsInSignature::getIndividualsInSignature).filter(inds -> !inds.isEmpty()).findAny().ifPresent(ax -> this.updateState());
    }
}

