/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveAllDisjointAxiomsAction
extends ProtegeOWLAction {
    private final Logger logger = LoggerFactory.getLogger(RemoveAllDisjointAxiomsAction.class);
    private OWLModelManagerListener listener = event -> {
        if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
            this.updateState();
        }
    };
    private OWLOntologyChangeListener changeListener = this::handleOntologyChanges;

    public void actionPerformed(ActionEvent e) {
        try {
            UIHelper uiHelper = new UIHelper(this.getOWLEditorKit());
            int result = uiHelper.showOptionPane("Remove axioms from imported ontologies?", "Do you want to remove the disjoint classes axioms from imported ontologies?", 1, 3);
            Set<Object> ontologies = new HashSet<OWLOntology>();
            if (result == 0) {
                ontologies.addAll(this.getOWLModelManager().getActiveOntologies());
            } else if (result == 1) {
                ontologies = Collections.singleton(this.getOWLModelManager().getActiveOntology());
            }
            ArrayList changes = new ArrayList();
            ontologies.forEach(o -> changes.addAll(o.getAxioms(AxiomType.DISJOINT_CLASSES).stream().map(ax -> new RemoveAxiom(o, (OWLAxiom)ax)).collect(Collectors.toList())));
            this.getOWLModelManager().applyChanges(changes);
        }
        catch (Exception ex) {
            this.logger.error("An error occurred whilst attempting to remove all disjoint classes axioms.", (Throwable)ex);
        }
    }

    private void updateState() {
        boolean containsDisjointClassesAxioms = this.getOWLModelManager().getActiveOntologies().stream().filter(o -> o.getAxiomCount(AxiomType.DISJOINT_CLASSES) > 0).findAny().isPresent();
        this.setEnabled(this.getOWLModelManager().isActiveOntologyMutable() && containsDisjointClassesAxioms);
    }

    private void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        changes.stream().filter(OWLOntologyChange::isAxiomChange).map(OWLOntologyChange::getAxiom).filter(ax -> ax.getAxiomType() == AxiomType.DISJOINT_CLASSES).findAny().ifPresent(ax -> this.updateState());
    }

    public void initialise() throws Exception {
        this.getOWLModelManager().addListener(this.listener);
        this.getOWLModelManager().addOntologyChangeListener(this.changeListener);
        this.updateState();
    }

    public void dispose() {
        this.getOWLModelManager().removeListener(this.listener);
        this.getOWLModelManager().removeOntologyChangeListener(this.changeListener);
    }
}

