/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.ui.editor.AbstractOWLClassExpressionEditor;
import org.protege.editor.owl.ui.selector.OWLClassSelectorPanel;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;

public class OWLClassSelectorWrapper
extends AbstractOWLClassExpressionEditor {
    private OWLClassSelectorPanel component;

    public void initialise() {
        this.component = new OWLClassSelectorPanel(this.getOWLEditorKit());
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean isValidInput() {
        return this.component.getSelectedObjects() != null && !this.component.getSelectedObjects().isEmpty();
    }

    @Override
    public boolean setDescription(OWLClassExpression description) {
        if (description == null) {
            return true;
        }
        if (!description.isAnonymous()) {
            this.component.setSelection(description.asOWLClass());
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLClassExpression> getClassExpressions() {
        return new HashSet<OWLClass>(this.component.getSelectedObjects());
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.component.addStatusChangedListener(l);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.component.removeStatusChangedListener(l);
    }

    public void dispose() {
        this.component.dispose();
    }
}

