/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.dataproperty;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLDataPropertyEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.dataproperty.OWLEquivalentDataPropertiesFrameSectionRow;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.util.CollectionFactory;

public class OWLEquivalentDataPropertiesFrameSection
extends AbstractOWLFrameSection<OWLDataProperty, OWLEquivalentDataPropertiesAxiom, OWLDataProperty> {
    public static final String LABEL = "Equivalent To";
    private Set<OWLEquivalentDataPropertiesAxiom> added = new HashSet<OWLEquivalentDataPropertiesAxiom>();

    @Override
    protected void clear() {
    }

    public OWLEquivalentDataPropertiesFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLDataProperty> frame) {
        super(editorKit, LABEL, "Equivalent property", frame);
    }

    @Override
    protected OWLEquivalentDataPropertiesAxiom createAxiom(OWLDataProperty object) {
        return this.getOWLDataFactory().getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLDataProperty[]{(OWLDataProperty)this.getRootObject(), object}));
    }

    @Override
    public OWLObjectEditor<OWLDataProperty> getObjectEditor() {
        return new OWLDataPropertyEditor(this.getOWLEditorKit());
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<OWLDataProperty> editor) {
        Set<OWLDataProperty> equivalents = editor.getEditedObjects();
        return equivalents.size() != 1 || !equivalents.contains(this.getRootObject());
    }

    @Override
    public void handleEditingFinished(Set<OWLDataProperty> editedObjects) {
        editedObjects = new HashSet<OWLDataProperty>(editedObjects);
        editedObjects.remove(this.getRootObject());
        super.handleEditingFinished(editedObjects);
    }

    @Override
    protected void refill(OWLOntology ontology) {
        this.added.clear();
        for (OWLEquivalentDataPropertiesAxiom ax : ontology.getEquivalentDataPropertiesAxioms((OWLDataProperty)this.getRootObject())) {
            this.addRow(new OWLEquivalentDataPropertiesFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLDataProperty)this.getRootObject(), ax));
            this.added.add(ax);
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_EQUIVALENT_DATATYPE_PROPERTIES, () -> {
            OWLEquivalentDataPropertiesAxiom ax;
            if (!this.getOWLModelManager().getReasoner().isConsistent()) {
                return;
            }
            HashSet equivs = new HashSet(this.getReasoner().getEquivalentDataProperties((OWLDataProperty)this.getRootObject()).getEntities());
            equivs.remove(this.getRootObject());
            if (!equivs.isEmpty() && !this.added.contains(ax = this.getOWLDataFactory().getOWLEquivalentDataPropertiesAxiom(equivs))) {
                this.addRow(new OWLEquivalentDataPropertiesFrameSectionRow(this.getOWLEditorKit(), this, null, (OWLDataProperty)this.getRootObject(), ax));
            }
        });
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLEquivalentDataPropertiesAxiom && ((OWLEquivalentDataPropertiesAxiom)change.getAxiom()).getProperties().contains(this.getRootObject());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLDataProperty, OWLEquivalentDataPropertiesAxiom, OWLDataProperty>> getRowComparator() {
        return null;
    }
}

