/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import javax.swing.text.StyleConstants;
import org.protege.editor.owl.ui.renderer.styledstring.CSSConstants;
import org.protege.editor.owl.ui.renderer.styledstring.FontWeight;
import org.protege.editor.owl.ui.renderer.styledstring.StyleAttribute;

public class FontWeightAttribute
extends StyleAttribute {
    private static final FontWeightAttribute BOLD = new FontWeightAttribute(FontWeight.BOLD);
    private FontWeight fontWeight;

    public FontWeightAttribute(FontWeight fontWeight) {
        this.fontWeight = fontWeight;
    }

    @Override
    public String getCSSPropertyName() {
        return CSSConstants.FONT_WEIGHT.getName();
    }

    @Override
    public String getCSSValue() {
        return this.fontWeight == FontWeight.BOLD ? CSSConstants.BOLD.getName() : CSSConstants.NORMAL.getName();
    }

    @Override
    public AttributedCharacterIterator.Attribute getAttributedStringAttribute() {
        return TextAttribute.WEIGHT;
    }

    @Override
    public Object getAttributesStringValue() {
        return TextAttribute.WEIGHT_BOLD;
    }

    public static FontWeightAttribute getBoldFontWeight() {
        return BOLD;
    }

    public static FontWeightAttribute getRegularFontWeight() {
        return new FontWeightAttribute(FontWeight.REGULAR);
    }

    @Override
    public StyleConstants getTextAttribute() {
        return (StyleConstants.FontConstants)StyleConstants.Bold;
    }

    @Override
    public Object getTextValue() {
        return this.fontWeight == FontWeight.BOLD;
    }

    public int hashCode() {
        return FontWeightAttribute.class.getSimpleName().hashCode() + this.fontWeight.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FontWeightAttribute)) {
            return false;
        }
        FontWeightAttribute other = (FontWeightAttribute)obj;
        return this.fontWeight == other.fontWeight;
    }
}

