/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.concurrent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.PriorityCollection;

public class ConcurrentPriorityCollection<T extends Serializable>
extends PriorityCollection<T> {
    private final Lock readLock;
    private final Lock writeLock;

    public ConcurrentPriorityCollection(@Nonnull ReadWriteLock readWriteLock, PriorityCollectionSorting sorting) {
        super(sorting);
        OWLAPIPreconditions.verifyNotNull(readWriteLock);
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void set(Iterable<T> c) {
        this.writeLock.lock();
        try {
            super.set(c);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void add(Iterable<T> c) {
        this.writeLock.lock();
        try {
            super.add(c);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void set(T ... c) {
        this.writeLock.lock();
        try {
            super.set(c);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void add(T ... c) {
        this.writeLock.lock();
        try {
            super.add(c);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void add(T c) {
        this.writeLock.lock();
        try {
            super.add(c);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void remove(T ... c) {
        this.writeLock.lock();
        try {
            super.remove(c);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void remove(T c) {
        this.writeLock.lock();
        try {
            super.remove(c);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.copyIterable().iterator();
    }

    @Override
    public PriorityCollection<T> getByMIMEType(@Nonnull String mimeType) {
        this.readLock.lock();
        try {
            PriorityCollection priorityCollection = super.getByMIMEType(mimeType);
            return priorityCollection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<T> copyIterable() {
        this.readLock.lock();
        try {
            ArrayList<Serializable> copy = new ArrayList<Serializable>();
            Iterator it = super.iterator();
            while (it.hasNext()) {
                Serializable element = (Serializable)it.next();
                copy.add(element);
            }
            ArrayList<Serializable> arrayList = copy;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

