/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;

public class Target {
    private List<StructuralNode> startNodes;
    private Context context;
    private boolean inScopeOnly = false;
    private int maxChildren = -1;
    private int maxDepth = -1;
    private boolean recurse = false;

    public Target() {
    }

    public Target(boolean inScopeOnly) {
        this.inScopeOnly = inScopeOnly;
    }

    public Target(StructuralNode startNode) {
        this.startNodes = new ArrayList<StructuralNode>();
        this.startNodes.add(startNode);
    }

    public Target(List<StructuralNode> startNodes) {
        this.startNodes = startNodes;
    }

    public Target(SiteNode startNode) {
        this.setStartNode(startNode);
    }

    public Target(SiteNode startNode, boolean recurse) {
        this(startNode);
        this.setRecurse(recurse);
    }

    public Target(Context context) {
        this.context = context;
    }

    public Target(SiteNode startNode, Context context, boolean inScopeOnly, int maxChildren, int maxDepth) {
        this(startNode);
        this.context = context;
        this.inScopeOnly = inScopeOnly;
        this.maxChildren = maxChildren;
        this.maxDepth = maxDepth;
    }

    public Target(SiteNode startNode, Context context, boolean inScopeOnly, boolean recurse) {
        this(startNode);
        this.context = context;
        this.inScopeOnly = inScopeOnly;
        this.recurse = recurse;
    }

    public boolean isValid() {
        return this.startNodes != null && this.startNodes.size() > 0 || this.context != null || this.inScopeOnly;
    }

    public SiteNode getStartNode() {
        if (this.startNodes != null && this.startNodes.size() > 0 && this.startNodes.get(0) instanceof StructuralSiteNode) {
            return ((StructuralSiteNode)this.startNodes.get(0)).getSiteNode();
        }
        return null;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isInScopeOnly() {
        return this.inScopeOnly;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setStartNode(SiteNode startNode) {
        this.setStartNode(new StructuralSiteNode(startNode));
    }

    public void setStartNode(StructuralNode startNode) {
        this.startNodes = new ArrayList<StructuralNode>();
        this.startNodes.add(startNode);
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public List<StructuralNode> getStartNodes() {
        return this.startNodes;
    }

    public void setInScopeOnly(boolean inScopeOnly) {
        this.inScopeOnly = inScopeOnly;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public String getDisplayName() {
        if (this.getStartNode() == null) {
            if (this.context != null) {
                return Constant.messages.getString("context.prefixName", this.context.getName());
            }
            if (this.inScopeOnly) {
                return Constant.messages.getString("target.allInScope");
            }
            return Constant.messages.getString("target.empty");
        }
        String name = this.getStartNode().getHierarchicNodeName(false);
        if (name.length() < 30) {
            return name;
        }
        return name.substring(0, 14) + ".." + name.substring(name.length() - 15, name.length());
    }
}

