/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.PropertySetEditor;
import com.zeroc.IceGridGUI.Application.PropertySetParent;
import com.zeroc.IceGridGUI.Application.ServerInstance;
import com.zeroc.IceGridGUI.Application.ServerInstancePropertySetEditor;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class PropertySet
extends TreeNode {
    private PropertySetDescriptor _descriptor;
    private String _unsubstitutedId;
    private final boolean _ephemeral;
    private final Editable _editable;
    private final boolean _inServerInstance;
    private PropertySetEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;

    public static PropertySetDescriptor copyDescriptor(PropertySetDescriptor d) {
        PropertySetDescriptor psd = d.clone();
        psd.properties = new LinkedList(psd.properties);
        return psd;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/property_set.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        boolean bl = actions[13] = !this._ephemeral;
        if (((TreeNode)this._parent).getAvailableActions()[14]) {
            actions[14] = true;
        }
        actions[15] = true;
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
        }
        return actions;
    }

    @Override
    public void copy() {
        this.getCoordinator().setClipboard(PropertySet.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public void paste() {
        ((TreeNode)this._parent).paste();
    }

    @Override
    public void destroy() {
        PropertySetParent parent = (PropertySetParent)((Object)this._parent);
        parent.removePropertySet(this);
        if (!this._ephemeral) {
            parent.removeDescriptor(this._unsubstitutedId);
            if (this._editable != null) {
                parent.getEditable().removeElement(this._unsubstitutedId, this._editable, PropertySet.class);
            } else {
                parent.getEditable().markModified();
            }
            this.getRoot().updated();
        }
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = this._inServerInstance ? (PropertySetEditor)this.getRoot().getEditor(ServerInstancePropertySetEditor.class, this) : (PropertySetEditor)this.getRoot().getEditor(PropertySetEditor.class, this);
        }
        this._editor.show(this._unsubstitutedId, this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        if (this._inServerInstance) {
            return new ServerInstancePropertySetEditor();
        }
        return new PropertySetEditor();
    }

    @Override
    public boolean isEphemeral() {
        return this._ephemeral;
    }

    public String unsubstitutedId() {
        return this._unsubstitutedId;
    }

    @Override
    Object getDescriptor() {
        return this._descriptor;
    }

    Object saveDescriptor() {
        return this._descriptor.clone();
    }

    void restoreDescriptor(Object savedDescriptor) {
        PropertySetDescriptor clone = (PropertySetDescriptor)savedDescriptor;
        this._descriptor.references = clone.references;
        this._descriptor.properties = clone.properties;
    }

    void commit() {
        if (this._editable != null) {
            this._editable.commit();
        }
    }

    Editable getEditable() {
        if (this._editable != null) {
            return this._editable;
        }
        return ((PropertySetParent)((Object)this._parent)).getEditable();
    }

    PropertySet(boolean brandNew, TreeNode parent, String id, String unsubstitutedId, PropertySetDescriptor descriptor) {
        super(parent, id);
        this._unsubstitutedId = unsubstitutedId;
        this._inServerInstance = parent instanceof ServerInstance;
        this._ephemeral = false;
        this._editable = new Editable(brandNew);
        this.rebuild(descriptor);
    }

    PropertySet(TreeNode parent, String id, String unsubstitutedId, PropertySetDescriptor descriptor) {
        super(parent, id);
        this._unsubstitutedId = unsubstitutedId;
        this._inServerInstance = parent instanceof ServerInstance;
        this._ephemeral = false;
        this._editable = null;
        this.rebuild(descriptor);
    }

    PropertySet(TreeNode parent, String id, PropertySetDescriptor descriptor) {
        super(parent, id);
        this._unsubstitutedId = id;
        this._inServerInstance = parent instanceof ServerInstance;
        this._ephemeral = true;
        this._editable = null;
        this.rebuild(descriptor);
    }

    @Override
    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            PropertySet.writePropertySet(writer, this._unsubstitutedId, this._inServerInstance ? "service" : "id", this._descriptor, null, null);
        }
    }

    void rebuild(PropertySetDescriptor descriptor) {
        this._descriptor = descriptor;
    }
}

