/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.IceGrid.ObjectInfo;
import com.zeroc.IceGrid.ObjectObserver;
import com.zeroc.IceGridGUI.Coordinator;
import javax.swing.SwingUtilities;

class ObjectObserverI
implements ObjectObserver {
    private final Coordinator _coordinator;
    private final boolean _trace;

    ObjectObserverI(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._trace = coordinator.traceObservers();
    }

    public synchronized void objectInit(ObjectInfo[] objects, Current current) {
        if (this._trace) {
            if (objects.length == 0) {
                this._coordinator.traceObserver("objectInit (no object)");
            } else {
                String names = "";
                for (ObjectInfo obj : objects) {
                    names = names + " " + obj.proxy.toString();
                }
                this._coordinator.traceObserver("objectInit for objects" + names);
            }
        }
        SwingUtilities.invokeLater(() -> this._coordinator.objectInit(objects));
    }

    public void objectAdded(ObjectInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("objectAdded for object " + info.proxy.toString());
        }
        SwingUtilities.invokeLater(() -> this._coordinator.objectAdded(info));
    }

    public void objectUpdated(ObjectInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("objectUpdated for object " + info.proxy.toString());
        }
        SwingUtilities.invokeLater(() -> this._coordinator.objectUpdated(info));
    }

    public void objectRemoved(Identity id, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("objectRemoved for object " + this._coordinator.getCommunicator().identityToString(id));
        }
        SwingUtilities.invokeLater(() -> this._coordinator.objectRemoved(id));
    }
}

