/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weigher;
import grails.gorm.validation.Constrained;
import grails.gorm.validation.ConstrainedProperty;
import grails.util.CollectionUtils;
import grails.util.Holders;
import grails.web.mapping.UrlCreator;
import grails.web.mapping.UrlMapping;
import grails.web.mapping.UrlMappingInfo;
import grails.web.mapping.UrlMappings;
import groovy.lang.Closure;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.web.mapping.DefaultUrlCreator;
import org.grails.web.mapping.DefaultUrlMappingEvaluator;
import org.grails.web.mapping.ResponseCodeUrlMapping;
import org.grails.web.mapping.UrlCreatorCache;
import org.springframework.context.ApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpMethod;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.WebApplicationContext;

public class DefaultUrlMappingsHolder
implements UrlMappings {
    private static final transient Log LOG = LogFactory.getLog(DefaultUrlMappingsHolder.class);
    private static final int DEFAULT_MAX_WEIGHTED_CAPACITY = 5000;
    public static final UrlMappingInfo[] EMPTY_RESULTS = new UrlMappingInfo[0];
    private int maxWeightedCacheCapacity = 5000;
    private Map<String, UrlMappingInfo> cachedMatches;
    private Map<UriToUrlMappingKey, List<UrlMappingInfo>> cachedListMatches;
    private List<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
    private UrlMapping[] mappings;
    private UrlCreatorCache urlCreatorCache;
    private int urlCreatorMaxWeightedCacheCapacity = 160000;
    private final List excludePatterns;
    private final Map<UrlMappingKey, UrlMapping> mappingsLookup = new HashMap<UrlMappingKey, UrlMapping>();
    private final Map<String, UrlMapping> namedMappings = new HashMap<String, UrlMapping>();
    private final UrlMappingsList mappingsListLookup = new UrlMappingsList();
    private final Set<String> DEFAULT_NAMESPACE_PARAMS = CollectionUtils.newSet((Object[])new String[]{"namespace", "controller", "action"});
    private final Set<String> DEFAULT_CONTROLLER_PARAMS = CollectionUtils.newSet((Object[])new String[]{"controller", "action"});
    private final Set<String> DEFAULT_CONTROLLER_ONLY_PARAMS = CollectionUtils.newSet((Object[])new String[]{"controller"});
    private final Set<String> DEFAULT_ACTION_PARAMS = CollectionUtils.newSet((Object[])new String[]{"action"});
    private final PathMatcher pathMatcher = new AntPathMatcher();

    public DefaultUrlMappingsHolder(List<UrlMapping> mappings) {
        this(mappings, null, false);
    }

    public DefaultUrlMappingsHolder(List<UrlMapping> mappings, List excludePatterns) {
        this(mappings, excludePatterns, false);
    }

    public DefaultUrlMappingsHolder(List<UrlMapping> mappings, List excludePatterns, boolean doNotCallInit) {
        this.urlMappings = mappings;
        this.excludePatterns = excludePatterns;
        if (!doNotCallInit) {
            this.initialize();
        }
    }

    @Override
    public Collection<UrlMapping> addMappings(Closure mappings) {
        WebApplicationContext applicationContext = (WebApplicationContext)Holders.findApplicationContext();
        DefaultUrlMappingEvaluator evaluator = new DefaultUrlMappingEvaluator((ApplicationContext)applicationContext);
        List<UrlMapping> newMappings = evaluator.evaluateMappings(mappings);
        this.urlMappings.addAll(newMappings);
        this.initialize();
        return newMappings;
    }

    public void initialize() {
        this.sortMappings();
        this.cachedMatches = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.maxWeightedCacheCapacity).build();
        this.cachedListMatches = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.maxWeightedCacheCapacity).weigher((Weigher)CustomListWeigher.INSTANCE).build();
        if (this.urlCreatorMaxWeightedCacheCapacity > 0) {
            this.urlCreatorCache = new UrlCreatorCache(this.urlCreatorMaxWeightedCacheCapacity);
        }
        for (UrlMapping mapping : this.mappings = this.urlMappings.toArray(new UrlMapping[this.urlMappings.size()])) {
            String mappingName = mapping.getMappingName();
            if (mappingName != null) {
                this.namedMappings.put(mappingName, mapping);
            }
            String controllerName = mapping.getControllerName() instanceof String ? mapping.getControllerName().toString() : null;
            String actionName = mapping.getActionName() instanceof String ? mapping.getActionName().toString() : null;
            String pluginName = mapping.getPluginName() instanceof String ? mapping.getPluginName().toString() : null;
            String httpMethod = mapping.getHttpMethod();
            String version = mapping.getVersion();
            String namespace = mapping.getNamespace() instanceof String ? mapping.getNamespace().toString() : null;
            Constrained[] params = mapping.getConstraints();
            HashSet<String> requiredParams = new HashSet<String>();
            int optionalIndex = -1;
            for (int j = 0; j < params.length; ++j) {
                Constrained param = params[j];
                if (!(param instanceof ConstrainedProperty)) continue;
                if (!param.isNullable()) {
                    requiredParams.add(((ConstrainedProperty)param).getPropertyName());
                    continue;
                }
                optionalIndex = j;
                break;
            }
            UrlMappingKey key = new UrlMappingKey(controllerName, actionName, namespace, pluginName, httpMethod, version, requiredParams);
            this.mappingsLookup.put(key, mapping);
            UrlMappingsListKey listKey = new UrlMappingsListKey(controllerName, actionName, namespace, pluginName, httpMethod, version);
            this.mappingsListLookup.put(listKey, key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reverse mapping: " + key + " -> " + mapping));
            }
            HashSet<String> requiredParamsAndOptionals = new HashSet<String>(requiredParams);
            if (optionalIndex <= -1) continue;
            for (int j = optionalIndex; j < params.length; ++j) {
                Constrained constrained = params[j];
                if (!(constrained instanceof ConstrainedProperty)) continue;
                ConstrainedProperty param = (ConstrainedProperty)constrained;
                requiredParamsAndOptionals.add(param.getPropertyName());
                key = new UrlMappingKey(controllerName, actionName, namespace, pluginName, httpMethod, version, new HashSet<String>(requiredParamsAndOptionals));
                this.mappingsLookup.put(key, mapping);
                listKey = new UrlMappingsListKey(controllerName, actionName, namespace, pluginName, httpMethod, version);
                this.mappingsListLookup.put(listKey, key);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Reverse mapping: " + key + " -> " + mapping));
            }
        }
    }

    private void sortMappings() {
        ArrayList<ResponseCodeUrlMapping> responseCodeUrlMappings = new ArrayList<ResponseCodeUrlMapping>();
        Iterator<UrlMapping> iter = this.urlMappings.iterator();
        while (iter.hasNext()) {
            UrlMapping mapping = iter.next();
            if (!(mapping instanceof ResponseCodeUrlMapping)) continue;
            responseCodeUrlMappings.add((ResponseCodeUrlMapping)mapping);
            iter.remove();
        }
        Collections.sort(this.urlMappings);
        this.urlMappings.addAll(responseCodeUrlMappings);
        Collections.reverse(this.urlMappings);
    }

    @Override
    public UrlMapping[] getUrlMappings() {
        return this.mappings;
    }

    @Override
    public List getExcludePatterns() {
        return this.excludePatterns;
    }

    @Override
    public UrlCreator getReverseMapping(String controller, String action, Map params) {
        return this.getReverseMapping(controller, action, null, null, params);
    }

    @Override
    public UrlCreator getReverseMapping(String controller, String action, String pluginName, Map params) {
        return this.getReverseMapping(controller, action, null, pluginName, null, params);
    }

    @Override
    public UrlCreator getReverseMapping(String controller, String action, String namespace, String pluginName, String httpMethod, Map params) {
        return this.getReverseMapping(controller, action, namespace, pluginName, httpMethod, "*", params);
    }

    @Override
    public UrlCreator getReverseMapping(String controller, String action, String namespace, String pluginName, String httpMethod, String version, Map params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (this.urlCreatorCache != null) {
            UrlCreatorCache.ReverseMappingKey key = this.urlCreatorCache.createKey(controller, action, namespace, pluginName, httpMethod, params);
            UrlCreator creator = this.urlCreatorCache.lookup(key);
            if (creator == null) {
                creator = this.resolveUrlCreator(controller, action, namespace, pluginName, httpMethod, version, params, true);
                creator = this.urlCreatorCache.putAndDecorate(key, creator);
            }
            params.remove("mappingName");
            return creator;
        }
        return this.resolveUrlCreator(controller, action, namespace, pluginName, httpMethod, version, params, true);
    }

    @Override
    public UrlCreator getReverseMapping(String controller, String action, String namespace, String pluginName, Map params) {
        return this.getReverseMapping(controller, action, namespace, pluginName, null, params);
    }

    @Override
    public UrlCreator getReverseMappingNoDefault(String controller, String action, Map params) {
        return this.getReverseMappingNoDefault(controller, action, null, null, null, params);
    }

    @Override
    public UrlCreator getReverseMappingNoDefault(String controller, String action, String namespace, String pluginName, String httpMethod, Map params) {
        return this.getReverseMappingNoDefault(controller, action, namespace, pluginName, httpMethod, "*", params);
    }

    @Override
    public UrlCreator getReverseMappingNoDefault(String controller, String action, String namespace, String pluginName, String httpMethod, String version, Map params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (this.urlCreatorCache != null) {
            UrlCreatorCache.ReverseMappingKey key = this.urlCreatorCache.createKey(controller, action, namespace, pluginName, httpMethod, params);
            UrlCreator creator = this.urlCreatorCache.lookup(key);
            if (creator == null && (creator = this.resolveUrlCreator(controller, action, namespace, pluginName, httpMethod, version, params, false)) != null) {
                creator = this.urlCreatorCache.putAndDecorate(key, creator);
            }
            params.remove("mappingName");
            return creator;
        }
        return this.resolveUrlCreator(controller, action, namespace, pluginName, httpMethod, version, params, true);
    }

    private UrlCreator resolveUrlCreator(String controller, String action, String namespace, String pluginName, String httpMethod, String version, Map params, boolean useDefault) {
        UrlMappingKey lookupKey;
        UrlMappingKey lookupKeyModifiedParams;
        UrlMappingKey lookupKey2;
        HashSet paramKeys;
        HashSet<String> lookupParams;
        UrlMappingKey lookupKey3;
        UrlMapping mapping = null;
        if (httpMethod == null) {
            httpMethod = "*";
        }
        if ((mapping = this.namedMappings.get(params.remove("mappingName"))) == null && (mapping = this.lookupMapping(controller, action, namespace, pluginName, httpMethod, version, params)) == null) {
            this.lookupMapping(controller, action, namespace, pluginName, "*", version, params);
        }
        if ((mapping == null || mapping instanceof ResponseCodeUrlMapping) && (mapping = this.mappingsLookup.get(lookupKey3 = new UrlMappingKey(controller, action, namespace, pluginName, httpMethod, version, Collections.emptySet()))) == null) {
            lookupKey3.httpMethod = "*";
            mapping = this.mappingsLookup.get(lookupKey3);
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            lookupParams = new HashSet<String>(this.DEFAULT_ACTION_PARAMS);
            paramKeys = new HashSet(params.keySet());
            paramKeys.removeAll(lookupParams);
            lookupParams.addAll(paramKeys);
            lookupKey2 = new UrlMappingKey(controller, null, namespace, pluginName, httpMethod, version, lookupParams);
            mapping = this.mappingsLookup.get(lookupKey2);
            if (mapping == null) {
                lookupKey2.httpMethod = "*";
                mapping = this.mappingsLookup.get(lookupKey2);
            }
            if (mapping == null) {
                lookupParams.removeAll(paramKeys);
                lookupKeyModifiedParams = new UrlMappingKey(controller, null, namespace, pluginName, httpMethod, version, lookupParams);
                mapping = this.mappingsLookup.get(lookupKeyModifiedParams);
                if (mapping == null) {
                    lookupKeyModifiedParams.httpMethod = "*";
                    mapping = this.mappingsLookup.get(lookupKeyModifiedParams);
                }
            }
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            lookupParams = new HashSet<String>(this.DEFAULT_CONTROLLER_ONLY_PARAMS);
            paramKeys = new HashSet(params.keySet());
            paramKeys.removeAll(lookupParams);
            lookupParams.addAll(paramKeys);
            lookupKey2 = new UrlMappingKey(null, action, namespace, pluginName, httpMethod, version, lookupParams);
            mapping = this.mappingsLookup.get(lookupKey2);
            if (mapping == null) {
                lookupKey2.httpMethod = "*";
                mapping = this.mappingsLookup.get(lookupKey2);
            }
            if (mapping == null) {
                lookupParams.removeAll(paramKeys);
                lookupKeyModifiedParams = new UrlMappingKey(null, action, namespace, pluginName, httpMethod, version, lookupParams);
                mapping = this.mappingsLookup.get(lookupKeyModifiedParams);
                if (mapping == null) {
                    lookupKeyModifiedParams.httpMethod = "*";
                    mapping = this.mappingsLookup.get(lookupKeyModifiedParams);
                }
            }
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            lookupParams = new HashSet<String>(this.DEFAULT_CONTROLLER_PARAMS);
            paramKeys = new HashSet(params.keySet());
            paramKeys.removeAll(lookupParams);
            lookupParams.addAll(paramKeys);
            lookupKey2 = new UrlMappingKey(null, null, namespace, pluginName, httpMethod, version, lookupParams);
            mapping = this.mappingsLookup.get(lookupKey2);
            if (mapping == null) {
                lookupKey2.httpMethod = "*";
                mapping = this.mappingsLookup.get(lookupKey2);
            }
            if (mapping == null) {
                lookupParams.removeAll(paramKeys);
                lookupKeyModifiedParams = new UrlMappingKey(null, null, namespace, pluginName, httpMethod, version, lookupParams);
                mapping = this.mappingsLookup.get(lookupKeyModifiedParams);
                if (mapping == null) {
                    lookupKeyModifiedParams.httpMethod = "*";
                    mapping = this.mappingsLookup.get(lookupKeyModifiedParams);
                }
            }
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            lookupParams = new HashSet<String>(this.DEFAULT_NAMESPACE_PARAMS);
            paramKeys = new HashSet(params.keySet());
            paramKeys.removeAll(lookupParams);
            lookupParams.addAll(paramKeys);
            lookupKey2 = new UrlMappingKey(null, null, null, pluginName, httpMethod, version, lookupParams);
            mapping = this.mappingsLookup.get(lookupKey2);
            if (mapping == null) {
                lookupKey2.httpMethod = "*";
                mapping = this.mappingsLookup.get(lookupKey2);
            }
            if (mapping == null) {
                lookupParams.removeAll(paramKeys);
                lookupKeyModifiedParams = new UrlMappingKey(null, null, null, pluginName, httpMethod, version, lookupParams);
                mapping = this.mappingsLookup.get(lookupKeyModifiedParams);
                if (mapping == null) {
                    lookupKeyModifiedParams.httpMethod = "*";
                    mapping = this.mappingsLookup.get(lookupKeyModifiedParams);
                }
            }
        }
        if ((mapping == null || mapping instanceof ResponseCodeUrlMapping) && (mapping = this.mappingsLookup.get(lookupKey = new UrlMappingKey(controller, null, namespace, pluginName, httpMethod, version, lookupParams = new HashSet()))) == null) {
            lookupKey.httpMethod = "*";
            mapping = this.mappingsLookup.get(lookupKey);
        }
        UrlCreator creator = null;
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            if (useDefault) {
                creator = new DefaultUrlCreator(controller, action);
            }
        } else {
            creator = mapping;
        }
        return creator;
    }

    protected UrlMapping lookupMapping(String controller, String action, String namespace, String pluginName, String httpMethod, String version, Map params) {
        UrlMappingsListKey lookupKey = new UrlMappingsListKey(controller, action, namespace, pluginName, httpMethod, version);
        Collection<UrlMappingKey> mappingKeysSet = this.mappingsListLookup.get(lookupKey);
        String actionName = lookupKey.action;
        boolean secondAttempt = false;
        boolean isIndexAction = "index".equals(actionName);
        if (null == mappingKeysSet) {
            lookupKey.httpMethod = "*";
            mappingKeysSet = this.mappingsListLookup.get(lookupKey);
        }
        if (null == mappingKeysSet && actionName != null) {
            lookupKey.action = null;
            mappingKeysSet = this.mappingsListLookup.get(lookupKey);
            secondAttempt = true;
        }
        if (null == mappingKeysSet) {
            return null;
        }
        HashSet lookupParams = new HashSet(params.keySet());
        if (secondAttempt) {
            lookupParams.removeAll(this.DEFAULT_ACTION_PARAMS);
            lookupParams.addAll(this.DEFAULT_ACTION_PARAMS);
        }
        UrlMappingKey[] mappingKeys = mappingKeysSet.toArray(new UrlMappingKey[mappingKeysSet.size()]);
        for (int i = mappingKeys.length; i > 0; --i) {
            UrlMappingKey mappingKey = mappingKeys[i - 1];
            if (!lookupParams.containsAll(mappingKey.paramNames)) continue;
            UrlMapping mapping = this.mappingsLookup.get(mappingKey);
            if (this.canInferAction(actionName, secondAttempt, isIndexAction, mapping)) {
                return mapping;
            }
            if (secondAttempt) continue;
            return mapping;
        }
        return null;
    }

    private boolean canInferAction(String actionName, boolean secondAttempt, boolean indexAction, UrlMapping mapping) {
        return secondAttempt && (indexAction || mapping.hasRuntimeVariable("action"));
    }

    @Override
    public UrlMappingInfo match(String uri) {
        UrlMappingInfo info = null;
        if (this.cachedMatches.containsKey(uri)) {
            return this.cachedMatches.get(uri);
        }
        for (UrlMapping mapping : this.mappings) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to match URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "]"));
            }
            if ((info = mapping.match(uri)) == null) continue;
            this.cachedMatches.put(uri, info);
            break;
        }
        return info;
    }

    @Override
    public UrlMappingInfo[] matchAll(String uri) {
        return this.matchAll(uri, (String)null);
    }

    @Override
    public UrlMappingInfo[] matchAll(String uri, String httpMethod) {
        if (this.isExcluded(uri)) {
            return EMPTY_RESULTS;
        }
        boolean anyHttpMethod = httpMethod != null && httpMethod.equalsIgnoreCase("*");
        List<Object> matchingUrls = new ArrayList();
        UriToUrlMappingKey cacheKey = new UriToUrlMappingKey(uri, httpMethod, "*");
        if (this.cachedListMatches.containsKey(cacheKey)) {
            matchingUrls = this.cachedListMatches.get(cacheKey);
        } else {
            for (UrlMapping mapping : this.mappings) {
                String mappingHttpMethod;
                UrlMappingInfo current;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Attempting to match URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "]"));
                }
                if ((current = mapping.match(uri)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Matched URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "], adding to posibilities"));
                }
                if ((mappingHttpMethod = current.getHttpMethod()) != null && !anyHttpMethod && !mappingHttpMethod.equalsIgnoreCase("*") && !mappingHttpMethod.equalsIgnoreCase(httpMethod)) continue;
                matchingUrls.add(current);
            }
            this.cachedListMatches.put(cacheKey, matchingUrls);
        }
        return matchingUrls.toArray(new UrlMappingInfo[matchingUrls.size()]);
    }

    private boolean isExcluded(String uri) {
        if (this.excludePatterns != null) {
            for (Object excludePattern : this.excludePatterns) {
                if (!this.pathMatcher.match(excludePattern.toString(), uri)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public UrlMappingInfo[] matchAll(String uri, String httpMethod, String version) {
        List<Object> matchingUrls;
        if (this.isExcluded(uri)) {
            return EMPTY_RESULTS;
        }
        UriToUrlMappingKey cacheKey = new UriToUrlMappingKey(uri, httpMethod, version);
        if (this.cachedListMatches.containsKey(cacheKey)) {
            matchingUrls = this.cachedListMatches.get(cacheKey);
        } else {
            matchingUrls = new ArrayList();
            boolean anyHttpMethod = httpMethod != null && httpMethod.equals("*");
            boolean anyVersion = version != null && version.equals("*");
            for (UrlMapping mapping : this.mappings) {
                boolean isValidVersion;
                UrlMappingInfo current;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Attempting to match URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "]"));
                }
                if ((current = mapping.match(uri)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Matched URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "], adding to posibilities"));
                }
                String mappingHttpMethod = current.getHttpMethod();
                String mappingVersion = current.getVersion();
                boolean isValidHttpMethod = mappingHttpMethod == null || anyHttpMethod || mappingHttpMethod.equalsIgnoreCase("*") || mappingHttpMethod.equalsIgnoreCase(httpMethod);
                boolean bl = isValidVersion = mappingVersion == null || anyVersion || mappingVersion.equals("*") || mappingVersion.equals(version);
                if (!isValidHttpMethod || !isValidVersion) continue;
                matchingUrls.add(current);
            }
            this.cachedListMatches.put(cacheKey, matchingUrls);
        }
        return matchingUrls.toArray(new UrlMappingInfo[matchingUrls.size()]);
    }

    @Override
    public UrlMappingInfo[] matchAll(String uri, HttpMethod httpMethod) {
        return this.matchAll(uri, httpMethod.toString(), "*");
    }

    @Override
    public UrlMappingInfo[] matchAll(String uri, HttpMethod httpMethod, String version) {
        return this.matchAll(uri, httpMethod.toString(), version);
    }

    @Override
    public UrlMappingInfo matchStatusCode(int responseCode) {
        for (UrlMapping mapping : this.mappings) {
            UrlMappingInfo current;
            ResponseCodeUrlMapping responseCodeUrlMapping;
            if (!(mapping instanceof ResponseCodeUrlMapping) || (responseCodeUrlMapping = (ResponseCodeUrlMapping)mapping).getExceptionType() != null || (current = responseCodeUrlMapping.match(responseCode)) == null) continue;
            return current;
        }
        return null;
    }

    @Override
    public Set<HttpMethod> allowedMethods(String uri) {
        UrlMappingInfo[] urlMappingInfos = this.matchAll(uri, "*");
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        for (UrlMappingInfo urlMappingInfo : urlMappingInfos) {
            if (urlMappingInfo.getHttpMethod() == null || urlMappingInfo.getHttpMethod().equals("*")) {
                methods.addAll(Arrays.asList(HttpMethod.values()));
                break;
            }
            HttpMethod method = HttpMethod.valueOf((String)urlMappingInfo.getHttpMethod().toUpperCase());
            methods.add(method);
        }
        return Collections.unmodifiableSet(methods);
    }

    @Override
    public UrlMappingInfo matchStatusCode(int responseCode, Throwable e) {
        for (UrlMapping mapping : this.mappings) {
            ResponseCodeUrlMapping responseCodeUrlMapping;
            UrlMappingInfo current;
            if (!(mapping instanceof ResponseCodeUrlMapping) || (current = (responseCodeUrlMapping = (ResponseCodeUrlMapping)mapping).match(responseCode)) == null || responseCodeUrlMapping.getExceptionType() == null || !responseCodeUrlMapping.getExceptionType().isInstance(e)) continue;
            return current;
        }
        return null;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("URL Mappings");
        pw.println("------------");
        for (UrlMapping mapping : this.mappings) {
            pw.println(mapping);
        }
        pw.flush();
        return sw.toString();
    }

    public void setMaxWeightedCacheCapacity(int maxWeightedCacheCapacity) {
        this.maxWeightedCacheCapacity = maxWeightedCacheCapacity;
    }

    public void setUrlCreatorMaxWeightedCacheCapacity(int urlCreatorMaxWeightedCacheCapacity) {
        this.urlCreatorMaxWeightedCacheCapacity = urlCreatorMaxWeightedCacheCapacity;
    }

    class UrlMappingsList {
        private Map<UrlMappingsListKey, List<UrlMappingKey>> lookup = new HashMap<UrlMappingsListKey, List<UrlMappingKey>>();

        UrlMappingsList() {
        }

        public void put(UrlMappingsListKey key, UrlMappingKey mapping) {
            List<UrlMappingKey> mappingsList = this.lookup.get(key);
            if (null == mappingsList) {
                mappingsList = new ArrayList<UrlMappingKey>();
                this.lookup.put(key, mappingsList);
            }
            if (!mappingsList.contains(mapping)) {
                mappingsList.add(mapping);
                Collections.sort(mappingsList);
            }
        }

        public Collection<UrlMappingKey> get(UrlMappingsListKey key) {
            return this.lookup.get(key);
        }
    }

    class UrlMappingsListKey {
        String controller;
        String action;
        String namespace;
        String pluginName;
        String httpMethod;
        String version;

        public UrlMappingsListKey(String controller, String action, String namespace, String pluginName, String httpMethod, String version) {
            this.controller = controller;
            this.action = action;
            this.namespace = namespace;
            this.pluginName = pluginName;
            if (httpMethod != null) {
                this.httpMethod = httpMethod;
            }
            if (version != null) {
                this.version = version;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlMappingsListKey that = (UrlMappingsListKey)o;
            if (this.action != null && !this.action.equals(that.action)) {
                return false;
            }
            if (this.controller != null && !this.controller.equals(that.controller)) {
                return false;
            }
            if (this.namespace != null && !this.namespace.equals(that.namespace)) {
                return false;
            }
            if (this.pluginName != null && !this.pluginName.equals(that.pluginName)) {
                return false;
            }
            if (this.httpMethod != null && !this.httpMethod.equals(that.httpMethod)) {
                return false;
            }
            return this.version == null || this.version.equals(that.version);
        }

        public int hashCode() {
            int result = this.controller != null ? this.controller.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
            result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("controller", (Object)this.controller).append("action", (Object)this.action).append("namespace", (Object)this.namespace).append("plugin", (Object)this.pluginName).append("method", (Object)this.httpMethod).append("version", (Object)this.version).toString();
        }
    }

    class UrlMappingKey
    implements Comparable {
        String controller;
        String action;
        String namespace;
        String pluginName;
        String httpMethod;
        String version;
        Set<String> paramNames = Collections.emptySet();

        public UrlMappingKey(String controller, String action, String namespace, String pluginName, String httpMethod, String version, Set<String> paramNames) {
            this.controller = controller;
            this.action = action;
            this.namespace = namespace;
            this.pluginName = pluginName;
            if (httpMethod != null) {
                this.httpMethod = httpMethod;
            }
            if (version != null) {
                this.version = version;
            }
            this.paramNames = paramNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlMappingKey that = (UrlMappingKey)o;
            if (this.action != null && !this.action.equals(that.action)) {
                return false;
            }
            if (this.controller != null && !this.controller.equals(that.controller)) {
                return false;
            }
            if (this.namespace != null && !this.namespace.equals(that.namespace)) {
                return false;
            }
            if (this.pluginName != null && !this.pluginName.equals(that.pluginName)) {
                return false;
            }
            if (this.httpMethod != null && !this.httpMethod.equals(that.httpMethod)) {
                return false;
            }
            if (this.version != null && !this.version.equals(that.version)) {
                return false;
            }
            return this.paramNames.equals(that.paramNames);
        }

        public int hashCode() {
            int result = this.controller != null ? this.controller.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
            result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + this.paramNames.hashCode();
            return result;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("controller", (Object)this.controller).append("action", (Object)this.action).append("namespace", (Object)this.namespace).append("plugin", (Object)this.pluginName).append("httpMethod", (Object)this.httpMethod).append("params", this.paramNames).toString();
        }

        public int compareTo(Object o) {
            int comparison;
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (this == o) {
                return 0;
            }
            UrlMappingKey other = (UrlMappingKey)o;
            if (this.paramNames.size() < other.paramNames.size()) {
                return -1;
            }
            if (this.paramNames.size() > other.paramNames.size()) {
                return 1;
            }
            int n = comparison = this.controller != null ? this.controller.compareTo(other.controller) : 0;
            if (comparison != 0) {
                return comparison;
            }
            int n2 = comparison = this.action != null ? this.action.compareTo(other.action) : 0;
            if (comparison != 0) {
                return comparison;
            }
            int n3 = comparison = this.namespace != null ? this.namespace.compareTo(other.namespace) : 0;
            if (comparison != 0) {
                return comparison;
            }
            int n4 = comparison = this.pluginName != null ? this.pluginName.compareTo(other.pluginName) : 0;
            if (comparison != 0) {
                return comparison;
            }
            int n5 = comparison = this.httpMethod != null ? this.httpMethod.compareTo(other.httpMethod) : 0;
            if (comparison != 0) {
                return comparison;
            }
            return 0;
        }
    }

    class UriToUrlMappingKey {
        String uri;
        String httpMethod;
        String version;

        UriToUrlMappingKey(String uri, String httpMethod, String version) {
            this.uri = uri;
            this.httpMethod = httpMethod;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UriToUrlMappingKey that = (UriToUrlMappingKey)o;
            if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) {
                return false;
            }
            if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
                return false;
            }
            return !(this.uri != null ? !this.uri.equals(that.uri) : that.uri != null);
        }

        public int hashCode() {
            int result = this.uri != null ? this.uri.hashCode() : 0;
            result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }

    private static enum CustomListWeigher implements Weigher<List<UrlMappingInfo>>
    {
        INSTANCE;


        public int weightOf(List<UrlMappingInfo> values) {
            return values.size() + 1;
        }
    }
}

