/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import freemind.main.Resources;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import plugins.map.JCursorMapViewer;
import plugins.map.MapDialog;

public abstract class MapMarkerBase
extends JLabel
implements MapMarker {
    public static final int CIRCLE_RADIUS = 5;
    private static final int CIRCLE_DIAMETER = 10;
    protected MapDialog mMapDialog;
    boolean mSelected = false;
    protected static Logger logger = null;
    protected Color mBulletColor = Color.BLACK;
    protected Color mSelectedBackgroundColor = Color.GRAY;
    protected Color mBackgroundColor = Color.WHITE;
    protected float[] mTextWidthShorteningPerZoom = new float[]{0.0f, 0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.75f, 0.8f, 0.9f, 0.95f, 0.97f};
    protected float[] mTextHeightShorteningPerZoom = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.1f, 0.2f, 0.4f, 0.8f, 0.8f, 0.8f};

    public MapMarkerBase(MapDialog pMapDialog) {
        this.mMapDialog = pMapDialog;
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
    }

    public void paint(Graphics pGraphics, Point position) {
        Graphics g = pGraphics.create();
        this.paintCenter(g, position);
        if (this.isSelected()) {
            g.setColor(this.mSelectedBackgroundColor);
        } else {
            g.setColor(this.mBackgroundColor);
        }
        Point newPoint = MapMarkerBase.adjustToTextfieldLocation(position);
        JCursorMapViewer map = this.mMapDialog.getMap();
        int inversZoom = map.getFreeMindMapController().getMaxZoom() - map.getZoom();
        inversZoom = Math.min(this.mTextWidthShorteningPerZoom.length - 1, inversZoom);
        int destWidth = Math.min(this.getWidth(), map.getWidth());
        int normalWidth = (int)((float)destWidth * (1.0f - this.mTextWidthShorteningPerZoom[inversZoom]));
        int destHeight = Math.min(this.getHeight(), map.getHeight());
        int normalHeight = (int)((float)destHeight * (1.0f - this.mTextHeightShorteningPerZoom[inversZoom]));
        int node_y = newPoint.y;
        int node_x = newPoint.x;
        g.fillRect(node_x, node_y, normalWidth, normalHeight);
        g.setColor(this.mBulletColor);
        g.translate(node_x, node_y);
        g.clipRect(0, 0, normalWidth, normalHeight);
        this.paint(g);
        g.translate(-node_x, -node_y);
    }

    protected void paintCenter(Graphics g, Point position) {
        g.setColor(this.mBulletColor);
        g.fillOval(position.x - 5, position.y - 5, 10, 10);
        g.setColor(this.getForeground());
        g.drawOval(position.x - 5, position.y - 5, 10, 10);
    }

    public static Point adjustToTextfieldLocation(Point position) {
        Point newPoint = new Point(position);
        newPoint.x += 5;
        newPoint.y -= 5;
        return newPoint;
    }

    public boolean checkHit(int pX, int pY) {
        int x = pX;
        int y = pY;
        if ((x -= 5) >= 0 && (y += 5) >= 0 && x <= this.getWidth() && y <= this.getHeight()) {
            return true;
        }
        return pX * pX + pY * pY <= 25;
    }

    public void setSelected(boolean pSelected) {
        this.mSelected = pSelected;
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(this.getLat(), this.getLon());
    }
}

