/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "bravais.h"
#include "matrix.h"


bravais_TYP *point_group(bravais_TYP *R,
                         int option)
{

   bravais_TYP *RES;

   int i;


   RES = init_bravais(R->dim-1);

   RES->gen_no = R->gen_no;

   RES->gen = (matrix_TYP **)  malloc(RES->gen_no * sizeof(matrix_TYP *));

   for (i=0;i<RES->gen_no;i++){
      RES->gen[i] = copy_mat(R->gen[i]);
      real_mat(RES->gen[i],RES->gen[i]->rows-1,RES->gen[i]->cols);
      real_mat(RES->gen[i],RES->gen[i]->rows,RES->gen[i]->cols-1);
      Check_mat(RES->gen[i]);
   }


   if (option & 2){
      /* calculate the space of invarinat forms, we might need it */
      RES->form = formspace(RES->gen,RES->gen_no,1,&RES->form_no);
   }

   return RES;

}


