/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"

/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: chin_remainder.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/
/**************************************************************************\
@-------------------------------------------------------------------------
@ chinrest(x1, x2, p1, p2) calculates for positive primes p1,p2
@ and integers x1, x2 an integer x with
@   -(p1*p2)/2 < x < (p1*p2)/2 and
@ x kongruent x1 modulo p1 and x konguent x2 modulo p2
@-------------------------------------------------------------------------
\**************************************************************************/
int chin_remainder(x1, x2, p1, p2)
int x1, x2, p1, p2;
{

  int a1, a2;
  double q, q1, q2, res, waste;
  int y1, y2;

  a1 = p_inv(p2, p1);
  a2 = p_inv(p1, p2);
  q = ((double) p1) * ((double) p2);
  q1 = ((double) p2) * ((double) a1);
  q2 = ((double) p1) * ((double) a2);

    y1 = x1%p1;
    if(2*y1 <= -p1)
      y1 +=p1;
    if(2*y1 > p1)
      y1 -=p1;
    y2 = x2%p2;
    if(2*y2 <= -p2)
      y2 +=p2;
    if(2*y2 > p2)
      y2 -=p2;
    if(y1 == y2)
      return(y1);
    res = ((double) y1) * q1 + ((double) y2) * q2;
    modf(res/q, &waste);
    res = res - waste * q;
    while( (res/q) > 0.5)
       res = res -q;
    while( (res/q) < -0.5)
       res = res + q;
    return(((int) res));
}
